/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.util;

import java.util.Iterator;
import org.psjava.ds.Collection;
import org.psjava.util.IterableToString;
import org.psjava.util.MergedIterator;

public class MergedCollection {
    public static <T> Collection<T> wrap(final Iterable<? extends Collection<? extends T>> collections) {
        return new Collection<T>(){

            @Override
            public Iterator<T> iterator() {
                return MergedIterator.create(collections);
            }

            @Override
            public boolean isEmpty() {
                for (Collection c : collections) {
                    if (c.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int size() {
                int sum = 0;
                for (Collection c : collections) {
                    sum += c.size();
                }
                return sum;
            }

            public String toString() {
                return IterableToString.toString(this);
            }
        };
    }

    private MergedCollection() {
    }
}

