/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.workflow.actions.getpop;

import jakarta.mail.Flags;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.metadata.MailServerConnection;
import org.apache.hop.mail.workflow.actions.getpop.MailConnection;
import org.apache.hop.mail.workflow.actions.getpop.MailConnectionMeta;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="GET_POP", name="i18n::ActionGetPOP.Name", description="i18n::ActionGetPOP.Description", image="GetPOP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Mail", keywords={"i18n::ActionGetPOP.keyword"}, documentationUrl="/workflow/actions/getpop.html", actionTransformTypes={ActionTransformType.MAIL})
public class ActionGetPOP
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionGetPOP.class;
    private static final String CONST_PASSWORD = "password";
    private static final String CONST_MESSAGE_DELETED = "ActionGetMailsFromPOP.MessageDeleted";
    static final int FOLDER_OUTPUT = 0;
    static final int FOLDER_ATTACHMENTS = 1;
    public int actionType = 0;
    public int conditionReceivedDate;
    public int valueIMAPList;
    public int afterGetIMAP = 0;
    @HopMetadataProperty(key="servername")
    private String serverName = null;
    @HopMetadataProperty(key="username")
    private String userName = null;
    @HopMetadataProperty(password=true)
    private String password = null;
    @HopMetadataProperty(key="usessl")
    private boolean useSsl = false;
    @HopMetadataProperty(key="sslport")
    private String sslPort = null;
    @HopMetadataProperty(key="usexoauth2")
    private boolean useXOauth2 = false;
    @HopMetadataProperty(key="useproxy")
    private boolean useProxy = false;
    @HopMetadataProperty(key="proxyusername")
    private String proxyUsername = null;
    @HopMetadataProperty(key="outputdirectory")
    private String outputDirectory = null;
    @HopMetadataProperty(key="filenamepattern")
    private String filenamePattern = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    @HopMetadataProperty(key="firstmails")
    private String firstMails = null;
    @HopMetadataProperty(key="retrievemails")
    public int retrieveMails = 0;
    @HopMetadataProperty
    private boolean delete = false;
    @HopMetadataProperty
    private String protocol = !StringUtils.isEmpty((String)this.getConnectionName()) ? "POP3" : "POP3";
    @HopMetadataProperty(key="saveattachment")
    private boolean saveAttachment = true;
    @HopMetadataProperty(key="savemessage")
    private boolean saveMessage = true;
    @HopMetadataProperty(key="usedifferentfolderforattachment")
    private boolean useDifferentFolderForAttachment = false;
    @HopMetadataProperty(key="attachmentfolder")
    private String attachmentFolder = null;
    @HopMetadataProperty(key="attachmentwildcard")
    private String attachmentWildcard = null;
    @HopMetadataProperty(key="imapfirstmails")
    private String imapFirstMails = "0";
    @HopMetadataProperty(key="imapfolder")
    private String imapFolder = null;
    @HopMetadataProperty(key="sendersearch")
    private String senderSearch = null;
    @HopMetadataProperty(key="nottermsendersearch")
    private boolean notTermSenderSearch = false;
    @HopMetadataProperty(key="recipientsearch")
    private String recipientSearch = null;
    @HopMetadataProperty(key="subjectsearch")
    private String subjectSearch = null;
    @HopMetadataProperty(key="bodysearch")
    private String bodySearch = null;
    @HopMetadataProperty(key="nottermbodysearch")
    private boolean notTermBodySearch = false;
    @HopMetadataProperty
    private String receivedDate1 = null;
    @HopMetadataProperty
    private String receivedDate2 = null;
    @HopMetadataProperty(key="nottermsubjectsearch")
    private boolean notTermSubjectSearch = false;
    @HopMetadataProperty(key="nottermreceipientsearh")
    private boolean notTermRecipientSearch = false;
    @HopMetadataProperty(key="nottermreceiveddatesearch")
    private boolean notTermReceivedDateSearch = false;
    @HopMetadataProperty(key="includesubfolders")
    private boolean includeSubFolders = false;
    @HopMetadataProperty(key="movetoimapfolder")
    private String moveToIMAPFolder = null;
    @HopMetadataProperty(key="createmovetofolder")
    private boolean createMoveToFolder = false;
    @HopMetadataProperty(key="createlocalfolder")
    private boolean createLocalFolder = false;
    @HopMetadataProperty
    private String connectionName;
    private static final String DEFAULT_FILE_NAME_PATTERN = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String FILENAME_ID_PATTERN = "#IdFile#";
    private static final String FILENAME_SYS_DATE_OPEN = "{SYS|";
    private static final String FILENAME_SYS_DATE_CLOSE = "|}";
    private MailServerConnection connection;
    private MailConnection mailConn;
    private Pattern attachementPattern;

    public ActionGetPOP(String n) {
        super(n, "");
        this.valueIMAPList = !StringUtils.isEmpty((String)this.getConnectionName()) ? 0 : 0;
    }

    public ActionGetPOP() {
        this("");
    }

    public Object clone() {
        ActionGetPOP je = (ActionGetPOP)super.clone();
        return je;
    }

    public String getRealPort() {
        return this.resolve(this.getSslPort());
    }

    public String getRealOutputDirectory() {
        return this.resolve(this.getOutputDirectory());
    }

    public String getRealFilenamePattern() {
        return this.resolve(this.getFilenamePattern());
    }

    public String getRealUsername() {
        return this.resolve(this.getUserName());
    }

    public String getRealServername() {
        return this.resolve(this.getServerName());
    }

    public String getRealProxyUsername() {
        return this.resolve(this.getProxyUsername());
    }

    public String getRealPassword(String password) {
        return Utils.resolvePassword((IVariables)this.getVariables(), (String)password);
    }

    public String getRealAttachmentFolder() {
        return this.resolve(this.getAttachmentFolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setResult(false);
        this.connection = null;
        Object session = null;
        this.mailConn = null;
        Date beginDate = null;
        Date endDate = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        try {
            String realSearchBody;
            String realSearchSubject;
            String realSearchReceipient;
            String realSearchSender;
            boolean usePOP3 = this.connectionName != null ? this.getProtocol().equals("POP3") : this.getProtocol().equals("POP3");
            boolean moveafter = false;
            int nbrmailtoretrieve = usePOP3 ? (this.getRetrieveMails() == 2 ? Const.toInt((String)this.getFirstMails(), (int)0) : 0) : Const.toInt((String)this.getImapFirstMails(), (int)0);
            String realOutputFolder = this.createOutputDirectory(0);
            String targetAttachmentFolder = this.createOutputDirectory(1);
            String realMoveToIMAPFolder = this.resolve(this.getMoveToIMAPFolder());
            if (StringUtils.isEmpty((String)this.connectionName)) {
                if (this.getProtocol().equals("IMAP") && this.getActionType() == 1 || this.getActionType() == 0 && this.getAfterGetIMAP() == 2) {
                    if (Utils.isEmpty((CharSequence)realMoveToIMAPFolder)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.MoveToIMAPFolderEmpty", (String[])new String[0]));
                    }
                    moveafter = true;
                }
            } else if (this.getProtocol().equals("IMAP") && this.getActionType() == 1 || this.getActionType() == 0 && this.getAfterGetIMAP() == 2) {
                if (Utils.isEmpty((CharSequence)realMoveToIMAPFolder)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.MoveToIMAPFolderEmpty", (String[])new String[0]));
                }
                moveafter = true;
            }
            if (StringUtils.isEmpty((String)this.connectionName)) {
                switch (this.getConditionReceivedDate()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        realBeginDate = this.resolve(this.getReceivedDate1());
                        if (Utils.isEmpty((CharSequence)realBeginDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        break;
                    }
                    case 4: {
                        realBeginDate = this.resolve(this.getReceivedDate1());
                        if (Utils.isEmpty((CharSequence)realBeginDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        realEndDate = this.resolve(this.getReceivedDate2());
                        if (Utils.isEmpty((CharSequence)realEndDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        endDate = df.parse(realEndDate);
                        break;
                    }
                }
            } else {
                switch (this.getConditionReceivedDate()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        realBeginDate = this.resolve(this.getReceivedDate1());
                        if (Utils.isEmpty((CharSequence)realBeginDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        break;
                    }
                    case 4: {
                        realBeginDate = this.resolve(this.getReceivedDate1());
                        if (Utils.isEmpty((CharSequence)realBeginDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        realEndDate = this.resolve(this.getReceivedDate2());
                        if (Utils.isEmpty((CharSequence)realEndDate)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        endDate = df.parse(realEndDate);
                        break;
                    }
                }
            }
            String realserver = this.getRealServername();
            String realusername = this.getRealUsername();
            String realpassword = this.getRealPassword(this.getPassword());
            String realFilenamePattern = this.getRealFilenamePattern();
            int realport = Const.toInt((String)this.resolve(this.sslPort), (int)-1);
            String realIMAPFolder = this.resolve(this.getImapFolder());
            String realProxyUsername = this.getRealProxyUsername();
            this.initVariables();
            if (!StringUtils.isEmpty((String)this.connectionName)) {
                try {
                    this.connection = (MailServerConnection)this.getMetadataProvider().getSerializer(MailServerConnection.class).load(this.connectionName);
                }
                catch (HopException e) {
                    throw new RuntimeException("Mail server connection '" + this.connectionName + "' could not be found", e);
                }
                try {
                    this.connection.getSession(this.getVariables());
                    this.connection.getStore().connect();
                }
                catch (Exception e) {
                    throw new RuntimeException("A connection to mail server connection '" + this.connectionName + "' could not be established", e);
                }
            }
            this.mailConn = new MailConnection(this.getLogChannel(), MailConnectionMeta.getProtocolFromString(this.getProtocol(), 1), realserver, realport, realusername, realpassword, this.isUseSsl(), this.isUseXOauth2(), this.isUseProxy(), realProxyUsername);
            this.mailConn.connect();
            if (moveafter) {
                if (this.connection != null) {
                    this.connection.setDestinationFolder(realMoveToIMAPFolder, this.isCreateMoveToFolder());
                } else {
                    this.mailConn.setDestinationFolder(realMoveToIMAPFolder, this.isCreateMoveToFolder());
                }
            }
            if (!Utils.isEmpty((CharSequence)(realSearchSender = this.resolve(this.getSenderSearch())))) {
                if (this.connection != null) {
                    this.connection.setSenderTerm(realSearchSender, this.isNotTermSenderSearch());
                } else {
                    this.mailConn.setSenderTerm(realSearchSender, this.isNotTermSenderSearch());
                }
            }
            if (!Utils.isEmpty((CharSequence)(realSearchReceipient = this.resolve(this.getRecipientSearch())))) {
                if (this.connection != null) {
                    this.connection.setReceipientTerm(realSearchReceipient);
                } else {
                    this.mailConn.setReceipientTerm(realSearchReceipient);
                }
            }
            if (!Utils.isEmpty((CharSequence)(realSearchSubject = this.resolve(this.getSubjectSearch())))) {
                if (this.connection != null) {
                    this.connection.setSubjectTerm(realSearchSubject, this.isNotTermSubjectSearch());
                } else {
                    this.mailConn.setSubjectTerm(realSearchSubject, this.isNotTermSubjectSearch());
                }
            }
            if (!Utils.isEmpty((CharSequence)(realSearchBody = this.resolve(this.getBodySearch())))) {
                if (this.connection != null) {
                    this.connection.setBodyTerm(realSearchBody, this.isNotTermBodySearch());
                } else {
                    this.mailConn.setBodyTerm(realSearchBody, this.isNotTermBodySearch());
                }
            }
            if (this.connection != null) {
                switch (this.getConditionReceivedDate()) {
                    case 1: {
                        this.connection.setReceivedDateTermEQ(beginDate);
                        break;
                    }
                    case 3: {
                        this.connection.setReceivedDateTermGT(beginDate);
                        break;
                    }
                    case 2: {
                        this.connection.setReceivedDateTermLT(beginDate);
                        break;
                    }
                    case 4: {
                        this.connection.setReceivedDateTermBetween(beginDate, endDate);
                        break;
                    }
                }
            } else {
                switch (this.getConditionReceivedDate()) {
                    case 1: {
                        this.mailConn.setReceivedDateTermEQ(beginDate);
                        break;
                    }
                    case 3: {
                        this.mailConn.setReceivedDateTermGT(beginDate);
                        break;
                    }
                    case 2: {
                        this.mailConn.setReceivedDateTermLT(beginDate);
                        break;
                    }
                    case 4: {
                        this.mailConn.setReceivedDateTermBetween(beginDate, endDate);
                        break;
                    }
                }
            }
            if (usePOP3) {
                if (this.getRetrieveMails() == 1) {
                    if (this.connection != null) {
                        this.connection.setFlagTermUnread();
                    } else {
                        this.mailConn.setFlagTermUnread();
                    }
                }
            } else if (this.connection != null) {
                switch (this.getValueIMAPList()) {
                    case 1: {
                        this.connection.setFlagTermNew();
                        break;
                    }
                    case 2: {
                        this.connection.setFlagTermOld();
                        break;
                    }
                    case 3: {
                        this.connection.setFlagTermRead();
                        break;
                    }
                    case 4: {
                        this.connection.setFlagTermUnread();
                        break;
                    }
                    case 5: {
                        this.connection.setFlagTermFlagged();
                        break;
                    }
                    case 6: {
                        this.connection.setFlagTermNotFlagged();
                        break;
                    }
                    case 7: {
                        this.connection.setFlagTermDraft();
                        break;
                    }
                    case 8: {
                        this.connection.setFlagTermNotDraft();
                        break;
                    }
                }
            } else {
                switch (this.getValueIMAPList()) {
                    case 1: {
                        this.mailConn.setFlagTermNew();
                        break;
                    }
                    case 2: {
                        this.mailConn.setFlagTermOld();
                        break;
                    }
                    case 3: {
                        this.mailConn.setFlagTermRead();
                        break;
                    }
                    case 4: {
                        this.mailConn.setFlagTermUnread();
                        break;
                    }
                    case 5: {
                        this.mailConn.setFlagTermFlagged();
                        break;
                    }
                    case 6: {
                        this.mailConn.setFlagTermNotFlagged();
                        break;
                    }
                    case 7: {
                        this.mailConn.setFlagTermDraft();
                        break;
                    }
                    case 8: {
                        this.mailConn.setFlagTermNotDraft();
                        break;
                    }
                }
            }
            this.fetchOneFolder(usePOP3, realIMAPFolder, realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
            if (this.isIncludeSubFolders()) {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetPOP.FetchingSubFolders", (String[])new String[0]));
                }
                String[] subfolders = null;
                subfolders = this.connection != null ? this.connection.returnAllFolders() : this.mailConn.returnAllFolders();
                if (subfolders.length == 0) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetPOP.NoSubFolders", (String[])new String[0]));
                    }
                } else {
                    for (int i = 0; i < subfolders.length; ++i) {
                        this.fetchOneFolder(usePOP3, subfolders[i], realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
                    }
                }
            }
            result.setResult(true);
            if (this.connection != null) {
                result.setNrFilesRetrieved((long)this.connection.getSavedAttachedFilesCounter());
                result.setNrLinesWritten((long)this.connection.getSavedMessagesCounter());
                result.setNrLinesDeleted((long)this.connection.getDeletedMessagesCounter());
                result.setNrLinesUpdated((long)this.connection.getMovedMessagesCounter());
            } else {
                result.setNrFilesRetrieved((long)this.mailConn.getSavedAttachedFilesCounter());
                result.setNrLinesWritten((long)this.mailConn.getSavedMessagesCounter());
                result.setNrLinesDeleted((long)this.mailConn.getDeletedMessagesCounter());
                result.setNrLinesUpdated((long)this.mailConn.getMovedMessagesCounter());
            }
            if (this.isDetailed()) {
                this.logDetailed("=======================================");
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.SavedMessages", (String[])new String[]{"" + result.getNrLinesWritten()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.DeletedMessages", (String[])new String[]{"" + result.getNrLinesDeleted()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.MovedMessages", (String[])new String[]{"" + result.getNrLinesUpdated()}));
                if ((this.connection != null && this.getActionType() == 0 || this.connection == null && this.getActionType() == 0) && this.isSaveAttachment()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.AttachedMessagesSuccess", (String[])new String[]{"" + result.getNrFilesRetrieved()}));
                }
                this.logDetailed("=======================================");
            }
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Unexpected error: " + e.getMessage());
            this.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.disconnect();
                    this.connection = null;
                } else if (this.mailConn != null) {
                    this.mailConn.disconnect();
                    this.mailConn = null;
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    void fetchOneFolder(boolean usePOP3, String realIMAPFolder, String realOutputFolder, String targetAttachmentFolder, String realMoveToIMAPFolder, String realFilenamePattern, int nbrmailtoretrieve, SimpleDateFormat df) throws HopException {
        block60: {
            try {
                if (!usePOP3 && !Utils.isEmpty((CharSequence)realIMAPFolder)) {
                    if (this.connection != null) {
                        this.connection.openFolder(realIMAPFolder, true);
                    } else {
                        this.mailConn.openFolder(realIMAPFolder, true);
                    }
                } else if (this.connection != null) {
                    this.connection.openFolder(true);
                } else {
                    this.mailConn.openFolder(true);
                }
                if (this.connection != null) {
                    this.connection.retrieveMessages();
                } else {
                    this.mailConn.retrieveMessages();
                }
                int messagesCount = this.connection != null ? this.connection.getMessagesCount() : this.mailConn.getMessagesCount();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.TotalMessagesFolder.Label", (String[])new String[]{"" + messagesCount, this.connection != null ? Const.NVL((String)this.connection.getFolderName(), (String)"INBOX") : Const.NVL((String)this.mailConn.getFolderName(), (String)"INBOX")}));
                }
                int n = nbrmailtoretrieve > 0 ? (nbrmailtoretrieve > messagesCount ? messagesCount : nbrmailtoretrieve) : (messagesCount = messagesCount);
                if (messagesCount <= 0) break block60;
                if (this.connection != null) {
                    switch (this.getActionType()) {
                        case 2: {
                            if (nbrmailtoretrieve > 0) {
                                for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                    this.connection.fetchNext();
                                    this.connection.deleteMessage();
                                    if (!this.isDebug()) continue;
                                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + i}));
                                }
                            } else {
                                this.connection.deleteMessages(true);
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesDeleted", (String[])new String[]{"" + messagesCount}));
                                    break;
                                }
                            }
                            break block60;
                        }
                        case 1: {
                            if (nbrmailtoretrieve > 0) {
                                for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                    this.connection.fetchNext();
                                    this.connection.moveMessage();
                                    if (!this.isDebug()) continue;
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + i, realMoveToIMAPFolder}));
                                }
                            } else {
                                this.connection.moveMessages();
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesMoved", (String[])new String[]{"" + messagesCount, realMoveToIMAPFolder}));
                                    break;
                                }
                            }
                            break block60;
                        }
                        default: {
                            block20: for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                boolean okIMAP;
                                this.connection.fetchNext();
                                int messagenumber = this.connection.getMessage().getMessageNumber();
                                boolean okPOP3 = usePOP3;
                                boolean bl = okIMAP = !usePOP3;
                                if (!okPOP3 && !okIMAP) continue;
                                if (this.isDebug() && this.connection.getMessage() != null) {
                                    this.logDebug("--------------------------------------------------");
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageNumber.Label", (String[])new String[]{"" + messagenumber}));
                                    if (this.connection.getMessage().getReceivedDate() != null) {
                                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ReceivedDate.Label", (String[])new String[]{df.format(this.connection.getMessage().getReceivedDate())}));
                                    }
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ContentType.Label", (String[])new String[]{this.connection.getMessage().getContentType()}));
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailFrom.Label", (String[])new String[]{Const.NVL((String)this.connection.getMessage().getFrom()[0].toString(), (String)"")}));
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailSubject.Label", (String[])new String[]{Const.NVL((String)this.connection.getMessage().getSubject(), (String)"")}));
                                }
                                if (this.isSaveMessage()) {
                                    String localfilenameMessage = this.replaceTokens(realFilenamePattern, i);
                                    if (this.isDebug()) {
                                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.LocalFilename.Label", (String[])new String[]{localfilenameMessage}));
                                    }
                                    this.connection.saveMessageContentToFile(localfilenameMessage, realOutputFolder);
                                    this.connection.getMessage().setFlag(Flags.Flag.SEEN, true);
                                    if (this.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageSaved.Label", (String[])new String[]{"" + messagenumber, localfilenameMessage, realOutputFolder}));
                                    }
                                }
                                if (this.isSaveAttachment()) {
                                    this.connection.saveAttachedFiles(targetAttachmentFolder, this.attachementPattern);
                                }
                                if (usePOP3) {
                                    if (!this.isDelete()) continue;
                                    this.connection.deleteMessage();
                                    if (!this.isDebug()) continue;
                                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                    continue;
                                }
                                switch (this.getAfterGetIMAP()) {
                                    case 1: {
                                        this.connection.deleteMessage();
                                        if (!this.isDebug()) continue block20;
                                        this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                        continue block20;
                                    }
                                    case 2: {
                                        this.connection.moveMessage();
                                        if (!this.isDebug()) continue block20;
                                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + messagenumber, realMoveToIMAPFolder}));
                                        continue block20;
                                    }
                                }
                            }
                            break block60;
                        }
                    }
                    break block60;
                }
                switch (this.getActionType()) {
                    case 2: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                this.mailConn.fetchNext();
                                this.mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + i}));
                            }
                        } else {
                            this.mailConn.deleteMessages(true);
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesDeleted", (String[])new String[]{"" + messagesCount}));
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                this.mailConn.fetchNext();
                                this.mailConn.moveMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + i, realMoveToIMAPFolder}));
                            }
                        } else {
                            this.mailConn.moveMessages();
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesMoved", (String[])new String[]{"" + messagesCount, realMoveToIMAPFolder}));
                            }
                        }
                        break;
                    }
                    default: {
                        block23: for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                            boolean okIMAP;
                            this.mailConn.fetchNext();
                            int messagenumber = this.mailConn.getMessage().getMessageNumber();
                            boolean okPOP3 = usePOP3;
                            boolean bl = okIMAP = !usePOP3;
                            if (!okPOP3 && !okIMAP) continue;
                            if (this.isDebug() && this.mailConn.getMessage() != null) {
                                this.logDebug("--------------------------------------------------");
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageNumber.Label", (String[])new String[]{"" + messagenumber}));
                                if (this.mailConn.getMessage().getReceivedDate() != null) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ReceivedDate.Label", (String[])new String[]{df.format(this.mailConn.getMessage().getReceivedDate())}));
                                }
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ContentType.Label", (String[])new String[]{this.mailConn.getMessage().getContentType()}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailFrom.Label", (String[])new String[]{Const.NVL((String)this.mailConn.getMessage().getFrom()[0].toString(), (String)"")}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailSubject.Label", (String[])new String[]{Const.NVL((String)this.mailConn.getMessage().getSubject(), (String)"")}));
                            }
                            if (this.isSaveMessage()) {
                                String localfilenameMessage = this.replaceTokens(realFilenamePattern, i);
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.LocalFilename.Label", (String[])new String[]{localfilenameMessage}));
                                }
                                this.mailConn.saveMessageContentToFile(localfilenameMessage, realOutputFolder);
                                this.mailConn.getMessage().setFlag(Flags.Flag.SEEN, true);
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageSaved.Label", (String[])new String[]{"" + messagenumber, localfilenameMessage, realOutputFolder}));
                                }
                            }
                            if (this.isSaveAttachment()) {
                                this.mailConn.saveAttachedFiles(targetAttachmentFolder, this.attachementPattern);
                            }
                            if (usePOP3) {
                                if (!this.isDelete()) continue;
                                this.mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                continue;
                            }
                            switch (this.getAfterGetIMAP()) {
                                case 1: {
                                    this.mailConn.deleteMessage();
                                    if (!this.isDebug()) continue block23;
                                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                    continue block23;
                                }
                                case 2: {
                                    this.mailConn.moveMessage();
                                    if (!this.isDebug()) continue block23;
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + messagenumber, realMoveToIMAPFolder}));
                                    continue block23;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    private String replaceTokens(String aString, int idfile) {
        String localfilenameMessage = aString;
        localfilenameMessage = localfilenameMessage.replaceAll(FILENAME_ID_PATTERN, "" + (idfile + 1));
        localfilenameMessage = this.substituteDate(localfilenameMessage, FILENAME_SYS_DATE_OPEN, FILENAME_SYS_DATE_CLOSE, new Date());
        return localfilenameMessage;
    }

    private String substituteDate(String aString, String open, String close, Date datetime) {
        if (aString == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String rest = aString;
        int i = rest.indexOf(open);
        while (i > -1) {
            int j = rest.indexOf(close, i + open.length());
            if (j > -1) {
                String varName = rest.substring(i + open.length(), j);
                SimpleDateFormat dateFormat = new SimpleDateFormat(varName);
                String value = dateFormat.format(datetime);
                buffer.append(rest.substring(0, i));
                buffer.append((Object)value);
                rest = rest.substring(j + close.length());
            } else {
                buffer.append(rest);
                rest = "";
            }
            i = rest.indexOf(close);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    private void initVariables() {
        this.attachementPattern = null;
        String realAttachmentWildcard = this.resolve(this.getAttachmentWildcard());
        if (!Utils.isEmpty((CharSequence)realAttachmentWildcard)) {
            this.attachementPattern = Pattern.compile(realAttachmentWildcard);
        }
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "outputDirectory", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "SSLPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null && !Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    String createOutputDirectory(int folderType) throws HopException, FileSystemException, IllegalArgumentException {
        FileObject folder;
        if (folderType != 0 && folderType != 1) {
            throw new IllegalArgumentException("Invalid folderType argument");
        }
        String folderName = "";
        switch (folderType) {
            case 0: {
                folderName = this.getRealOutputDirectory();
                break;
            }
            case 1: {
                folderName = this.isSaveAttachment() && this.isUseDifferentFolderForAttachment() ? this.getRealAttachmentFolder() : this.getRealOutputDirectory();
            }
        }
        if (Utils.isEmpty((CharSequence)folderName)) {
            switch (folderType) {
                case 0: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OutputFolderEmpty", (String[])new String[0]));
                }
                case 1: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderEmpty", (String[])new String[0]));
                }
            }
        }
        if ((folder = HopVfs.getFileObject((String)folderName)).exists()) {
            if (folder.getType() != FileType.FOLDER) {
                switch (folderType) {
                    case 0: {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.NotAFolderNot", (String[])new String[]{folderName}));
                    }
                    case 1: {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderNotAFolder", (String[])new String[]{folderName}));
                    }
                }
            }
            if (this.isDebug()) {
                switch (folderType) {
                    case 0: {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Log.OutputFolderExists", (String[])new String[]{folderName}));
                        break;
                    }
                    case 1: {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Log.AttachmentFolderExists", (String[])new String[]{folderName}));
                    }
                }
            }
        } else if (this.isCreateLocalFolder()) {
            folder.createFolder();
        } else {
            switch (folderType) {
                case 0: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OutputFolderNotExist", (String[])new String[]{folderName}));
                }
                case 1: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderNotExist", (String[])new String[]{folderName}));
                }
            }
        }
        String returnValue = HopVfs.getFilename((FileObject)folder);
        try {
            folder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnValue;
    }

    @Generated
    public int getActionType() {
        return this.actionType;
    }

    @Generated
    public int getConditionReceivedDate() {
        return this.conditionReceivedDate;
    }

    @Generated
    public int getValueIMAPList() {
        return this.valueIMAPList;
    }

    @Generated
    public int getAfterGetIMAP() {
        return this.afterGetIMAP;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isUseSsl() {
        return this.useSsl;
    }

    @Generated
    public String getSslPort() {
        return this.sslPort;
    }

    @Generated
    public boolean isUseXOauth2() {
        return this.useXOauth2;
    }

    @Generated
    public boolean isUseProxy() {
        return this.useProxy;
    }

    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Generated
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    @Generated
    public String getFirstMails() {
        return this.firstMails;
    }

    @Generated
    public int getRetrieveMails() {
        return this.retrieveMails;
    }

    @Generated
    public boolean isDelete() {
        return this.delete;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public boolean isSaveAttachment() {
        return this.saveAttachment;
    }

    @Generated
    public boolean isSaveMessage() {
        return this.saveMessage;
    }

    @Generated
    public boolean isUseDifferentFolderForAttachment() {
        return this.useDifferentFolderForAttachment;
    }

    @Generated
    public String getAttachmentFolder() {
        return this.attachmentFolder;
    }

    @Generated
    public String getAttachmentWildcard() {
        return this.attachmentWildcard;
    }

    @Generated
    public String getImapFirstMails() {
        return this.imapFirstMails;
    }

    @Generated
    public String getImapFolder() {
        return this.imapFolder;
    }

    @Generated
    public String getSenderSearch() {
        return this.senderSearch;
    }

    @Generated
    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    @Generated
    public String getRecipientSearch() {
        return this.recipientSearch;
    }

    @Generated
    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    @Generated
    public String getBodySearch() {
        return this.bodySearch;
    }

    @Generated
    public boolean isNotTermBodySearch() {
        return this.notTermBodySearch;
    }

    @Generated
    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    @Generated
    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    @Generated
    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    @Generated
    public boolean isNotTermRecipientSearch() {
        return this.notTermRecipientSearch;
    }

    @Generated
    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    @Generated
    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Generated
    public String getMoveToIMAPFolder() {
        return this.moveToIMAPFolder;
    }

    @Generated
    public boolean isCreateMoveToFolder() {
        return this.createMoveToFolder;
    }

    @Generated
    public boolean isCreateLocalFolder() {
        return this.createLocalFolder;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public MailServerConnection getConnection() {
        return this.connection;
    }

    @Generated
    public MailConnection getMailConn() {
        return this.mailConn;
    }

    @Generated
    public Pattern getAttachementPattern() {
        return this.attachementPattern;
    }

    @Generated
    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    @Generated
    public void setConditionReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    @Generated
    public void setValueIMAPList(int valueIMAPList) {
        this.valueIMAPList = valueIMAPList;
    }

    @Generated
    public void setAfterGetIMAP(int afterGetIMAP) {
        this.afterGetIMAP = afterGetIMAP;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    @Generated
    public void setSslPort(String sslPort) {
        this.sslPort = sslPort;
    }

    @Generated
    public void setUseXOauth2(boolean useXOauth2) {
        this.useXOauth2 = useXOauth2;
    }

    @Generated
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Generated
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Generated
    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setFilenamePattern(String filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    @Generated
    public void setFirstMails(String firstMails) {
        this.firstMails = firstMails;
    }

    @Generated
    public void setRetrieveMails(int retrieveMails) {
        this.retrieveMails = retrieveMails;
    }

    @Generated
    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Generated
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setSaveAttachment(boolean saveAttachment) {
        this.saveAttachment = saveAttachment;
    }

    @Generated
    public void setSaveMessage(boolean saveMessage) {
        this.saveMessage = saveMessage;
    }

    @Generated
    public void setUseDifferentFolderForAttachment(boolean useDifferentFolderForAttachment) {
        this.useDifferentFolderForAttachment = useDifferentFolderForAttachment;
    }

    @Generated
    public void setAttachmentFolder(String attachmentFolder) {
        this.attachmentFolder = attachmentFolder;
    }

    @Generated
    public void setAttachmentWildcard(String attachmentWildcard) {
        this.attachmentWildcard = attachmentWildcard;
    }

    @Generated
    public void setImapFirstMails(String imapFirstMails) {
        this.imapFirstMails = imapFirstMails;
    }

    @Generated
    public void setImapFolder(String imapFolder) {
        this.imapFolder = imapFolder;
    }

    @Generated
    public void setSenderSearch(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    @Generated
    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    @Generated
    public void setRecipientSearch(String recipientSearch) {
        this.recipientSearch = recipientSearch;
    }

    @Generated
    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    @Generated
    public void setBodySearch(String bodySearch) {
        this.bodySearch = bodySearch;
    }

    @Generated
    public void setNotTermBodySearch(boolean notTermBodySearch) {
        this.notTermBodySearch = notTermBodySearch;
    }

    @Generated
    public void setReceivedDate1(String receivedDate1) {
        this.receivedDate1 = receivedDate1;
    }

    @Generated
    public void setReceivedDate2(String receivedDate2) {
        this.receivedDate2 = receivedDate2;
    }

    @Generated
    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    @Generated
    public void setNotTermRecipientSearch(boolean notTermRecipientSearch) {
        this.notTermRecipientSearch = notTermRecipientSearch;
    }

    @Generated
    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    @Generated
    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    @Generated
    public void setMoveToIMAPFolder(String moveToIMAPFolder) {
        this.moveToIMAPFolder = moveToIMAPFolder;
    }

    @Generated
    public void setCreateMoveToFolder(boolean createMoveToFolder) {
        this.createMoveToFolder = createMoveToFolder;
    }

    @Generated
    public void setCreateLocalFolder(boolean createLocalFolder) {
        this.createLocalFolder = createLocalFolder;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setConnection(MailServerConnection connection) {
        this.connection = connection;
    }

    @Generated
    public void setMailConn(MailConnection mailConn) {
        this.mailConn = mailConn;
    }

    @Generated
    public void setAttachementPattern(Pattern attachementPattern) {
        this.attachementPattern = attachementPattern;
    }
}

