/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.Tuple;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.JdbcV2Wrapper;
import com.clickhouse.jdbc.StatementImpl;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.metadata.ParameterMetaDataImpl;
import com.clickhouse.jdbc.metadata.ResultSetMetaDataImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement,
JdbcV2Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedStatementImpl.class);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private final Calendar defaultCalendar;
    private final String originalSql;
    private final String[] values;
    private final List<StringBuilder> batchValues;
    private final ParsedPreparedStatement parsedPreparedStatement;
    private final boolean insertStmtWithValues;
    private final String valueListTmpl;
    private final int[] paramPositionsInDataClause;
    private final int argCount;
    private final ParameterMetaData parameterMetaData;
    private ResultSetMetaData resultSetMetaData = null;
    public static final String NULL_LITERAL = "NULL";
    private static final Pattern REPLACE_Q_MARK_PATTERN = Pattern.compile("(\"[^\"]*\"|`[^`]*`|'[^']*')|(\\?)");

    public PreparedStatementImpl(ConnectionImpl connection, String sql, ParsedPreparedStatement parsedStatement) throws SQLException {
        super(connection);
        this.isPoolable = true;
        this.originalSql = sql;
        this.parsedPreparedStatement = parsedStatement;
        this.argCount = parsedStatement.getArgCount();
        this.defaultCalendar = connection.defaultCalendar;
        this.values = new String[this.argCount];
        this.parameterMetaData = new ParameterMetaDataImpl(this.values.length);
        int valueListStartPos = parsedStatement.getAssignValuesListStartPosition();
        int valueListStopPos = parsedStatement.getAssignValuesListStopPosition();
        if (parsedStatement.getAssignValuesGroups() == 1 && valueListStartPos > -1 && valueListStopPos > -1) {
            int[] positions = parsedStatement.getParamPositions();
            this.paramPositionsInDataClause = new int[this.argCount];
            for (int i = 0; i < this.argCount; ++i) {
                int p;
                this.paramPositionsInDataClause[i] = p = positions[i] - valueListStartPos;
            }
            this.valueListTmpl = this.originalSql.substring(valueListStartPos, valueListStopPos + 1);
            this.insertStmtWithValues = true;
            this.batchValues = new ArrayList<StringBuilder>();
        } else {
            this.paramPositionsInDataClause = new int[0];
            this.batchValues = Collections.emptyList();
            this.valueListTmpl = "";
            this.insertStmtWithValues = false;
        }
    }

    private String buildSQL() {
        StringBuilder compiledSql = new StringBuilder(this.originalSql);
        int posOffset = 0;
        int[] positions = this.parsedPreparedStatement.getParamPositions();
        for (int i = 0; i < this.argCount; ++i) {
            int p = positions[i] + posOffset;
            String val = this.values[i];
            compiledSql.replace(p, p + 1, val == null ? NULL_LITERAL : val);
            posOffset += val == null ? 0 : val.length() - 1;
        }
        return compiledSql.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return super.executeQueryImpl(this.buildSQL(), this.localSettings);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        return super.executeUpdateImpl(this.buildSQL(), this.localSettings);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        Arrays.fill(this.values, null);
    }

    int getParametersCount() {
        return this.values.length;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, 1111);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        if (this.parsedPreparedStatement.isHasResultSet()) {
            super.executeQueryImpl(this.buildSQL(), this.localSettings);
            return true;
        }
        super.executeUpdateImpl(this.buildSQL(), this.localSettings);
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.insertStmtWithValues) {
            StringBuilder valuesClause = new StringBuilder(this.valueListTmpl);
            int posOffset = 0;
            for (int i = 0; i < this.argCount; ++i) {
                int p = this.paramPositionsInDataClause[i] + posOffset;
                valuesClause.replace(p, p + 1, this.values[i]);
                posOffset += this.values[i].length() - 1;
            }
            this.batchValues.add(valuesClause);
        } else {
            super.addBatch(this.buildSQL());
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        if (this.insertStmtWithValues) {
            return this.executeInsertBatch().stream().mapToInt(Integer::intValue).toArray();
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String sql : this.batch) {
            results.add(this.executeUpdateImpl(sql, this.localSettings));
        }
        return results.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        if (this.insertStmtWithValues) {
            return this.executeInsertBatch().stream().mapToLong(Integer::longValue).toArray();
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String sql : this.batch) {
            results.add(this.executeUpdateImpl(sql, this.localSettings));
        }
        return results.stream().mapToLong(Integer::longValue).toArray();
    }

    private List<Integer> executeInsertBatch() throws SQLException {
        StringBuilder insertSql = new StringBuilder(this.originalSql.substring(0, this.parsedPreparedStatement.getAssignValuesListStartPosition()));
        for (StringBuilder valuesList : this.batchValues) {
            insertSql.append((CharSequence)valuesList).append(',');
        }
        insertSql.setLength(insertSql.length() - 1);
        int updateCount = super.executeUpdateImpl(insertSql.toString(), this.localSettings);
        if (updateCount == this.batchValues.size()) {
            return Collections.nCopies(this.batchValues.size(), 1);
        }
        return Collections.nCopies(this.batchValues.size(), -2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkClosed();
        if (!this.connection.config.isIgnoreUnsupportedRequests()) {
            throw new SQLFeatureNotSupportedException("Ref is not supported.", "0A000");
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null && this.currentResultSet == null) {
            if (this.parsedPreparedStatement.isHasResultSet()) {
                try {
                    String sql = PreparedStatementImpl.replaceQuestionMarks(this.originalSql, NULL_LITERAL);
                    TableSchema tSchema = this.connection.getClient().getTableSchemaFromQuery(sql);
                    this.resultSetMetaData = new ResultSetMetaDataImpl(tSchema.getColumns(), this.connection.getSchema(), this.connection.getCatalog(), tSchema.getTableName(), JdbcUtils.DATA_TYPE_CLASS_MAP);
                }
                catch (Exception e) {
                    LOG.warn("Failed to get schema for statement '{}'", (Object)this.originalSql);
                }
            }
            if (this.resultSetMetaData == null) {
                this.resultSetMetaData = new ResultSetMetaDataImpl(Collections.emptyList(), this.connection.getSchema(), this.connection.getCatalog(), "", JdbcUtils.DATA_TYPE_CLASS_MAP);
            }
        } else if (this.currentResultSet != null) {
            this.resultSetMetaData = this.currentResultSet.getMetaData();
        }
        return this.resultSetMetaData;
    }

    public static String replaceQuestionMarks(String sql, String replacement) {
        Matcher matcher = REPLACE_Q_MARK_PATTERN.matcher(sql);
        StringBuilder result = new StringBuilder();
        int lastPos = 0;
        while (matcher.find()) {
            String str;
            String text = matcher.group(1);
            if (text != null) {
                str = Matcher.quoteReplacement(text);
                result.append(sql, lastPos, matcher.start()).append(str);
                lastPos = matcher.end();
                continue;
            }
            if (matcher.group(2) == null) continue;
            str = Matcher.quoteReplacement(replacement);
            result.append(sql, lastPos, matcher.start()).append(str);
            lastPos = matcher.end();
        }
        result.append(sql, lastPos, sql.length());
        return result.toString();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlDateToInstant(x, cal));
    }

    protected Instant sqlDateToInstant(Date x, Calendar cal) {
        LocalDate d = x.toLocalDate();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth(), 0, 0, 0);
        return c.toInstant();
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlTimeToInstant(x, cal));
    }

    protected Instant sqlTimeToInstant(Time x, Calendar cal) {
        LocalTime t = x.toLocalTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(1970, 0, 1, t.getHour(), t.getMinute(), t.getSecond());
        return c.toInstant();
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(this.sqlTimestampToZDT(x, cal));
    }

    protected ZonedDateTime sqlTimestampToZDT(Timestamp x, Calendar cal) {
        LocalDateTime ldt = x.toLocalDateTime();
        Calendar c = (Calendar)(cal != null ? cal : this.defaultCalendar).clone();
        c.clear();
        c.set(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond());
        return c.toInstant().atZone(ZoneId.of("UTC")).withNano(x.getNanos());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkClosed();
        throw new SQLException("ROWID type is not supported by ClickHouse.", "0A000");
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, JDBCType.valueOf(targetSqlType), scaleOrLength);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.values[parameterIndex - 1] = PreparedStatementImpl.encodeObject(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new SQLException("addBatch(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        this.checkClosed();
        throw new SQLException("execute(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new SQLException("execute(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new SQLException("execute(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new SQLException("execute(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeLargeUpdate(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeLargeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeLargeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeLargeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeQuery(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeUpdate(String) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        throw new SQLException("executeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!", "42809");
    }

    private static String encodeObject(Object x) throws SQLException {
        LOG.trace("Encoding object: {}", x);
        try {
            if (x == null) {
                return NULL_LITERAL;
            }
            if (x instanceof String) {
                return "'" + PreparedStatementImpl.escapeString((String)x) + "'";
            }
            if (x instanceof Boolean) {
                return (Boolean)x != false ? "1" : "0";
            }
            if (x instanceof Date) {
                return "'" + DATE_FORMATTER.format(((Date)x).toLocalDate()) + "'";
            }
            if (x instanceof LocalDate) {
                return "'" + DATE_FORMATTER.format((LocalDate)x) + "'";
            }
            if (x instanceof Time) {
                return "'" + TIME_FORMATTER.format(((Time)x).toLocalTime()) + "'";
            }
            if (x instanceof LocalTime) {
                return "'" + TIME_FORMATTER.format((LocalTime)x) + "'";
            }
            if (x instanceof Timestamp) {
                return "'" + DATETIME_FORMATTER.format(((Timestamp)x).toLocalDateTime()) + "'";
            }
            if (x instanceof LocalDateTime) {
                return "'" + DATETIME_FORMATTER.format((LocalDateTime)x) + "'";
            }
            if (x instanceof OffsetDateTime) {
                return PreparedStatementImpl.encodeObject(((OffsetDateTime)x).toInstant());
            }
            if (x instanceof ZonedDateTime) {
                return PreparedStatementImpl.encodeObject(((ZonedDateTime)x).toInstant());
            }
            if (x instanceof Instant) {
                return "fromUnixTimestamp64Nano(" + (((Instant)x).getEpochSecond() * 1000000000L + (long)((Instant)x).getNano()) + ")";
            }
            if (x instanceof InetAddress) {
                return "'" + ((InetAddress)x).getHostAddress() + "'";
            }
            if (x instanceof Array) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                int i = 0;
                for (Object item : (Object[])((Array)x).getArray()) {
                    if (i > 0) {
                        listString.append(", ");
                    }
                    listString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Collection) {
                StringBuilder listString = new StringBuilder();
                listString.append("[");
                for (Object item : (Collection)x) {
                    listString.append(PreparedStatementImpl.encodeObject(item)).append(", ");
                }
                if (listString.length() > 1) {
                    listString.delete(listString.length() - 2, listString.length());
                }
                listString.append("]");
                return listString.toString();
            }
            if (x instanceof Map) {
                Map tmpMap = (Map)x;
                StringBuilder mapString = new StringBuilder();
                mapString.append("{");
                for (Object key : tmpMap.keySet()) {
                    mapString.append(PreparedStatementImpl.encodeObject(key)).append(": ").append(PreparedStatementImpl.encodeObject(tmpMap.get(key))).append(", ");
                }
                if (!tmpMap.isEmpty()) {
                    mapString.delete(mapString.length() - 2, mapString.length());
                }
                mapString.append("}");
                return mapString.toString();
            }
            if (x instanceof Reader) {
                int len;
                StringBuilder sb = new StringBuilder();
                Reader reader = (Reader)x;
                char[] buffer = new char[1024];
                while ((len = reader.read(buffer)) != -1) {
                    sb.append(buffer, 0, len);
                }
                return "'" + PreparedStatementImpl.escapeString(sb.toString()) + "'";
            }
            if (x instanceof InputStream) {
                int len;
                StringBuilder sb = new StringBuilder();
                InputStream is = (InputStream)x;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, len));
                }
                return "'" + PreparedStatementImpl.escapeString(sb.toString()) + "'";
            }
            if (x instanceof Object[]) {
                StringBuilder arrayString = new StringBuilder();
                arrayString.append("[");
                int i = 0;
                for (Object item : (Object[])x) {
                    if (i > 0) {
                        arrayString.append(", ");
                    }
                    arrayString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                arrayString.append("]");
                return arrayString.toString();
            }
            if (x instanceof Tuple) {
                StringBuilder tupleString = new StringBuilder();
                tupleString.append("(");
                Tuple t = (Tuple)x;
                Object[] values = t.getValues();
                int i = 0;
                for (Object item : values) {
                    if (i > 0) {
                        tupleString.append(", ");
                    }
                    tupleString.append(PreparedStatementImpl.encodeObject(item));
                    ++i;
                }
                tupleString.append(")");
                return tupleString.toString();
            }
            if (x instanceof UUID) {
                return "'" + PreparedStatementImpl.escapeString(((UUID)x).toString()) + "'";
            }
            return PreparedStatementImpl.escapeString(x.toString());
        }
        catch (Exception e) {
            LOG.error("Error encoding object", (Throwable)e);
            throw new SQLException("Error encoding object", "07000", e);
        }
    }

    private static String escapeString(String x) {
        return x.replace("\\", "\\\\").replace("'", "\\'");
    }
}

