/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;

public interface IPartitioner {
    public static IPartitioner global() {
        return StorageService.instance.getTokenMetadata().partitioner;
    }

    public static void validate(Collection<? extends AbstractBounds<?>> allBounds) {
        for (AbstractBounds<?> bounds : allBounds) {
            IPartitioner.validate(bounds);
        }
    }

    public static void validate(AbstractBounds<?> bounds) {
        if (IPartitioner.global() != bounds.left.getPartitioner()) {
            throw new AssertionError((Object)String.format("Partitioner in bounds serialization. Expected %s, was %s.", IPartitioner.global().getClass().getName(), bounds.left.getPartitioner().getClass().getName()));
        }
    }

    public DecoratedKey decorateKey(ByteBuffer var1);

    public Token midpoint(Token var1, Token var2);

    public Token split(Token var1, Token var2, double var3);

    public Token getMinimumToken();

    default public Token getMaximumToken() {
        throw new UnsupportedOperationException("If you are using a splitting partitioner, getMaximumToken has to be implemented");
    }

    public Token getToken(ByteBuffer var1);

    public Token getRandomToken();

    public Token getRandomToken(Random var1);

    public Token.TokenFactory getTokenFactory();

    public boolean preservesOrder();

    public Map<Token, Float> describeOwnership(List<Token> var1);

    public AbstractType<?> getTokenValidator();

    public AbstractType<?> partitionOrdering();

    default public Optional<Splitter> splitter() {
        return Optional.empty();
    }

    default public int getMaxTokenSize() {
        return Integer.MIN_VALUE;
    }
}

