/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.AutoValue_TestStreamEvaluatorFactory_TestStreamIndex;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectRunner;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.util.construction.TestStreamTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class TestStreamEvaluatorFactory
implements TransformEvaluatorFactory {
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;

    TestStreamEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> @Nullable @UnknownKeyFor @Initialized TransformEvaluator<InputT> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) {
        return this.createEvaluator(application);
    }

    @Override
    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    private <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @Nullable @Initialized ? super InputT> createEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, @UnknownKeyFor @NonNull @Initialized TestStream<OutputT>> application) {
        return new Evaluator(application, this.evaluationContext);
    }

    @AutoValue
    static abstract class TestStreamIndex<@UnknownKeyFor T> {
        TestStreamIndex() {
        }

        static <T> @UnknownKeyFor @NonNull @Initialized TestStreamIndex<T> of(@UnknownKeyFor @NonNull @Initialized TestStream<T> stream) {
            return new AutoValue_TestStreamEvaluatorFactory_TestStreamIndex<T>(stream, 0);
        }

        abstract @UnknownKeyFor @NonNull @Initialized TestStream<T> getTestStream();

        abstract @UnknownKeyFor @NonNull @Initialized int getIndex();

        @UnknownKeyFor @NonNull @Initialized TestStreamIndex<T> next() {
            return new AutoValue_TestStreamEvaluatorFactory_TestStreamIndex<T>(this.getTestStream(), this.getIndex() + 1);
        }
    }

    static class InputProvider<@UnknownKeyFor T>
    implements RootInputProvider<T, TestStreamIndex<T>, PBegin> {
        private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;

        InputProvider(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @NonNull @Initialized TestStreamIndex<T>>> getInitialInputs(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform, @UnknownKeyFor @NonNull @Initialized int targetParallelism) {
            DirectTestStreamFactory.DirectTestStream testStream = (DirectTestStreamFactory.DirectTestStream)transform.getTransform();
            CommittedBundle initialBundle = this.evaluationContext.createRootBundle().add(WindowedValue.valueInGlobalWindow(TestStreamIndex.of(testStream.original))).commit(BoundedWindow.TIMESTAMP_MAX_VALUE);
            return Collections.singleton(initialBundle);
        }
    }

    static class DirectTestStreamFactory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> {
        private final @UnknownKeyFor @NonNull @Initialized DirectRunner runner;
        static final @UnknownKeyFor @NonNull @Initialized String DIRECT_TEST_STREAM_URN = "beam:directrunner:transforms:test_stream:v1";

        DirectTestStreamFactory(@UnknownKeyFor @NonNull @Initialized DirectRunner runner) {
            this.runner = runner;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>>> transform) {
            try {
                return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), new DirectTestStream<T>(this.runner, TestStreamTranslation.getTestStream(transform)));
            }
            catch (IOException exc) {
                throw new RuntimeException(String.format("Transform could not be converted to %s", TestStream.class.getSimpleName()), exc);
            }
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }

        static class DirectTestStream<@UnknownKeyFor T>
        extends PTransform<PBegin, PCollection<T>> {
            private final transient @UnknownKeyFor @NonNull @Initialized DirectRunner runner;
            private final @UnknownKeyFor @NonNull @Initialized TestStream<T> original;

            @VisibleForTesting
            DirectTestStream(@UnknownKeyFor @NonNull @Initialized DirectRunner runner, @UnknownKeyFor @NonNull @Initialized TestStream<T> transform) {
                this.runner = runner;
                this.original = transform;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
                this.runner.setClockSupplier(new TestClockSupplier());
                return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED, this.original.getValueCoder());
            }
        }
    }

    private static class TestClockSupplier
    implements Supplier<Clock> {
        private TestClockSupplier() {
        }

        public @UnknownKeyFor @NonNull @Initialized Clock get() {
            return new TestClock();
        }
    }

    @VisibleForTesting
    static class TestClock
    implements Clock {
        private @UnknownKeyFor @NonNull @Initialized Instant currentTime = BoundedWindow.TIMESTAMP_MIN_VALUE;

        TestClock() {
        }

        public synchronized void advance(@UnknownKeyFor @NonNull @Initialized Duration amount) {
            this.currentTime = this.currentTime.plus((ReadableDuration)amount);
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized Instant now() {
            return this.currentTime;
        }
    }

    private static class Evaluator<@UnknownKeyFor T>
    implements TransformEvaluator<TestStreamIndex<T>> {
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized TestStream<T>> application;
        private final @UnknownKeyFor @NonNull @Initialized EvaluationContext context;
        private final @UnknownKeyFor @NonNull @Initialized StepTransformResult.Builder resultBuilder;

        private Evaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized TestStream<T>> application, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
            this.application = application;
            this.context = context;
            this.resultBuilder = StepTransformResult.withoutHold(application);
        }

        @Override
        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized TestStreamIndex<T>> element) throws @UnknownKeyFor @NonNull @Initialized Exception {
            TestStreamIndex<T> next;
            TestStreamIndex<T> streamIndex = element.getValue();
            List<TestStream.Event<T>> events = streamIndex.getTestStream().getEvents();
            int index = streamIndex.getIndex();
            Instant watermark = element.getTimestamp();
            TestStream.Event<T> event = events.get(index);
            if (event.getType().equals((Object)TestStream.EventType.ELEMENT)) {
                UncommittedBundle bundle = this.context.createBundle((PCollection)Iterables.getOnlyElement(this.application.getOutputs().values()));
                for (TimestampedValue elem : ((TestStream.ElementEvent)event).getElements()) {
                    bundle.add(WindowedValue.timestampedValueInGlobalWindow(elem.getValue(), elem.getTimestamp()));
                }
                this.resultBuilder.addOutput(bundle, new UncommittedBundle[0]);
            }
            if (event.getType().equals((Object)TestStream.EventType.WATERMARK)) {
                watermark = ((TestStream.WatermarkEvent)event).getWatermark();
            }
            if (event.getType().equals((Object)TestStream.EventType.PROCESSING_TIME)) {
                ((TestClock)this.context.getClock()).advance(((TestStream.ProcessingTimeEvent)event).getProcessingTimeAdvance());
            }
            if ((next = streamIndex.next()).getIndex() < events.size()) {
                this.resultBuilder.addUnprocessedElements(Collections.singleton(WindowedValue.timestampedValueInGlobalWindow(next, watermark)));
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @NonNull @Initialized TestStreamIndex<T>> finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.resultBuilder.build();
        }
    }
}

