/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Auth {
    private final VaultConfig config;

    public Auth(VaultConfig config) {
        this.config = config;
    }

    public AuthResponse createToken(UUID id, List<String> policies, Map<String, String> meta, Boolean noParent, Boolean noDefaultPolicy, String ttl, String displayName, Long numUses) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                JsonObject jsonObject = Json.object();
                if (id != null) {
                    jsonObject.add("id", id.toString());
                }
                if (policies != null && !policies.isEmpty()) {
                    jsonObject.add("policies", Json.array(policies.toArray(new String[policies.size()])));
                }
                if (meta != null && !meta.isEmpty()) {
                    JsonObject metaMap = Json.object();
                    for (Map.Entry<String, String> entry : meta.entrySet()) {
                        metaMap.add(entry.getKey(), entry.getValue());
                    }
                    jsonObject.add("meta", metaMap);
                }
                if (noParent != null) {
                    jsonObject.add("no_parent", noParent);
                }
                if (noDefaultPolicy != null) {
                    jsonObject.add("no_default_policy", noDefaultPolicy);
                }
                if (ttl != null) {
                    jsonObject.add("ttl", ttl);
                }
                if (displayName != null) {
                    jsonObject.add("display_name", displayName);
                }
                if (numUses != null) {
                    jsonObject.add("num_uses", numUses);
                }
                String requestJson = jsonObject.toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/token/create").header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    @Deprecated
    public AuthResponse loginByAppID(String path, String appId, String userId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("app_id", appId).add("user_id", userId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByAppRole(String path, String roleId, String secretId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("role_id", roleId).add("secret_id", secretId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path + "/login").body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByUserPass(String username, String password) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("password", password).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/userpass/login/" + username).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByGithub(String githubToken) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("token", githubToken).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/github/login").body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse renewSelf() throws VaultException {
        return this.renewSelf(-1L);
    }

    public AuthResponse renewSelf(long increment) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("increment", increment).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/token/renew-self").header("X-Vault-Token", this.config.getToken()).body(increment < 0L ? null : requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslPemUTF8(this.config.getSslPemUTF8()).sslVerification(this.config.isSslVerify() != null ? this.config.isSslVerify() : null).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }
}

