/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectNewPartitionsAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DetectNewPartitionsAction.class);
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadataDao dao;
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadataMapper mapper;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized Duration resumeDuration;

    public DetectNewPartitionsAction(@UnknownKeyFor @NonNull @Initialized PartitionMetadataDao dao, @UnknownKeyFor @NonNull @Initialized PartitionMetadataMapper mapper, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized Duration resumeDuration) {
        this.dao = dao;
        this.mapper = mapper;
        this.metrics = metrics;
        this.resumeDuration = resumeDuration;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation run(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator) {
        Timestamp readTimestamp = ((TimestampRange)tracker.currentRestriction()).getFrom();
        Timestamp minWatermark = this.dao.getUnfinishedMinWatermark();
        if (minWatermark != null) {
            return this.processPartitions(tracker, receiver, watermarkEstimator, minWatermark, readTimestamp);
        }
        return this.terminate(tracker);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation processPartitions(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized Timestamp minWatermark, @UnknownKeyFor @NonNull @Initialized Timestamp readTimestamp) {
        watermarkEstimator.setWatermark(new Instant((Object)minWatermark.toSqlTimestamp()));
        List<PartitionMetadata> partitions = this.getAllPartitionsCreatedAfter(readTimestamp);
        TreeMap<Timestamp, List<PartitionMetadata>> batches = this.batchByCreatedAt(partitions);
        return this.schedulePartitions(tracker, receiver, minWatermark, batches);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> getAllPartitionsCreatedAfter(@UnknownKeyFor @NonNull @Initialized Timestamp readTimestamp) {
        ArrayList<PartitionMetadata> partitions = new ArrayList<PartitionMetadata>();
        try (ResultSet resultSet = this.dao.getAllPartitionsCreatedAfter(readTimestamp);){
            while (resultSet.next()) {
                PartitionMetadata partition = this.mapper.from(resultSet.getCurrentRowAsStruct());
                partitions.add(partition);
            }
        }
        LOG.info("Found {} to be scheduled (readTimestamp = {})", (Object)partitions.size(), (Object)readTimestamp);
        return partitions;
    }

    private @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized Timestamp, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata>> batchByCreatedAt(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> partitions) {
        return partitions.stream().collect(Collectors.groupingBy(PartitionMetadata::getCreatedAt, TreeMap::new, Collectors.toList()));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation schedulePartitions(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver, @UnknownKeyFor @NonNull @Initialized Timestamp minWatermark, @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized Timestamp, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata>> batches) {
        ArrayList<PartitionMetadata> batchPartitionsDifferentCreatedAt = new ArrayList<PartitionMetadata>();
        int numTimestampsHandledSofar = 0;
        for (Map.Entry<Timestamp, List<PartitionMetadata>> batch : batches.entrySet()) {
            Timestamp batchCreatedAt = batch.getKey();
            List<PartitionMetadata> batchPartitionsSameCreatedAt = batch.getValue();
            batchPartitionsDifferentCreatedAt.addAll(batchPartitionsSameCreatedAt);
            if (batchPartitionsDifferentCreatedAt.size() < 200 && ++numTimestampsHandledSofar != batches.size()) continue;
            Timestamp scheduledAt = this.updateBatchToScheduled(batchPartitionsDifferentCreatedAt);
            if (!tracker.tryClaim((Object)batchCreatedAt)) {
                return DoFn.ProcessContinuation.stop();
            }
            this.outputBatch(receiver, minWatermark, batchPartitionsDifferentCreatedAt, scheduledAt);
            batchPartitionsDifferentCreatedAt = new ArrayList();
        }
        return DoFn.ProcessContinuation.resume().withResumeDelay(this.resumeDuration);
    }

    private @UnknownKeyFor @NonNull @Initialized Timestamp updateBatchToScheduled(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> batchPartitions) {
        List<String> batchPartitionTokens = batchPartitions.stream().map(PartitionMetadata::getPartitionToken).collect(Collectors.toList());
        return this.dao.updateToScheduled(batchPartitionTokens);
    }

    private void outputBatch(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> receiver, @UnknownKeyFor @NonNull @Initialized Timestamp minWatermark, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionMetadata> batchPartitions, @UnknownKeyFor @NonNull @Initialized Timestamp scheduledAt) {
        for (PartitionMetadata partition : batchPartitions) {
            Timestamp createdAt = partition.getCreatedAt();
            PartitionMetadata updatedPartition = partition.toBuilder().setScheduledAt(scheduledAt).build();
            LOG.info("[{}] Outputting partition at {} with start time {} and end time {}", new Object[]{updatedPartition.getPartitionToken(), updatedPartition.getScheduledAt(), updatedPartition.getStartTimestamp(), updatedPartition.getEndTimestamp()});
            receiver.outputWithTimestamp((Object)partition, new Instant((Object)minWatermark.toSqlTimestamp()));
            this.metrics.incPartitionRecordCount();
            this.metrics.updatePartitionCreatedToScheduled(new Duration(createdAt.toSqlTimestamp().getTime(), scheduledAt.toSqlTimestamp().getTime()));
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation terminate(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized TimestampRange, @UnknownKeyFor @NonNull @Initialized Timestamp> tracker) {
        tracker.tryClaim((Object)((TimestampRange)tracker.currentRestriction()).getTo());
        LOG.info("All partitions have been processed, stopping");
        return DoFn.ProcessContinuation.stop();
    }
}

