/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.DestinationUnreachable;
import com.ibm.as400.util.commtrace.EchoReplyRequest;
import com.ibm.as400.util.commtrace.EchoRequest;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.ICMP6Header;
import com.ibm.as400.util.commtrace.MulticastListenerDone;
import com.ibm.as400.util.commtrace.MulticastListenerQuery;
import com.ibm.as400.util.commtrace.MulticastListenerReport;
import com.ibm.as400.util.commtrace.NeighborAdvertisement;
import com.ibm.as400.util.commtrace.NeighborSolicitation;
import com.ibm.as400.util.commtrace.PacketTooBig;
import com.ibm.as400.util.commtrace.ParameterProblem;
import com.ibm.as400.util.commtrace.Redirect;
import com.ibm.as400.util.commtrace.RouterAdvertisement;
import com.ibm.as400.util.commtrace.RouterSolicitation;
import com.ibm.as400.util.commtrace.TimeExceeded;
import com.ibm.as400.util.commtrace.UnknownMessage;

public abstract class Message
extends ICMP6Header {
    public static final int MSGUNK = 0;
    public static final int RTRSOL = 133;
    public static final int RTRADV = 134;
    public static final int NGHSOL = 135;
    public static final int NGHADV = 136;
    public static final int REDR = 137;
    public static final int DSTUNR = 1;
    public static final int PKTTOBIG = 2;
    public static final int TIMEEXC = 3;
    public static final int PARMPROB = 4;
    public static final int ECHOREQ = 128;
    public static final int ECHQRPL = 129;
    public static final int MLTLSTQRY = 130;
    public static final int MLTLSTRPT = 131;
    public static final int MLTLSTDNE = 132;
    static final String OFFPKT = "Offending IPPacket";
    static final String PTR = "Pointer";
    static final String ID = "Identifier";
    static final String SEQNUM = "SequenceNumber";
    static final String CURHOPLIMIT = "CurHopLimit";
    static final String RTRLIFETIME = "RouterLifeTime";
    static final String RCHTIME = "ReachableTime";
    static final String RETRANSTIME = "RetransTimer";
    static final String O = "O";
    static final String M = "M";
    static final String TARGET = "Target";
    static final String FLAGS = "Flags";
    static final String RTR = "Router";
    static final String SOL = "Solicited";
    static final String OVR = "Override";
    static final String DST = "Destination";
    static final String MAX = "Max Response Delay";
    static final String ADDR = "Address";

    Message(BitBuf data) {
        super(data);
    }

    static Message createMessage(byte t, BitBuf data) {
        int msgtype = t & 0xFF;
        if (msgtype == 133) {
            return new RouterSolicitation(data);
        }
        if (msgtype == 134) {
            return new RouterAdvertisement(data);
        }
        if (msgtype == 135) {
            return new NeighborSolicitation(data);
        }
        if (msgtype == 136) {
            return new NeighborAdvertisement(data);
        }
        if (msgtype == 137) {
            return new Redirect(data);
        }
        if (msgtype == 1) {
            return new DestinationUnreachable(data);
        }
        if (msgtype == 2) {
            return new PacketTooBig(data);
        }
        if (msgtype == 3) {
            return new TimeExceeded(data);
        }
        if (msgtype == 4) {
            return new ParameterProblem(data);
        }
        if (msgtype == 128) {
            return new EchoRequest(data);
        }
        if (msgtype == 129) {
            return new EchoReplyRequest(data);
        }
        if (msgtype == 130) {
            return new MulticastListenerQuery(data);
        }
        if (msgtype == 131) {
            return new MulticastListenerReport(data);
        }
        if (msgtype == 132) {
            return new MulticastListenerDone(data);
        }
        return new UnknownMessage(data);
    }

    @Override
    public String toString(FormatProperties filter) {
        return this.printnext(filter);
    }
}

