/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.util.IPluginProperty;
import org.apache.hop.core.util.KeyValue;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class StringPluginProperty
extends KeyValue<String>
implements IPluginProperty {
    private static final long serialVersionUID = -2990345692552430357L;

    public StringPluginProperty(String key) throws IllegalArgumentException {
        super(key, "");
    }

    @Override
    public boolean evaluate() {
        return StringUtils.isNotBlank((String)((String)this.getValue()));
    }

    @Override
    public void appendXml(StringBuilder builder) {
        builder.append(XmlHandler.addTagValue((String)this.getKey(), (String)((String)this.getValue())));
    }

    @Override
    public void loadXml(Node node) {
        String value = XmlHandler.getTagValue((Node)node, (String)this.getKey());
        this.setValue(value);
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.put(this.getKey(), (String)this.getValue());
    }

    @Override
    public void readFromPreferences(Preferences node) {
        this.setValue(node.get(this.getKey(), (String)this.getValue()));
    }
}

