/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public final class SerializableThrowable
implements Serializable {
    private final @Nullable @UnknownKeyFor @Initialized Throwable throwable;
    private final @UnknownKeyFor @NonNull @Initialized StackTraceElement @Nullable @UnknownKeyFor @Initialized [] stackTrace;

    public SerializableThrowable(@Nullable @UnknownKeyFor @Initialized Throwable t) {
        this.throwable = t;
        this.stackTrace = t == null ? null : t.getStackTrace();
    }

    public @Nullable @UnknownKeyFor @Initialized Throwable getThrowable() {
        return this.throwable;
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        is.defaultReadObject();
        if (this.throwable != null) {
            this.throwable.setStackTrace(this.stackTrace);
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableThrowable that = (SerializableThrowable)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }
}

