/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import net.minidev.json.JSONObject;

class AdalAccessTokenResponse
extends OIDCTokenResponse {
    private String resource;

    AdalAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idToken) {
        super(new OIDCTokens(idToken, accessToken, refreshToken));
    }

    AdalAccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken, String idToken, String resource) {
        this(accessToken, refreshToken, idToken);
        this.resource = resource;
    }

    String getResource() {
        return this.resource;
    }

    static AdalAccessTokenResponse parseHttpResponse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(new int[]{200});
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return AdalAccessTokenResponse.parseJsonObject(jsonObject);
    }

    static AdalAccessTokenResponse parseJsonObject(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse((JSONObject)jsonObject);
        RefreshToken refreshToken = RefreshToken.parse((JSONObject)jsonObject);
        String idTokenValue = "";
        if (jsonObject.containsKey((Object)"id_token")) {
            idTokenValue = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"id_token");
        }
        String resourceValue = null;
        if (jsonObject.containsKey((Object)"resource")) {
            resourceValue = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"resource");
        }
        return new AdalAccessTokenResponse(accessToken, refreshToken, idTokenValue, resourceValue);
    }
}

