/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.FileLockContent;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class FileLock {
    @Nonnull
    protected final FileLockContent content;

    public FileLock(@Nonnull FileLockContent content) {
        if (content == null) {
            throw new IllegalArgumentException("Required value for 'content' is null");
        }
        this.content = content;
    }

    @Nonnull
    public FileLockContent getContent() {
        return this.content;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.content});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileLock other = (FileLock)obj;
            return this.content == other.content || this.content.equals(other.content);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileLock> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileLock value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("content");
            FileLockContent.Serializer.INSTANCE.serialize(value.content, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileLock deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileLockContent f_content;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_content = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("content".equals(field)) {
                        f_content = FileLockContent.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_content == null) {
                    throw new JsonParseException(p, "Required field \"content\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileLock value = new FileLock(f_content);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

