/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.pb;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
public class PlacementConstraintFromProtoConverter {
    private YarnProtos.PlacementConstraintProto constraintProto;

    public PlacementConstraintFromProtoConverter(YarnProtos.PlacementConstraintProto constraintProto) {
        this.constraintProto = constraintProto;
    }

    public PlacementConstraint convert() {
        return new PlacementConstraint(this.convert(this.constraintProto));
    }

    private PlacementConstraint.AbstractConstraint convert(YarnProtos.PlacementConstraintProto proto) {
        return proto.hasSimpleConstraint() ? this.convert(proto.getSimpleConstraint()) : this.convert(proto.getCompositeConstraint());
    }

    private PlacementConstraint.SingleConstraint convert(YarnProtos.SimplePlacementConstraintProto proto) {
        HashSet<PlacementConstraint.TargetExpression> targets = new HashSet<PlacementConstraint.TargetExpression>();
        for (YarnProtos.PlacementConstraintTargetProto tp : proto.getTargetExpressionsList()) {
            targets.add(this.convert(tp));
        }
        return new PlacementConstraint.SingleConstraint(proto.getScope(), proto.getMinCardinality(), proto.getMaxCardinality(), targets);
    }

    private PlacementConstraint.TargetExpression convert(YarnProtos.PlacementConstraintTargetProto proto) {
        return new PlacementConstraint.TargetExpression(ProtoUtils.convertFromProtoFormat(proto.getTargetType()), proto.hasTargetKey() ? proto.getTargetKey() : null, new HashSet(proto.getTargetValuesList()));
    }

    private PlacementConstraint.AbstractConstraint convert(YarnProtos.CompositePlacementConstraintProto proto) {
        switch (proto.getCompositeType()) {
            case AND: 
            case OR: {
                ArrayList<PlacementConstraint.AbstractConstraint> children = new ArrayList<PlacementConstraint.AbstractConstraint>();
                for (YarnProtos.PlacementConstraintProto cp : proto.getChildConstraintsList()) {
                    children.add(this.convert(cp));
                }
                return proto.getCompositeType() == YarnProtos.CompositePlacementConstraintProto.CompositeType.AND ? new PlacementConstraint.And(children) : new PlacementConstraint.Or(children);
            }
            case DELAYED_OR: {
                ArrayList<PlacementConstraint.TimedPlacementConstraint> tChildren = new ArrayList<PlacementConstraint.TimedPlacementConstraint>();
                for (YarnProtos.TimedPlacementConstraintProto cp : proto.getTimedChildConstraintsList()) {
                    tChildren.add(this.convert(cp));
                }
                return new PlacementConstraint.DelayedOr(tChildren);
            }
        }
        throw new YarnRuntimeException("Encountered unexpected type of composite constraint.");
    }

    private PlacementConstraint.TimedPlacementConstraint convert(YarnProtos.TimedPlacementConstraintProto proto) {
        PlacementConstraint.AbstractConstraint pConstraint = this.convert(proto.getPlacementConstraint());
        return new PlacementConstraint.TimedPlacementConstraint(pConstraint, proto.getSchedulingDelay(), ProtoUtils.convertFromProtoFormat(proto.getDelayUnit()));
    }
}

