/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.validator;

import java.util.List;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

public class NotBlankValidator
implements IActionValidator {
    public static final NotBlankValidator INSTANCE = new NotBlankValidator();
    private static final String VALIDATOR_NAME = "notBlank";

    @Override
    public boolean validate(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        String value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        if (GenericValidator.isBlankOrNull((String)value)) {
            ActionValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, ActionValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }
}

