/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="execution-info-location", name="i18n::ExecutionInfoLocation.name", description="i18n::ExecutionInfoLocation.description", image="ui/images/location.svg", documentationUrl="/metadata-types/execution-information-location.html", hopMetadataPropertyType=HopMetadataPropertyType.EXEC_INFO_LOCATION)
public class ExecutionInfoLocation
extends HopMetadataBase
implements IHopMetadata,
Cloneable {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "ExecutionInfoLocation-PluginSpecific-Options";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    protected String dataLoggingDelay;
    @HopMetadataProperty
    protected String dataLoggingInterval;
    @HopMetadataProperty
    private IExecutionInfoLocation executionInfoLocation;

    public ExecutionInfoLocation() {
        this.dataLoggingDelay = "2000";
        this.dataLoggingInterval = "5000";
    }

    public ExecutionInfoLocation(String name, String description, String dataLoggingDelay, String dataLoggingInterval, String dataLoggingSize, ExecutionDataProfile executionDataProfile, IExecutionInfoLocation executionInfoLocation) {
        super(name);
        this.description = description;
        this.dataLoggingDelay = dataLoggingDelay;
        this.dataLoggingInterval = dataLoggingInterval;
        this.executionInfoLocation = executionInfoLocation;
    }

    public ExecutionInfoLocation(ExecutionInfoLocation location) {
        this();
        this.name = location.name;
        this.description = location.description;
        this.dataLoggingDelay = location.dataLoggingDelay;
        this.dataLoggingInterval = location.dataLoggingInterval;
        if (location.executionInfoLocation != null) {
            this.executionInfoLocation = location.executionInfoLocation.clone();
        }
    }

    public ExecutionInfoLocation clone() {
        return new ExecutionInfoLocation(this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataLoggingDelay() {
        return this.dataLoggingDelay;
    }

    public void setDataLoggingDelay(String dataLoggingDelay) {
        this.dataLoggingDelay = dataLoggingDelay;
    }

    public String getDataLoggingInterval() {
        return this.dataLoggingInterval;
    }

    public void setDataLoggingInterval(String dataLoggingInterval) {
        this.dataLoggingInterval = dataLoggingInterval;
    }

    public IExecutionInfoLocation getExecutionInfoLocation() {
        return this.executionInfoLocation;
    }

    public void setExecutionInfoLocation(IExecutionInfoLocation executionInfoLocation) {
        this.executionInfoLocation = executionInfoLocation;
    }
}

