/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleMapWithFailures;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapValues<@UnknownKeyFor K, @UnknownKeyFor V1, @UnknownKeyFor V2>
extends PTransform<PCollection<KV<K, V1>>, PCollection<KV<K, V2>>> {
    private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V2> outputType;
    private final @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K, V1>, @UnknownKeyFor @NonNull @Initialized KV<K, V2>>> fn;

    public <NewKeyT, NewValueT> @UnknownKeyFor @NonNull @Initialized MapValues<NewKeyT, NewValueT, V2> via(@UnknownKeyFor @NonNull @Initialized SerializableFunction<NewValueT, V2> fn) {
        return new MapValues<K, V1, V2>(Contextful.fn((element, c) -> KV.of(element.getKey(), fn.apply(element.getValue())), Requirements.empty()), this.outputType);
    }

    public static <V2> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MapValues<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, V2> into(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<V2> outputType) {
        return new MapValues(null, outputType);
    }

    private MapValues(@Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K, V1>, @UnknownKeyFor @NonNull @Initialized KV<K, V2>>> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<V2> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> @UnknownKeyFor @NonNull @Initialized SimpleMapWithFailures<@UnknownKeyFor @NonNull @Initialized KV<K, V1>, @UnknownKeyFor @NonNull @Initialized KV<K, V2>, FailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> failureTypeDescriptor) {
        return new SimpleMapWithFailures("MapValuesWithFailures", this.fn, this.getKvTypeDescriptor(), null, failureTypeDescriptor);
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> @UnknownKeyFor @NonNull @Initialized SimpleMapWithFailures<@UnknownKeyFor @NonNull @Initialized KV<K, V1>, @UnknownKeyFor @NonNull @Initialized KV<K, V2>, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction<@UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<@UnknownKeyFor @NonNull @Initialized KV<K, V1>>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<KV<K, V1>, KV<K, V2>, FailureT>("MapValuesWithFailures", this.fn, this.getKvTypeDescriptor(), exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V2>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V1>> input) {
        return (PCollection)((Object)input.apply("MapValues", MapElements.into(this.getKvTypeDescriptor()).via((Contextful)Preconditions.checkNotNull(this.fn, (Object)"Must specify a function on MapValues using .via()"))));
    }

    private @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<K, V2>> getKvTypeDescriptor() {
        return new TypeDescriptor<KV<K, V2>>(){}.where(new TypeParameter<V2>(){}, this.outputType);
    }
}

