/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl;

import io.github.spannm.jackcess.expr.EvalConfig;
import io.github.spannm.jackcess.expr.FunctionLookup;
import io.github.spannm.jackcess.expr.NumericConfig;
import io.github.spannm.jackcess.expr.TemporalConfig;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.impl.SimpleCache;
import io.github.spannm.jackcess.impl.expr.DefaultFunctions;
import io.github.spannm.jackcess.impl.expr.Expressionator;
import io.github.spannm.jackcess.impl.expr.NumberFormatter;
import io.github.spannm.jackcess.impl.expr.RandomContext;
import java.text.DecimalFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public class DBEvalContext
implements Expressionator.ParseContext,
EvalConfig {
    private static final int MAX_CACHE_SIZE = 10;
    private final DatabaseImpl _db;
    private FunctionLookup _funcs = DefaultFunctions.LOOKUP;
    private Map<String, DateTimeFormatter> _sdfs;
    private Map<String, DecimalFormat> _dfs;
    private TemporalConfig _temporal = TemporalConfig.US_TEMPORAL_CONFIG;
    private NumericConfig _numeric = NumericConfig.US_NUMERIC_CONFIG;
    private final RandomContext _rndCtx = new RandomContext();
    private Bindings _bindings = new SimpleBindings();

    public DBEvalContext(DatabaseImpl db) {
        this._db = db;
    }

    protected DatabaseImpl getDatabase() {
        return this._db;
    }

    @Override
    public TemporalConfig getTemporalConfig() {
        return this._temporal;
    }

    @Override
    public void setTemporalConfig(TemporalConfig temporal) {
        if (this._temporal != temporal) {
            this._temporal = temporal;
            this._sdfs = null;
        }
    }

    @Override
    public ZoneId getZoneId() {
        return this._db.getZoneId();
    }

    @Override
    public NumericConfig getNumericConfig() {
        return this._numeric;
    }

    @Override
    public void setNumericConfig(NumericConfig numeric) {
        if (this._numeric != numeric) {
            this._numeric = numeric;
            this._dfs = null;
        }
    }

    @Override
    public FunctionLookup getFunctionLookup() {
        return this._funcs;
    }

    @Override
    public void setFunctionLookup(FunctionLookup lookup) {
        this._funcs = lookup;
    }

    @Override
    public Bindings getBindings() {
        return this._bindings;
    }

    @Override
    public void setBindings(Bindings bindings) {
        this._bindings = bindings;
    }

    @Override
    public DateTimeFormatter createDateFormatter(String formatStr) {
        DateTimeFormatter sdf;
        if (this._sdfs == null) {
            this._sdfs = new SimpleCache<String, DateTimeFormatter>(10);
        }
        if ((sdf = this._sdfs.get(formatStr)) == null) {
            sdf = DateTimeFormatter.ofPattern(formatStr, this._temporal.getLocale());
            this._sdfs.put(formatStr, sdf);
        }
        return sdf;
    }

    @Override
    public DecimalFormat createDecimalFormat(String formatStr) {
        DecimalFormat df;
        if (this._dfs == null) {
            this._dfs = new SimpleCache<String, DecimalFormat>(10);
        }
        if ((df = this._dfs.get(formatStr)) == null) {
            df = new DecimalFormat(formatStr, this._numeric.getDecimalFormatSymbols());
            df.setRoundingMode(NumberFormatter.ROUND_MODE);
            this._dfs.put(formatStr, df);
        }
        return df;
    }

    public float getRandom(Integer seed) {
        return this._rndCtx.getRandom(seed);
    }
}

