/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Permission;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import com.ibm.as400.vaccess.PermissionMainPanel;
import com.ibm.as400.vaccess.PermissionNameCellObject;
import com.ibm.as400.vaccess.ResourceLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

class PermissionTableModelRoot
extends DefaultTableModel {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private Permission permission_;
    private Vector userPermissions_;
    private JTable table_;
    private PermissionMainPanel mainPanel_;
    private int selectedColumn_ = 1;
    private boolean read = false;
    private boolean write = false;
    private boolean execute = false;
    private String[] columnNames_;
    private static String addUserExceptionDialogMessage_;
    private static String addUserExceptionDialogTitle_;

    public PermissionTableModelRoot(PermissionMainPanel mainPanel, Permission permission) {
        this.initializeTable();
        this.mainPanel_ = mainPanel;
        this.permission_ = permission;
        Enumeration<UserPermission> userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
    }

    public void addRow(String name) {
        try {
            this.permission_.addAuthorizedUser(name);
            this.mainPanel_.getApplyButton().setEnabled(true);
            this.table_.clearSelection();
            Enumeration<UserPermission> userPermissions = this.permission_.getUserPermissions();
            this.userPermissions_ = new Vector();
            while (userPermissions.hasMoreElements()) {
                this.userPermissions_.addElement(userPermissions.nextElement());
            }
            int updatedRow = this.userPermissions_.size() - 1;
            this.fireTableRowsInserted(updatedRow, updatedRow);
        }
        catch (ExtendedIllegalArgumentException e) {
            Trace.log(2, "Error in addRow : " + e);
            this.mainPanel_.fireError(e);
        }
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames_.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames_[column];
    }

    @Override
    public int getRowCount() {
        if (this.userPermissions_ == null) {
            return 0;
        }
        return this.userPermissions_.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.userPermissions_.size()) {
            return null;
        }
        if (this.selectedColumn_ > 0) {
            this.table_.clearSelection();
        } else if (this.table_.getSelectedRow() >= 0 && this.table_.getSelectedRowCount() > 0) {
            this.mainPanel_.getRemoveButton().setEnabled(true);
        }
        RootPermission user = null;
        user = (RootPermission)this.userPermissions_.elementAt(row);
        String authorityValue = user.getDataAuthority().toUpperCase();
        Object value = null;
        switch (column) {
            case 0: {
                value = new PermissionNameCellObject(user.getUserID(), user.getGroupIndicator());
                break;
            }
            case 1: {
                value = authorityValue.indexOf("R") > -1;
                break;
            }
            case 2: {
                value = authorityValue.indexOf("W") > -1;
                break;
            }
            case 3: {
                value = authorityValue.indexOf("X") > -1 && authorityValue.indexOf("E") == -1;
                break;
            }
            case 4: {
                value = user.isManagement();
                break;
            }
            case 5: {
                value = user.isExistence();
                break;
            }
            case 6: {
                value = user.isAlter();
                break;
            }
            case 7: {
                value = user.isReference();
                break;
            }
            case 8: {
                value = user.isFromAuthorizationList();
            }
        }
        return value;
    }

    private void initializeTable() {
        this.columnNames_ = new String[9];
        this.columnNames_[0] = ResourceLoader.getText("OBJECT_USER_NAME");
        this.columnNames_[1] = ResourceLoader.getText("OBJECT_AUTHORITY_READ");
        this.columnNames_[2] = ResourceLoader.getText("OBJECT_AUTHORITY_WRITE");
        this.columnNames_[3] = ResourceLoader.getText("OBJECT_AUTHORITY_EXECUTE");
        this.columnNames_[4] = ResourceLoader.getText("OBJECT_AUTHORITY_MANAGEMENT");
        this.columnNames_[5] = ResourceLoader.getText("OBJECT_AUTHORITY_EXISTENCE");
        this.columnNames_[6] = ResourceLoader.getText("OBJECT_AUTHORITY_ALTER");
        this.columnNames_[7] = ResourceLoader.getText("OBJECT_AUTHORITY_REFERENCE");
        this.columnNames_[8] = ResourceLoader.getText("OBJECT_FROM_AUTHORIZATION_LIST");
        addUserExceptionDialogMessage_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_MESSAGE");
        addUserExceptionDialogTitle_ = ResourceLoader.getText("OBJECT_ADD_USER_EXCEPTION_DIALOG_TITLE");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        this.selectedColumn_ = column;
        switch (column) {
            case 0: {
                return false;
            }
            case 8: {
                UserPermission user = (UserPermission)this.userPermissions_.elementAt(row);
                if (!this.mainPanel_.getAutList().toUpperCase().equals("*NONE") && user.getUserID().toUpperCase().equals("*PUBLIC")) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public void removeRow(int row) {
        this.table_.clearSelection();
        RootPermission user = (RootPermission)this.userPermissions_.elementAt(row);
        this.permission_.removeAuthorizedUser(user.getUserID());
        Enumeration<UserPermission> userPermissions = this.permission_.getUserPermissions();
        this.userPermissions_ = new Vector();
        while (userPermissions.hasMoreElements()) {
            this.userPermissions_.addElement(userPermissions.nextElement());
        }
        this.fireTableRowsDeleted(row, row);
    }

    void resetPublicAuthorizationList() {
        UserPermission up = this.permission_.getUserPermission("*PUBLIC");
        int row = this.userPermissions_.indexOf(up);
        if (row >= 0) {
            this.setValueAt(Boolean.FALSE, row, 8);
        }
    }

    public void setTableInstance(JTable table) {
        this.table_ = table;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.mainPanel_.getRemoveButton().setEnabled(false);
        RootPermission user = (RootPermission)this.userPermissions_.elementAt(row);
        String authorityValue = user.getDataAuthority().trim();
        if (authorityValue.equals("*EXCLUDE") || authorityValue.equals("*NONE")) {
            this.read = false;
            this.write = false;
            this.execute = false;
        } else {
            this.read = authorityValue.indexOf("R") > -1;
            this.write = authorityValue.indexOf("W") > -1;
            this.execute = authorityValue.indexOf("X") > -1;
        }
        String string = "*";
        switch (column) {
            case 1: {
                this.read = (Boolean)aValue;
                if (this.read) {
                    string = string + "R";
                }
                if (this.write) {
                    string = string + "W";
                }
                if (this.execute) {
                    string = string + "X";
                }
                if (string.equals("*")) {
                    string = string + "NONE";
                }
                user.setDataAuthority(string);
                break;
            }
            case 2: {
                this.write = (Boolean)aValue;
                if (this.read) {
                    string = string + "R";
                }
                if (this.write) {
                    string = string + "W";
                }
                if (this.execute) {
                    string = string + "X";
                }
                if (string.equals("*")) {
                    string = string + "NONE";
                }
                user.setDataAuthority(string);
                break;
            }
            case 3: {
                this.execute = (Boolean)aValue;
                if (this.read) {
                    string = string + "R";
                }
                if (this.write) {
                    string = string + "W";
                }
                if (this.execute) {
                    string = string + "X";
                }
                if (string.equals("*")) {
                    string = string + "NONE";
                }
                user.setDataAuthority(string);
                break;
            }
            case 4: {
                boolean value = (Boolean)aValue;
                user.setManagement(value);
                break;
            }
            case 5: {
                boolean value = (Boolean)aValue;
                user.setExistence(value);
                break;
            }
            case 6: {
                boolean value = (Boolean)aValue;
                user.setAlter(value);
                break;
            }
            case 7: {
                boolean value = (Boolean)aValue;
                user.setReference(value);
                break;
            }
            case 8: {
                boolean value = (Boolean)aValue;
                user.setFromAuthorizationList(value);
            }
        }
        this.fireTableRowsUpdated(row, row);
        this.mainPanel_.getApplyButton().setEnabled(true);
    }
}

