/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.RJob;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandCall
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.CommandCall";
    static final long serialVersionUID = 4L;
    private static final int UNSPECIFIED = 0;
    private static final int SPECIFIED_BY_PROPERTY = 1;
    private static final int SPECIFIED_BY_SETTER = 2;
    public static final Boolean THREADSAFE_FALSE;
    public static final Boolean THREADSAFE_TRUE;
    public static final Boolean THREADSAFE_LOOKUP;
    private AS400 system_ = null;
    private String command_ = "";
    private AS400Message[] messageList_ = new AS400Message[0];
    private transient Boolean threadSafetyValue_ = THREADSAFE_FALSE;
    private boolean threadSafety_ = false;
    private transient boolean threadSafetyIsLookedUp_ = false;
    private int threadSafetyDetermined_ = 0;
    private int messageOption_ = 0;
    private transient RemoteCommandImpl impl_ = null;
    private transient Vector actionCompletedListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public CommandCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object.");
        }
        this.applyThreadSafetyProperty();
    }

    public CommandCall(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object, system: " + system);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.system_ = system;
        this.applyThreadSafetyProperty();
    }

    public CommandCall(AS400 system, String command) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object, system: " + system + " command: " + command);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        this.system_ = system;
        this.command_ = command;
        this.applyThreadSafetyProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionCompletedListener(ActionCompletedListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding action completed listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.actionCompletedListeners_ == null) {
                this.actionCompletedListeners_ = new Vector();
            }
            this.actionCompletedListeners_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    private synchronized void chooseImpl() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Attempt to connect to command server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (RemoteCommandImpl)this.system_.loadImpl3("com.ibm.as400.access.RemoteCommandImplNative", "com.ibm.as400.access.RemoteCommandImplRemote", "com.ibm.as400.access.RemoteCommandImplProxy");
            this.impl_.setSystem(this.system_.getImpl());
        }
        if (this.threadSafetyValue_ == THREADSAFE_LOOKUP) {
            int indicator;
            this.threadSafetyValue_ = this.command_ == null || this.command_.length() == 0 ? THREADSAFE_FALSE : (!this.impl_.isNative() ? THREADSAFE_FALSE : ((indicator = this.impl_.getThreadsafeIndicator(this.command_)) == 1 ? THREADSAFE_TRUE : THREADSAFE_FALSE));
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
        }
    }

    private void fireActionCompleted() {
        Vector targets = (Vector)this.actionCompletedListeners_.clone();
        ActionCompletedEvent event = new ActionCompletedEvent(this);
        for (int i = 0; i < targets.size(); ++i) {
            ActionCompletedListener target = (ActionCompletedListener)targets.elementAt(i);
            target.actionCompleted(event);
        }
    }

    public String getCommand() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting command: " + this.command_);
        }
        return this.command_;
    }

    public RJob getJob() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job.");
        }
        this.chooseImpl();
        String jobInfo = this.impl_.getJobInfo(this.threadSafetyValue_);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing RJob for job: " + jobInfo);
        }
        return new RJob(this.system_, jobInfo.substring(0, 10).trim(), jobInfo.substring(10, 20).trim(), jobInfo.substring(20, 26).trim());
    }

    public int getMessageOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message option:", this.messageOption_);
        }
        return this.messageOption_;
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list.");
        }
        return this.messageList_;
    }

    public AS400Message getMessageList(int index) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message from message list:", index);
        }
        return this.messageList_[index];
    }

    public Job getServerJob() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job.");
        }
        this.chooseImpl();
        String jobInfo = this.impl_.getJobInfo(this.threadSafetyValue_);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job for job: " + jobInfo);
        }
        return new Job(this.system_, jobInfo.substring(0, 10).trim(), jobInfo.substring(10, 20).trim(), jobInfo.substring(20, 26).trim());
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public Thread getSystemThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        Thread currentThread;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system thread.");
        }
        this.chooseImpl();
        Thread thread = currentThread = this.impl_.isNative() ? Thread.currentThread() : null;
        if (Trace.traceOn_) {
            Trace.log(1, "System thread: " + currentThread);
        }
        return currentThread;
    }

    static final String getThreadSafetyProperty() {
        String val = SystemProperties.getProperty("com.ibm.as400.access.CommandCall.threadSafe");
        return val == null || val.length() == 0 ? null : val.toLowerCase();
    }

    private void applyThreadSafetyProperty() {
        String property = CommandCall.getThreadSafetyProperty();
        if (property == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Thread safe system property not set; thread safety property remains unspecified.");
            }
        } else {
            if (property.equals("true")) {
                this.threadSafetyValue_ = THREADSAFE_TRUE;
                this.threadSafetyDetermined_ = 1;
            } else if (property.equals("false")) {
                this.threadSafetyValue_ = THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 1;
            } else if (property.equals("lookup")) {
                this.threadSafetyValue_ = THREADSAFE_LOOKUP;
                this.threadSafetyDetermined_ = 1;
                this.threadSafetyIsLookedUp_ = true;
            } else if (Trace.traceOn_) {
                Trace.log(4, "Unrecognized value for CommandCall.threadSafe property: " + property + ". Defaulting to 'false'.");
            }
            this.threadSafety_ = THREADSAFE_TRUE.equals(this.threadSafetyValue_);
        }
    }

    public int getThreadsafeIndicator() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.command_ == null || this.command_.length() == 0) {
            Trace.log(2, "Attempt to retrieve Threadsafe indicator before setting command.");
            throw new ExtendedIllegalStateException("command", 4);
        }
        this.chooseImpl();
        return this.impl_.getThreadsafeIndicator(this.command_);
    }

    public boolean isStayOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        boolean isStayOnThread;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if command will actually get run on the current thread.");
        }
        this.chooseImpl();
        boolean bl = isStayOnThread = THREADSAFE_TRUE.equals(this.threadSafetyValue_) && this.impl_.isNative();
        if (Trace.traceOn_) {
            Trace.log(1, "Will command actually get run on the current thread:", isStayOnThread);
        }
        return isStayOnThread;
    }

    public boolean isThreadSafe() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if command will be assumed thread-safe.");
        }
        this.chooseImpl();
        return this.threadSafetyValue_;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing CommandCall object.");
        }
        in.defaultReadObject();
        this.threadSafetyIsLookedUp_ = false;
        if (this.threadSafetyDetermined_ == 3) {
            this.threadSafetyDetermined_ = 0;
        }
        if (this.threadSafetyDetermined_ == 2) {
            this.threadSafetyValue_ = this.threadSafety_ ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        } else {
            this.threadSafetyValue_ = THREADSAFE_FALSE;
            this.threadSafety_ = false;
            this.threadSafetyIsLookedUp_ = false;
            String property = CommandCall.getThreadSafetyProperty();
            if (property == null) {
                this.threadSafetyDetermined_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(1, "Thread safe system property not set, so thread safety property changed to unspecified.");
                }
            } else {
                this.applyThreadSafetyProperty();
            }
        }
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing action completed listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.actionCompletedListeners_ != null) {
            this.actionCompletedListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Running command: " + this.command_);
        }
        if (this.command_ == null || this.command_.length() == 0) {
            Trace.log(2, "Attempt to run before setting command.");
            throw new ExtendedIllegalStateException("command", 4);
        }
        this.chooseImpl();
        boolean result = this.impl_.runCommand(this.command_, this.threadSafetyValue_, this.messageOption_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return result;
    }

    public boolean run(String command) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        this.setCommand(command);
        return this.run();
    }

    public boolean run(byte[] command) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(3, "Running command:", command);
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (command.length == 0) {
            throw new ExtendedIllegalArgumentException("command.length (" + command.length + ")", 1);
        }
        this.chooseImpl();
        boolean success = this.impl_.runCommand(command, this.threadSafetyValue_, this.messageOption_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return success;
    }

    public void setCommand(String command) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting command: " + command);
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (Trace.traceOn_ && command.length() == 0) {
            Trace.log(4, "Parameter 'command' is has length of 0.");
        }
        boolean forceLookup = false;
        if (this.threadSafetyIsLookedUp_ && this.threadSafetyValue_ != THREADSAFE_LOOKUP && !CommandCall.firstToken(command).equalsIgnoreCase(CommandCall.firstToken(this.command_))) {
            forceLookup = true;
        }
        String oldValue = this.command_;
        String newValue = command;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("command", oldValue, newValue);
        }
        this.command_ = newValue;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("command", oldValue, newValue);
        }
        if (forceLookup) {
            this.threadSafetyValue_ = THREADSAFE_LOOKUP;
            this.threadSafety_ = false;
        }
    }

    private static final String firstToken(String string) {
        String token = null;
        try {
            StringTokenizer tokenizer = new StringTokenizer(string);
            token = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            token = "";
        }
        return token;
    }

    public void setMessageOption(int messageOption) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message option:", messageOption);
        }
        if (messageOption < 0 || messageOption > 2) {
            throw new ExtendedIllegalArgumentException("messageOption (" + messageOption + ")", 2);
        }
        this.messageOption_ = messageOption;
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + system);
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 oldValue = this.system_;
        AS400 newValue = system;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
        }
        this.system_ = newValue;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
        }
    }

    public void setThreadSafe(boolean threadSafe) {
        Boolean newValue;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread safe: " + threadSafe);
        }
        Boolean bl = newValue = threadSafe ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        if (this.propertyChangeListeners_ != null) {
            Boolean oldValue = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", oldValue, newValue);
        }
        this.threadSafetyValue_ = newValue;
        this.threadSafety_ = threadSafe;
        this.threadSafetyDetermined_ = 2;
        this.threadSafetyIsLookedUp_ = false;
    }

    public void setThreadSafe(Boolean threadSafe) {
        Boolean newValue;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread safe: " + threadSafe);
        }
        if (threadSafe.equals(THREADSAFE_TRUE)) {
            newValue = THREADSAFE_TRUE;
            this.threadSafetyIsLookedUp_ = false;
        } else if (threadSafe.equals(THREADSAFE_FALSE)) {
            newValue = THREADSAFE_FALSE;
            this.threadSafetyIsLookedUp_ = false;
        } else {
            newValue = THREADSAFE_LOOKUP;
            this.threadSafetyIsLookedUp_ = true;
        }
        if (this.propertyChangeListeners_ != null) {
            Boolean oldValue = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", oldValue, newValue);
        }
        this.threadSafetyValue_ = newValue;
        this.threadSafety_ = this.threadSafetyValue_ == THREADSAFE_TRUE;
        this.threadSafetyDetermined_ = 2;
    }

    public void suggestThreadsafe(boolean threadSafe) {
        String property = CommandCall.getThreadSafetyProperty();
        if (property == null || property.equals("lookup")) {
            this.setThreadSafe((Boolean)threadSafe);
        }
    }

    public String toString() {
        return "CommandCall (system: " + this.system_ + " command: " + this.command_ + "):" + super.toString();
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        THREADSAFE_FALSE = Boolean.FALSE;
        THREADSAFE_TRUE = Boolean.TRUE;
        THREADSAFE_LOOKUP = null;
    }
}

