/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.ReturnCodeException;

public class AS400SecurityException
extends Exception
implements ReturnCodeException {
    static final long serialVersionUID = 4L;
    private int rc_;
    private AS400Message[] messageList_;
    public static final int DIRECTORY_ENTRY_ACCESS_DENIED = 1;
    public static final int EXIT_PROGRAM_NOT_AUTHORIZED = 2;
    public static final int LIBRARY_AUTHORITY_INSUFFICIENT = 3;
    public static final int OBJECT_AUTHORITY_INSUFFICIENT = 4;
    public static final int PASSWORD_CHANGE_REQUEST_NOT_VALID = 5;
    public static final int PASSWORD_ERROR = 6;
    public static final int PASSWORD_EXPIRED = 7;
    public static final int PASSWORD_INCORRECT = 8;
    public static final int PASSWORD_INCORRECT_USERID_DISABLE = 9;
    public static final int PASSWORD_LENGTH_NOT_VALID = 10;
    public static final int PASSWORD_NEW_ADJACENT_DIGITS = 11;
    public static final int PASSWORD_NEW_CONSECUTIVE_REPEAT_CHARACTER = 12;
    public static final int PASSWORD_NEW_DISALLOWED = 13;
    public static final int PASSWORD_NEW_NO_ALPHABETIC = 14;
    public static final int PASSWORD_NEW_NO_NUMERIC = 15;
    public static final int PASSWORD_NEW_NOT_VALID = 16;
    public static final int PASSWORD_NEW_PREVIOUSLY_USED = 17;
    public static final int PASSWORD_NEW_REPEAT_CHARACTER = 18;
    public static final int PASSWORD_NEW_TOO_LONG = 19;
    public static final int PASSWORD_NEW_TOO_SHORT = 20;
    public static final int PASSWORD_NEW_USERID = 21;
    public static final int PASSWORD_NOT_SET = 22;
    public static final int PASSWORD_OLD_NOT_VALID = 23;
    public static final int SECURITY_GENERAL = 24;
    public static final int SIGNON_CANCELED = 25;
    public static final int SIGNON_REQUEST_NOT_VALID = 26;
    public static final int UNKNOWN = 27;
    public static final int USERID_ERROR = 28;
    public static final int USERID_LENGTH_NOT_VALID = 29;
    public static final int USERID_NOT_SET = 30;
    public static final int USERID_DISABLE = 31;
    public static final int USERID_UNKNOWN = 32;
    public static final int EXIT_POINT_PROCESSING_ERROR = 33;
    public static final int EXIT_PROGRAM_RESOLVE_ERROR = 34;
    public static final int EXIT_PROGRAM_DENIED_REQUEST = 35;
    public static final int EXIT_PROGRAM_CALL_ERROR = 36;
    public static final int REQUEST_NOT_SUPPORTED = 37;
    public static final int SYSTEM_LEVEL_NOT_CORRECT = 38;
    public static final int PASSWORD_NEW_SAME_POSITION = 39;
    public static final int SPECIAL_AUTHORITY_INSUFFICIENT = 40;
    public static final int TOKEN_TYPE_NOT_VALID = 41;
    public static final int GENERATE_TOKEN_REQUEST_NOT_VALID = 42;
    public static final int TOKEN_LENGTH_NOT_VALID = 43;
    public static final int PASSWORD_NEW_CHARACTER_NOT_VALID = 44;
    public static final int PASSWORD_PRE_V2R2 = 45;
    public static final int PASSWORD_NONE = 46;
    public static final int PROFILE_TOKEN_NOT_VALID = 47;
    public static final int PROFILE_TOKEN_NOT_VALID_MAXIMUM = 48;
    public static final int PROFILE_TOKEN_NOT_VALID_TIMEOUT_NOT_VALID = 49;
    public static final int PROFILE_TOKEN_NOT_VALID_TYPE_NOT_VALID = 50;
    public static final int PROFILE_TOKEN_NOT_VALID_NOT_REGENERABLE = 51;
    public static final int KERBEROS_TICKET_NOT_VALID_CONSISTENCY = 52;
    public static final int KERBEROS_TICKET_NOT_VALID_MECHANISM = 53;
    public static final int KERBEROS_TICKET_NOT_VALID_CREDENTIAL_NOT_VALID = 54;
    public static final int KERBEROS_TICKET_NOT_VALID_SIGNATURE = 55;
    public static final int KERBEROS_TICKET_NOT_VALID_CREDENTIAL_NO_LONGER_VALID = 56;
    public static final int KERBEROS_TICKET_NOT_VALID_CREDANTIAL_STRUCTURE = 57;
    public static final int KERBEROS_TICKET_NOT_VALID_VERIFICATION = 58;
    public static final int KERBEROS_TICKET_NOT_VALID_EIM = 59;
    public static final int KERBEROS_TICKET_NOT_VALID_SYSTEM_PROFILE = 60;
    public static final int KERBEROS_TICKET_NOT_VALID_MULTIPLE_PROFILES = 61;
    public static final int KERBEROS_TICKET_NOT_VALID_RETRIEVE = 62;
    public static final int SIGNON_CHAR_NOT_VALID = 63;
    public static final int USERID_MISMATCH = 64;
    public static final int PASSWORD_NEW_VALIDATION_PROGRAM = 65;
    public static final int GENERATE_TOKEN_AUTHORITY_INSUFFICIENT = 66;
    public static final int GENERATE_TOKEN_CAN_NOT_CONNECT = 67;
    public static final int GENERATE_TOKEN_CAN_NOT_CHANGE_CCSID = 68;
    public static final int GENERATE_TOKEN_CAN_NOT_OBTAIN_NAME = 69;
    public static final int GENERATE_TOKEN_NO_MAPPING = 70;
    public static final int SERVER_NO_MEMORY = 71;
    public static final int SERVER_CONVERSION_ERROR = 72;
    public static final int SERVER_EIM_ERROR = 73;
    public static final int SERVER_CRYPTO_ERROR = 74;
    public static final int SERVER_TOKEN_VERSION = 75;
    public static final int SERVER_KEY_NOT_FOUND = 76;
    public static final int PASSWORD_CHANGE_NOT_ALLOWED = 77;
    public static final int PASSWORD_VALUE_NOT_VALID = 78;

    protected AS400SecurityException(int returnCode) {
        super(ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    protected AS400SecurityException(int returnCode, Throwable e) {
        super(ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)), e);
        this.rc_ = returnCode;
    }

    AS400SecurityException(String objectName, int returnCode) {
        super(objectName + ": " + ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
    }

    AS400SecurityException(int returnCode, AS400Message[] messageList) {
        super(ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)));
        this.rc_ = returnCode;
        this.messageList_ = messageList;
    }

    AS400SecurityException(int returnCode, AS400Message[] messageList, String info) {
        super(ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)) + ":" + info);
        this.rc_ = returnCode;
        this.messageList_ = messageList;
    }

    AS400SecurityException(int returnCode, String info) {
        super(ResourceBundleLoader.getText(AS400SecurityException.getMRIKey(returnCode)) + ":" + (info == null ? "UNKNOWN" : info));
        this.rc_ = returnCode;
    }

    static String getMRIKey(int returnCode) {
        switch (returnCode) {
            case 1: {
                return "EXC_DIRECTORY_ENTRY_ACCESS_DENIED";
            }
            case 2: {
                return "EXC_EXIT_PROGRAM_NOT_AUTHORIZED";
            }
            case 3: {
                return "EXC_LIBRARY_AUTHORITY_INSUFFICIENT";
            }
            case 4: {
                return "EXC_OBJECT_AUTHORITY_INSUFFICIENT";
            }
            case 5: {
                return "EXC_PASSWORD_CHANGE_REQUEST_NOT_VALID";
            }
            case 6: {
                return "EXC_PASSWORD_ERROR";
            }
            case 7: {
                return "EXC_PASSWORD_EXPIRED";
            }
            case 8: {
                return "EXC_PASSWORD_INCORRECT";
            }
            case 9: {
                return "EXC_PASSWORD_INCORRECT_USERID_DISABLE";
            }
            case 10: {
                return "EXC_PASSWORD_LENGTH_NOT_VALID";
            }
            case 11: {
                return "EXC_PASSWORD_NEW_ADJACENT_DIGITS";
            }
            case 12: {
                return "EXC_PASSWORD_NEW_CONSECUTIVE_REPEAT_CHARACTER";
            }
            case 13: {
                return "EXC_PASSWORD_NEW_DISALLOWED";
            }
            case 14: {
                return "EXC_PASSWORD_NEW_NO_ALPHABETIC";
            }
            case 15: {
                return "EXC_PASSWORD_NEW_NO_NUMERIC";
            }
            case 16: {
                return "EXC_PASSWORD_NEW_NOT_VALID";
            }
            case 17: {
                return "EXC_PASSWORD_NEW_PREVIOUSLY_USED";
            }
            case 18: {
                return "EXC_PASSWORD_NEW_REPEAT_CHARACTER";
            }
            case 19: {
                return "EXC_PASSWORD_NEW_TOO_LONG";
            }
            case 20: {
                return "EXC_PASSWORD_NEW_TOO_SHORT";
            }
            case 21: {
                return "EXC_PASSWORD_NEW_USERID";
            }
            case 22: {
                return "EXC_PASSWORD_NOT_SET";
            }
            case 23: {
                return "EXC_PASSWORD_OLD_NOT_VALID";
            }
            case 24: {
                return "EXC_SECURITY_GENERAL";
            }
            case 25: {
                return "EXC_SIGNON_CANCELED";
            }
            case 26: {
                return "EXC_SIGNON_REQUEST_NOT_VALID";
            }
            case 27: {
                return "EXC_UNKNOWN";
            }
            case 28: {
                return "EXC_USERID_ERROR";
            }
            case 29: {
                return "EXC_USERID_LENGTH_NOT_VALID";
            }
            case 30: {
                return "EXC_USERID_NOT_SET";
            }
            case 31: {
                return "EXC_USERID_DISABLE";
            }
            case 32: {
                return "EXC_USERID_UNKNOWN";
            }
            case 33: {
                return "EXC_EXIT_POINT_PROCESSING_ERROR";
            }
            case 35: {
                return "EXC_EXIT_PROGRAM_DENIED_REQUEST";
            }
            case 34: {
                return "EXC_EXIT_PROGRAM_RESOLVE_ERROR";
            }
            case 36: {
                return "EXC_EXIT_PROGRAM_CALL_ERROR";
            }
            case 37: {
                return "EXC_REQUEST_NOT_SUPPORTED";
            }
            case 38: {
                return "EXC_SYSTEM_LEVEL_NOT_CORRECT";
            }
            case 39: {
                return "EXC_PASSWORD_NEW_SAME_POSITION";
            }
            case 40: {
                return "EXC_SPECIAL_AUTHORITY_INSUFFICIENT";
            }
            case 41: {
                return "EXC_TOKEN_TYPE_NOT_VALID";
            }
            case 42: {
                return "EXC_GENERATE_TOKEN_REQUEST_NOT_VALID";
            }
            case 43: {
                return "EXC_TOKEN_LENGTH_NOT_VALID";
            }
            case 44: {
                return "EXC_PASSWORD_NEW_CHARACTER_NOT_VALID";
            }
            case 45: {
                return "EXC_PASSWORD_PRE_V2R2";
            }
            case 46: {
                return "EXC_PASSWORD_NONE";
            }
            case 47: {
                return "EXC_PROFILE_TOKEN_NOT_VALID";
            }
            case 48: {
                return "EXC_PROFILE_TOKEN_NOT_VALID_MAXIMUM";
            }
            case 49: {
                return "EXC_PROFILE_TOKEN_NOT_VALID_TIMEOUT_NOT_VALID";
            }
            case 50: {
                return "EXC_PROFILE_TOKEN_NOT_VALID_TYPE_NOT_VALID";
            }
            case 51: {
                return "EXC_PROFILE_TOKEN_NOT_VALID_NOT_REGENERABLE";
            }
            case 52: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_CONSISTENCY";
            }
            case 53: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_MECHANISM";
            }
            case 54: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_CREDENTIAL_NOT_VALID";
            }
            case 55: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_SIGNATURE";
            }
            case 56: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_CREDENTIAL_NO_LONGER_VALID";
            }
            case 57: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_CREDANTIAL_STRUCTURE";
            }
            case 58: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_VERIFICATION";
            }
            case 59: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_EIM";
            }
            case 60: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_SYSTEM_PROFILE";
            }
            case 61: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_MULTIPLE_PROFILES";
            }
            case 62: {
                return "EXC_KERBEROS_TICKET_NOT_VALID_RETRIEVE";
            }
            case 63: {
                return "EXC_SIGNON_CHAR_NOT_VALID";
            }
            case 64: {
                return "EXC_USERID_MISMATCH";
            }
            case 65: {
                return "EXC_PASSWORD_NEW_VALIDATION_PROGRAM";
            }
            case 66: {
                return "EXC_GENERATE_TOKEN_AUTHORITY_INSUFFICIENT";
            }
            case 67: {
                return "EXC_GENERATE_TOKEN_CAN_NOT_CONNECT";
            }
            case 68: {
                return "EXC_GENERATE_TOKEN_CAN_NOT_CHANGE_CCSID";
            }
            case 69: {
                return "EXC_GENERATE_TOKEN_CAN_NOT_OBTAIN_NAME";
            }
            case 70: {
                return "EXC_GENERATE_TOKEN_NO_MAPPING";
            }
            case 71: {
                return "EXC_SERVER_NO_MEMORY";
            }
            case 72: {
                return "EXC_SERVER_CONVERSION_ERROR";
            }
            case 73: {
                return "EXC_SERVER_EIM_ERROR";
            }
            case 74: {
                return "EXC_SERVER_CRYPTO_ERROR";
            }
            case 75: {
                return "EXC_SERVER_TOKEN_VERSION";
            }
            case 76: {
                return "EXC_SERVER_KEY_NOT_FOUND";
            }
            case 77: {
                return "EXC_PASSWORD_CHANGE_NOT_ALLOWED";
            }
            case 78: {
                return "EXC_PASSWORD_VALUE_NOT_VALID";
            }
        }
        return "EXC_UNKNOWN";
    }

    @Override
    public int getReturnCode() {
        return this.rc_;
    }

    public AS400Message[] getMessageList() {
        return this.messageList_;
    }
}

