/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.StringUtils;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
extends AbstractBaseLinkedListNode<DefaultFactHandle>
implements InternalFactHandle {
    private static final long serialVersionUID = 510L;
    static final String FACT_FORMAT_VERSION = "0";
    protected long id;
    protected long recency;
    protected Object object;
    private EqualityKey key;
    private int objectHashCode;
    protected int identityHashCode;
    protected EntryPointId entryPointId;
    private boolean disconnected;
    protected TraitTypeEnum traitType = TraitTypeEnum.NON_TRAIT;
    private boolean valid = true;
    private boolean negated;
    private String objectClassName;
    protected InternalFactHandle.LinkedTuples linkedTuples;
    private InternalFactHandle parentHandle;
    protected transient WorkingMemoryEntryPoint wmEntryPoint;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(Object object) {
        this.object = object;
    }

    public DefaultFactHandle(long id, Object object) {
        this(id, object, id, null, false);
    }

    public DefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, false);
    }

    public DefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, isTraitOrTraitable);
    }

    public DefaultFactHandle(long id, int identityHashCode, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this(id, identityHashCode, object, recency, wmEntryPoint == null ? null : wmEntryPoint.getEntryPoint(), isTraitOrTraitable);
        if (wmEntryPoint != null) {
            this.setLinkedTuples(wmEntryPoint.getKnowledgeBase());
            this.wmEntryPoint = wmEntryPoint;
        } else {
            this.linkedTuples = new SingleLinkedTuples();
        }
    }

    protected DefaultFactHandle(long id, int identityHashCode, Object object, long recency, EntryPointId entryPointId, boolean isTraitOrTraitable) {
        this.id = id;
        this.entryPointId = entryPointId;
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.traitType = this.determineTraitType(object, isTraitOrTraitable);
    }

    protected DefaultFactHandle(long id, int identityHashCode, Object object, long recency, EntryPointId entryPointId, TraitTypeEnum traitType) {
        this.id = id;
        this.entryPointId = entryPointId;
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.traitType = traitType;
    }

    public DefaultFactHandle(long id, String wmEntryPointId, int identityHashCode, int objectHashCode, long recency, Object object) {
        this.id = id;
        this.entryPointId = new EntryPointId(wmEntryPointId);
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.objectHashCode = objectHashCode;
        this.disconnected = true;
        this.traitType = TraitTypeEnum.NON_TRAIT;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DefaultFactHandle && this.id == ((DefaultFactHandle)object).id;
    }

    @Override
    public void disconnect() {
        this.key = null;
        this.linkedTuples = null;
        this.entryPointId = null;
        this.disconnected = true;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    @Override
    public <K> K as(Class<K> klass) throws ClassCastException {
        if (klass.isAssignableFrom(this.object.getClass())) {
            return (K)this.object;
        }
        throw new ClassCastException("The Handle's Object can't be cast to " + klass);
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    protected void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Override
    public int getObjectHashCode() {
        if (this.objectHashCode == 0 && this.object != null) {
            this.objectHashCode = this.object.hashCode();
        }
        return this.objectHashCode;
    }

    @Override
    public int getIdentityHashCode() {
        if (this.identityHashCode == 0 && this.object != null) {
            this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(this.object);
        }
        return this.identityHashCode;
    }

    public static int determineIdentityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected void setIdentityHashCode(int identityHashCode) {
        this.identityHashCode = identityHashCode;
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public final String toExternalForm() {
        return this.getFormatVersion() + ":" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (this.entryPointId != null ? this.entryPointId.getEntryPointId() : "null") + ":" + this.traitType.name() + ":" + this.getObjectClassName();
    }

    protected String getFormatVersion() {
        return FACT_FORMAT_VERSION;
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public void setExternalForm(String externalForm) {
        DefaultFactHandle.populateFactHandleFromExternalForm(externalForm, this);
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    @Override
    public long getRecency() {
        return this.recency;
    }

    @Override
    public void setRecency(long recency) {
        this.recency = recency;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public String getObjectClassName() {
        if (this.object != null) {
            this.objectClassName = this.object.getClass().getName();
        }
        return this.objectClassName;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        this.objectClassName = null;
        this.objectHashCode = 0;
        if (this.isTraitOrTraitable()) {
            TraitTypeEnum newType = this.determineTraitType(object, this.isTraitOrTraitable());
            if (this.traitType != TraitTypeEnum.LEGACY_TRAITABLE || newType == TraitTypeEnum.LEGACY_TRAITABLE) {
                this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
            }
            this.traitType = newType;
        } else {
            this.identityHashCode = 0;
        }
    }

    @Override
    public EqualityKey getEqualityKey() {
        return this.key;
    }

    @Override
    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTraitOrTraitable() {
        return this.traitType != TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.wmEntryPoint.getInternalWorkingMemory();
    }

    @Override
    public EntryPointId getEntryPointId() {
        return this.entryPointId;
    }

    @Override
    public WorkingMemoryEntryPoint getEntryPoint(InternalWorkingMemory wm) {
        if (this.wmEntryPoint == null) {
            this.wmEntryPoint = (WorkingMemoryEntryPoint)wm.getEntryPoint(this.entryPointId.getEntryPointId());
        }
        return this.wmEntryPoint;
    }

    protected void setLinkedTuples(InternalKnowledgeBase kbase) {
        this.linkedTuples = kbase != null && kbase.getConfiguration().isMultithreadEvaluation() ? new CompositeLinkedTuples() : new SingleLinkedTuples();
    }

    @Override
    public void addFirstLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.addFirstLeftTuple(leftTuple);
    }

    @Override
    public void addLastLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.addLastLeftTuple(leftTuple);
    }

    @Override
    public void addTupleInPosition(Tuple tuple) {
        this.linkedTuples.addTupleInPosition(tuple);
    }

    @Override
    public void removeLeftTuple(LeftTuple leftTuple) {
        this.linkedTuples.removeLeftTuple(leftTuple);
    }

    @Override
    public void addFirstRightTuple(RightTuple rightTuple) {
        this.linkedTuples.addFirstRightTuple(rightTuple);
    }

    @Override
    public void addLastRightTuple(RightTuple rightTuple) {
        this.linkedTuples.addLastRightTuple(rightTuple);
    }

    @Override
    public void removeRightTuple(RightTuple rightTuple) {
        this.linkedTuples.removeRightTuple(rightTuple);
    }

    @Override
    public void clearLeftTuples() {
        this.linkedTuples.clearLeftTuples();
    }

    @Override
    public void clearRightTuples() {
        this.linkedTuples.clearRightTuples();
    }

    @Override
    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.identityHashCode, this.object, this.recency, this.entryPointId, this.traitType);
        clone.key = this.key;
        clone.linkedTuples = this.linkedTuples.clone();
        clone.objectHashCode = this.objectHashCode;
        clone.disconnected = this.disconnected;
        clone.negated = this.negated;
        clone.wmEntryPoint = this.wmEntryPoint;
        return clone;
    }

    public static DefaultFactHandle createFromExternalFormat(String externalFormat) {
        DefaultFactHandle handle;
        String[] elements = DefaultFactHandle.splitExternalForm(externalFormat);
        if (FACT_FORMAT_VERSION.equals(elements[0])) {
            handle = new DefaultFactHandle();
        } else if ("5".equals(elements[0])) {
            handle = new EventFactHandle();
        } else {
            throw new RuntimeException("Unknown fact handle version format: " + elements[0]);
        }
        DefaultFactHandle.populateFactHandleFromExternalForm(elements, handle);
        return handle;
    }

    private static String[] splitExternalForm(String externalFormat) {
        String[] elements = externalFormat.split(":");
        if (elements.length < 6) {
            throw new IllegalArgumentException("externalFormat did not have enough elements [" + externalFormat + "]");
        }
        return elements;
    }

    private static void populateFactHandleFromExternalForm(String externalFormat, DefaultFactHandle handle) {
        DefaultFactHandle.populateFactHandleFromExternalForm(DefaultFactHandle.splitExternalForm(externalFormat), handle);
    }

    private static void populateFactHandleFromExternalForm(String[] elements, DefaultFactHandle handle) {
        handle.id = Long.parseLong(elements[1]);
        handle.identityHashCode = Integer.parseInt(elements[2]);
        handle.objectHashCode = Integer.parseInt(elements[3]);
        handle.recency = Long.parseLong(elements[4]);
        handle.entryPointId = StringUtils.isEmpty(elements[5]) || "null".equals(elements[5].trim()) ? null : new EntryPointId(elements[5].trim());
        handle.disconnected = true;
        handle.traitType = elements.length > 6 ? TraitTypeEnum.valueOf(elements[6]) : TraitTypeEnum.NON_TRAIT;
        handle.objectClassName = elements.length > 7 ? elements[7] : null;
    }

    protected TraitTypeEnum determineTraitType(Object object, boolean isTraitOrTraitable) {
        return TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public boolean isTraitable() {
        return this.traitType == TraitTypeEnum.TRAITABLE || this.traitType == TraitTypeEnum.WRAPPED_TRAITABLE;
    }

    @Override
    public boolean isTraiting() {
        return this.traitType == TraitTypeEnum.TRAIT;
    }

    @Override
    public TraitTypeEnum getTraitType() {
        return this.traitType;
    }

    protected void setTraitType(TraitTypeEnum traitType) {
        this.traitType = traitType;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isPendingRemoveFromStore() {
        return false;
    }

    @Override
    public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
        this.linkedTuples.forEachRightTuple(rightTupleConsumer);
    }

    @Override
    public RightTuple findFirstRightTuple(Predicate<RightTuple> rightTuplePredicate) {
        return this.linkedTuples.findFirstRightTuple(rightTuplePredicate);
    }

    @Override
    public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
        this.linkedTuples.forEachLeftTuple(leftTupleConsumer);
    }

    @Override
    public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
        return this.linkedTuples.findFirstLeftTuple(lefttTuplePredicate);
    }

    @Override
    public LeftTuple getFirstLeftTuple() {
        if (this.linkedTuples instanceof SingleLinkedTuples) {
            return ((SingleLinkedTuples)this.linkedTuples).getFirstLeftTuple();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
        if (!(this.linkedTuples instanceof SingleLinkedTuples)) {
            throw new UnsupportedOperationException();
        }
        ((SingleLinkedTuples)this.linkedTuples).setFirstLeftTuple(firstLeftTuple);
    }

    @Override
    public RightTuple getFirstRightTuple() {
        if (this.linkedTuples instanceof SingleLinkedTuples) {
            return ((SingleLinkedTuples)this.linkedTuples).getFirstRightTuple();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalFactHandle.LinkedTuples getLinkedTuples() {
        return this.linkedTuples;
    }

    @Override
    public InternalFactHandle.LinkedTuples detachLinkedTuples() {
        InternalFactHandle.LinkedTuples detached = this.linkedTuples;
        this.linkedTuples = new SingleLinkedTuples();
        return detached;
    }

    @Override
    public InternalFactHandle.LinkedTuples detachLinkedTuplesForPartition(int i) {
        SingleLinkedTuples detached = ((CompositeLinkedTuples)this.linkedTuples).partitionedTuples[i];
        ((CompositeLinkedTuples)((CompositeLinkedTuples)this.linkedTuples)).partitionedTuples[i] = new SingleLinkedTuples();
        return detached;
    }

    @Override
    public InternalFactHandle getParentHandle() {
        return this.parentHandle;
    }

    @Override
    public void setParentHandle(InternalFactHandle parentHandle) {
        this.parentHandle = parentHandle;
    }

    public static class CompositeLinkedTuples
    implements InternalFactHandle.LinkedTuples {
        private final SingleLinkedTuples[] partitionedTuples = new SingleLinkedTuples[RuleBasePartitionId.PARALLEL_PARTITIONS_NUMBER];

        public CompositeLinkedTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.partitionedTuples[i] = new SingleLinkedTuples();
            }
        }

        @Override
        public InternalFactHandle.LinkedTuples newInstance() {
            return new CompositeLinkedTuples();
        }

        @Override
        public InternalFactHandle.LinkedTuples clone() {
            CompositeLinkedTuples clone = new CompositeLinkedTuples();
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                clone.partitionedTuples[i] = this.partitionedTuples[i].clone();
            }
            return clone;
        }

        private InternalFactHandle.LinkedTuples getPartitionTuples(Tuple tuple) {
            return this.partitionedTuples[tuple.getTupleSink().getPartitionId().getParallelEvaluationSlot()];
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            this.getPartitionTuples(leftTuple).addFirstLeftTuple(leftTuple);
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            this.getPartitionTuples(leftTuple).addLastLeftTuple(leftTuple);
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            this.getPartitionTuples(tuple).addTupleInPosition(tuple);
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            this.getPartitionTuples(leftTuple).removeLeftTuple(leftTuple);
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            this.getPartitionTuples(rightTuple).addFirstRightTuple(rightTuple);
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            this.getPartitionTuples(rightTuple).addLastRightTuple(rightTuple);
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            if (rightTuple.getTupleSink() != null) {
                this.getPartitionTuples(rightTuple).removeRightTuple(rightTuple);
            }
        }

        @Override
        public void clearLeftTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.clearLeftTuples(i);
            }
        }

        public void clearLeftTuples(int partition) {
            this.partitionedTuples[partition].clearLeftTuples();
        }

        @Override
        public void clearRightTuples() {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.clearRightTuples(i);
            }
        }

        public void clearRightTuples(int partition) {
            this.partitionedTuples[partition].clearRightTuples();
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.forEachRightTuple(i, rightTupleConsumer);
            }
        }

        public void forEachRightTuple(int partition, Consumer<RightTuple> rightTupleConsumer) {
            this.partitionedTuples[partition].forEachRightTuple(rightTupleConsumer);
        }

        @Override
        public RightTuple findFirstRightTuple(Predicate<RightTuple> rightTuplePredicate) {
            return Stream.of(this.partitionedTuples).map(t -> t.findFirstRightTuple(rightTuplePredicate)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
            for (int i = 0; i < this.partitionedTuples.length; ++i) {
                this.forEachLeftTuple(i, leftTupleConsumer);
            }
        }

        public void forEachLeftTuple(int partition, Consumer<LeftTuple> leftTupleConsumer) {
            this.partitionedTuples[partition].forEachLeftTuple(leftTupleConsumer);
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
            return Stream.of(this.partitionedTuples).map(t -> t.findFirstLeftTuple(lefttTuplePredicate)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public LeftTuple getFirstLeftTuple(int partition) {
            return this.partitionedTuples[partition].getFirstLeftTuple();
        }

        @Override
        public void setFirstLeftTuple(LeftTuple firstLeftTuple, int partition) {
            this.partitionedTuples[partition].setFirstLeftTuple(firstLeftTuple);
        }

        @Override
        public RightTuple getFirstRightTuple(int partition) {
            return this.partitionedTuples[partition].getFirstRightTuple();
        }
    }

    public static class SingleLinkedTuples
    implements InternalFactHandle.LinkedTuples {
        private RightTuple firstRightTuple;
        private RightTuple lastRightTuple;
        private LeftTuple firstLeftTuple;
        private LeftTuple lastLeftTuple;

        @Override
        public SingleLinkedTuples clone() {
            SingleLinkedTuples clone = new SingleLinkedTuples();
            clone.firstLeftTuple = this.firstLeftTuple;
            clone.lastLeftTuple = this.lastLeftTuple;
            clone.firstRightTuple = this.firstRightTuple;
            clone.lastRightTuple = this.lastRightTuple;
            return clone;
        }

        @Override
        public InternalFactHandle.LinkedTuples newInstance() {
            return new SingleLinkedTuples();
        }

        @Override
        public void addFirstLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = this.firstLeftTuple;
            if (previous == null) {
                leftTuple.setHandlePrevious(null);
                leftTuple.setHandleNext(null);
                this.firstLeftTuple = leftTuple;
                this.lastLeftTuple = leftTuple;
            } else {
                leftTuple.setHandlePrevious(null);
                leftTuple.setHandleNext(previous);
                previous.setHandlePrevious(leftTuple);
                this.firstLeftTuple = leftTuple;
            }
        }

        @Override
        public void addLastLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = this.lastLeftTuple;
            if (previous == null) {
                leftTuple.setHandlePrevious(null);
                leftTuple.setHandleNext(null);
                this.firstLeftTuple = leftTuple;
                this.lastLeftTuple = leftTuple;
            } else {
                leftTuple.setHandlePrevious(previous);
                leftTuple.setHandleNext(null);
                previous.setHandleNext(leftTuple);
                this.lastLeftTuple = leftTuple;
            }
        }

        @Override
        public void addTupleInPosition(Tuple tuple) {
            Tuple previous;
            boolean left = tuple instanceof LeftTuple;
            ObjectTypeNode.Id otnId = tuple.getInputOtnId();
            if (otnId == null) {
                this.addLastTuple(tuple, left);
                return;
            }
            Tuple tuple2 = previous = left ? this.lastLeftTuple : this.lastRightTuple;
            if (previous == null) {
                tuple.setHandlePrevious(null);
                tuple.setHandleNext(null);
                this.setFirstTuple(tuple, left);
                this.setLastTuple(tuple, left);
                return;
            }
            if (previous.getTupleSink() == null || !otnId.before(previous.getInputOtnId())) {
                tuple.setHandlePrevious(previous);
                tuple.setHandleNext(null);
                previous.setHandleNext(tuple);
                this.setLastTuple(tuple, left);
                return;
            }
            Tuple next = previous;
            for (previous = previous.getHandlePrevious(); previous != null && otnId.before(previous.getInputOtnId()); previous = previous.getHandlePrevious()) {
                next = previous;
            }
            tuple.setHandleNext(next);
            next.setHandlePrevious(tuple);
            tuple.setHandlePrevious(previous);
            if (previous != null) {
                previous.setHandleNext(tuple);
            } else {
                this.setFirstTuple(tuple, left);
            }
        }

        private void addLastTuple(Tuple tuple, boolean left) {
            if (left) {
                this.addLastLeftTuple((LeftTuple)tuple);
            } else {
                this.addLastRightTuple((RightTuple)tuple);
            }
        }

        private void setFirstTuple(Tuple tuple, boolean left) {
            if (left) {
                this.firstLeftTuple = (LeftTuple)tuple;
            } else {
                this.firstRightTuple = (RightTuple)tuple;
            }
        }

        private void setLastTuple(Tuple tuple, boolean left) {
            if (left) {
                this.lastLeftTuple = (LeftTuple)tuple;
            } else {
                this.lastRightTuple = (RightTuple)tuple;
            }
        }

        @Override
        public void removeLeftTuple(LeftTuple leftTuple) {
            LeftTuple previous = (LeftTuple)leftTuple.getHandlePrevious();
            LeftTuple next = (LeftTuple)leftTuple.getHandleNext();
            if (previous != null && next != null) {
                previous.setHandleNext(next);
                next.setHandlePrevious(previous);
            } else if (next != null) {
                next.setHandlePrevious(null);
                this.firstLeftTuple = next;
            } else if (previous != null) {
                previous.setHandleNext(null);
                this.lastLeftTuple = previous;
            } else {
                this.firstLeftTuple = null;
                this.lastLeftTuple = null;
            }
            leftTuple.setHandlePrevious(null);
            leftTuple.setHandleNext(null);
        }

        @Override
        public void addFirstRightTuple(RightTuple rightTuple) {
            RightTuple previousFirst = this.firstRightTuple;
            this.firstRightTuple = rightTuple;
            if (previousFirst == null) {
                rightTuple.setHandlePrevious(null);
                rightTuple.setHandleNext(null);
                this.lastRightTuple = rightTuple;
            } else {
                rightTuple.setHandlePrevious(null);
                rightTuple.setHandleNext(previousFirst);
                previousFirst.setHandlePrevious(rightTuple);
            }
        }

        @Override
        public void addLastRightTuple(RightTuple rightTuple) {
            RightTuple previousLast = this.lastRightTuple;
            if (previousLast == null) {
                rightTuple.setHandlePrevious(null);
                rightTuple.setHandleNext(null);
                this.firstRightTuple = rightTuple;
                this.lastRightTuple = rightTuple;
            } else {
                rightTuple.setHandlePrevious(previousLast);
                rightTuple.setHandleNext(null);
                previousLast.setHandleNext(rightTuple);
                this.lastRightTuple = rightTuple;
            }
        }

        @Override
        public void removeRightTuple(RightTuple rightTuple) {
            RightTuple previous = (RightTuple)rightTuple.getHandlePrevious();
            RightTuple next = (RightTuple)rightTuple.getHandleNext();
            if (previous != null && next != null) {
                previous.setHandleNext(next);
                next.setHandlePrevious(previous);
            } else if (next != null) {
                next.setHandlePrevious(null);
                this.firstRightTuple = next;
            } else if (previous != null) {
                previous.setHandleNext(null);
                this.lastRightTuple = previous;
            } else {
                this.firstRightTuple = null;
                this.lastRightTuple = null;
            }
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
        }

        @Override
        public void clearLeftTuples() {
            this.firstLeftTuple = null;
            this.lastLeftTuple = null;
        }

        @Override
        public void clearRightTuples() {
            this.firstRightTuple = null;
            this.lastRightTuple = null;
        }

        @Override
        public void forEachRightTuple(Consumer<RightTuple> rightTupleConsumer) {
            RightTuple rightTuple = this.firstRightTuple;
            while (rightTuple != null) {
                RightTuple nextRightTuple = (RightTuple)rightTuple.getHandleNext();
                rightTupleConsumer.accept(rightTuple);
                rightTuple = nextRightTuple;
            }
        }

        @Override
        public RightTuple findFirstRightTuple(Predicate<RightTuple> rightTuplePredicate) {
            RightTuple rightTuple = this.firstRightTuple;
            while (rightTuple != null) {
                RightTuple nextRightTuple = (RightTuple)rightTuple.getHandleNext();
                if (rightTuplePredicate.test(rightTuple)) {
                    return rightTuple;
                }
                rightTuple = nextRightTuple;
            }
            return null;
        }

        @Override
        public void forEachLeftTuple(Consumer<LeftTuple> leftTupleConsumer) {
            LeftTuple leftTuple = this.firstLeftTuple;
            while (leftTuple != null) {
                LeftTuple nextLeftTuple = (LeftTuple)leftTuple.getHandleNext();
                leftTupleConsumer.accept(leftTuple);
                leftTuple = nextLeftTuple;
            }
        }

        @Override
        public LeftTuple findFirstLeftTuple(Predicate<LeftTuple> lefttTuplePredicate) {
            LeftTuple leftTuple = this.firstLeftTuple;
            while (leftTuple != null) {
                LeftTuple nextLeftTuple = (LeftTuple)leftTuple.getHandleNext();
                if (lefttTuplePredicate.test(leftTuple)) {
                    return leftTuple;
                }
                leftTuple = nextLeftTuple;
            }
            return null;
        }

        @Override
        public LeftTuple getFirstLeftTuple(int partition) {
            return this.getFirstLeftTuple();
        }

        LeftTuple getFirstLeftTuple() {
            return this.firstLeftTuple;
        }

        @Override
        public void setFirstLeftTuple(LeftTuple firstLeftTuple, int partition) {
            this.setFirstLeftTuple(firstLeftTuple);
        }

        void setFirstLeftTuple(LeftTuple firstLeftTuple) {
            this.firstLeftTuple = firstLeftTuple;
        }

        @Override
        public RightTuple getFirstRightTuple(int partition) {
            return this.getFirstRightTuple();
        }

        RightTuple getFirstRightTuple() {
            return this.firstRightTuple;
        }
    }
}

