/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.range;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.utils.AbstractIterator;

class ReplicaPlanMerger
extends AbstractIterator<ReplicaPlan.ForRangeRead> {
    private final Keyspace keyspace;
    private final ConsistencyLevel consistency;
    private final PeekingIterator<ReplicaPlan.ForRangeRead> ranges;

    ReplicaPlanMerger(Iterator<ReplicaPlan.ForRangeRead> iterator, Keyspace keyspace, ConsistencyLevel consistency) {
        this.keyspace = keyspace;
        this.consistency = consistency;
        this.ranges = Iterators.peekingIterator(iterator);
    }

    @Override
    protected ReplicaPlan.ForRangeRead computeNext() {
        ReplicaPlan.ForRangeRead next;
        ReplicaPlan.ForRangeRead merged;
        if (!this.ranges.hasNext()) {
            return (ReplicaPlan.ForRangeRead)this.endOfData();
        }
        ReplicaPlan.ForRangeRead current = (ReplicaPlan.ForRangeRead)this.ranges.next();
        while (this.ranges.hasNext() && !((PartitionPosition)current.range().right).isMinimum() && (merged = ReplicaPlans.maybeMerge(this.keyspace, this.consistency, current, next = (ReplicaPlan.ForRangeRead)this.ranges.peek())) != null) {
            current = merged;
            this.ranges.next();
        }
        return current;
    }
}

