/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha;

import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.StandaloneJobGraphStore;
import org.apache.flink.util.Preconditions;

public abstract class AbstractNonHaServices
implements HighAvailabilityServices {
    protected final Object lock = new Object();
    private final JobResultStore jobResultStore = new EmbeddedJobResultStore();
    private final VoidBlobStore voidBlobStore = new VoidBlobStore();
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneCheckpointRecoveryFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobGraphStore getJobGraphStore() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneJobGraphStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobResultStore getJobResultStore() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return this.jobResultStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobStore createBlobStore() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return this.voidBlobStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
            }
        }
    }

    @Override
    public void cleanupAllData() throws Exception {
    }

    @GuardedBy(value="lock")
    protected void checkNotShutdown() {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"high availability services are shut down");
    }

    protected boolean isShutDown() {
        return this.shutdown;
    }
}

