/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.internal;

import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.AutoValue_ImmutableSpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanId;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceFlags;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceId;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.TraceState;

@Immutable
@AutoValue
public abstract class ImmutableSpanContext
implements SpanContext {
    public static final SpanContext INVALID = ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault(), false, false);

    private static AutoValue_ImmutableSpanContext createInternal(String traceId, String spanId, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean valid) {
        return new AutoValue_ImmutableSpanContext(traceId, spanId, traceFlags, traceState, remote, valid);
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean skipIdValidation) {
        if (skipIdValidation || SpanId.isValid(spanIdHex) && TraceId.isValid(traceIdHex)) {
            return ImmutableSpanContext.createInternal(traceIdHex, spanIdHex, traceFlags, traceState, remote, true);
        }
        return ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), traceFlags, traceState, remote, false);
    }

    @Override
    public abstract boolean isValid();
}

