/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.protobuf.Duration;
import net.snowflake.client.jdbc.internal.google.re2j.Pattern;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteAction;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_ClusterWeight;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_HashPolicy;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteAction_RetryPolicy;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_VirtualHost_Route_RouteMatch_PathMatcher;
import net.snowflake.client.jdbc.internal.grpc.xds.ClusterSpecifierPlugin;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.Matchers;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@AutoValue
abstract class VirtualHost {
    VirtualHost() {
    }

    abstract String name();

    abstract ImmutableList<String> domains();

    abstract ImmutableList<Route> routes();

    abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

    public static VirtualHost create(String name, List<String> domains, List<Route> routes, Map<String, Filter.FilterConfig> filterConfigOverrides) {
        return new AutoValue_VirtualHost(name, ImmutableList.copyOf(domains), ImmutableList.copyOf(routes), ImmutableMap.copyOf(filterConfigOverrides));
    }

    @AutoValue
    static abstract class Route {
        Route() {
        }

        abstract RouteMatch routeMatch();

        @Nullable
        abstract RouteAction routeAction();

        abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

        static Route forAction(RouteMatch routeMatch, RouteAction routeAction, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return Route.create(routeMatch, routeAction, filterConfigOverrides);
        }

        static Route forNonForwardingAction(RouteMatch routeMatch, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return Route.create(routeMatch, null, filterConfigOverrides);
        }

        private static Route create(RouteMatch routeMatch, @Nullable RouteAction routeAction, Map<String, Filter.FilterConfig> filterConfigOverrides) {
            return new AutoValue_VirtualHost_Route(routeMatch, routeAction, ImmutableMap.copyOf(filterConfigOverrides));
        }

        @AutoValue
        static abstract class RouteAction {
            RouteAction() {
            }

            abstract ImmutableList<HashPolicy> hashPolicies();

            @Nullable
            abstract Long timeoutNano();

            @Nullable
            abstract String cluster();

            @Nullable
            abstract ImmutableList<ClusterWeight> weightedClusters();

            @Nullable
            abstract ClusterSpecifierPlugin.NamedPluginConfig namedClusterSpecifierPluginConfig();

            @Nullable
            abstract RetryPolicy retryPolicy();

            static RouteAction forCluster(String cluster, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy) {
                Preconditions.checkNotNull(cluster, "cluster");
                return RouteAction.create(hashPolicies, timeoutNano, cluster, null, null, retryPolicy);
            }

            static RouteAction forWeightedClusters(List<ClusterWeight> weightedClusters, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy) {
                Preconditions.checkNotNull(weightedClusters, "weightedClusters");
                Preconditions.checkArgument(!weightedClusters.isEmpty(), "empty cluster list");
                return RouteAction.create(hashPolicies, timeoutNano, null, weightedClusters, null, retryPolicy);
            }

            static RouteAction forClusterSpecifierPlugin(ClusterSpecifierPlugin.NamedPluginConfig namedConfig, List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable RetryPolicy retryPolicy) {
                Preconditions.checkNotNull(namedConfig, "namedConfig");
                return RouteAction.create(hashPolicies, timeoutNano, null, null, namedConfig, retryPolicy);
            }

            private static RouteAction create(List<HashPolicy> hashPolicies, @Nullable Long timeoutNano, @Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters, @Nullable ClusterSpecifierPlugin.NamedPluginConfig namedConfig, @Nullable RetryPolicy retryPolicy) {
                return new AutoValue_VirtualHost_Route_RouteAction(ImmutableList.copyOf(hashPolicies), timeoutNano, cluster, weightedClusters == null ? null : ImmutableList.copyOf(weightedClusters), namedConfig, retryPolicy);
            }

            @AutoValue
            static abstract class RetryPolicy {
                RetryPolicy() {
                }

                abstract int maxAttempts();

                abstract ImmutableList<Status.Code> retryableStatusCodes();

                abstract Duration initialBackoff();

                abstract Duration maxBackoff();

                @Nullable
                abstract Duration perAttemptRecvTimeout();

                static RetryPolicy create(int maxAttempts, List<Status.Code> retryableStatusCodes, Duration initialBackoff, Duration maxBackoff, @Nullable Duration perAttemptRecvTimeout) {
                    return new AutoValue_VirtualHost_Route_RouteAction_RetryPolicy(maxAttempts, ImmutableList.copyOf(retryableStatusCodes), initialBackoff, maxBackoff, perAttemptRecvTimeout);
                }
            }

            @AutoValue
            static abstract class HashPolicy {
                HashPolicy() {
                }

                abstract Type type();

                abstract boolean isTerminal();

                @Nullable
                abstract String headerName();

                @Nullable
                abstract Pattern regEx();

                @Nullable
                abstract String regExSubstitution();

                static HashPolicy forHeader(boolean isTerminal, String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    Preconditions.checkNotNull(headerName, "headerName");
                    return HashPolicy.create(Type.HEADER, isTerminal, headerName, regEx, regExSubstitution);
                }

                static HashPolicy forChannelId(boolean isTerminal) {
                    return HashPolicy.create(Type.CHANNEL_ID, isTerminal, null, null, null);
                }

                private static HashPolicy create(Type type, boolean isTerminal, @Nullable String headerName, @Nullable Pattern regEx, @Nullable String regExSubstitution) {
                    return new AutoValue_VirtualHost_Route_RouteAction_HashPolicy(type, isTerminal, headerName, regEx, regExSubstitution);
                }

                static enum Type {
                    HEADER,
                    CHANNEL_ID;

                }
            }

            @AutoValue
            static abstract class ClusterWeight {
                ClusterWeight() {
                }

                abstract String name();

                abstract int weight();

                abstract ImmutableMap<String, Filter.FilterConfig> filterConfigOverrides();

                static ClusterWeight create(String name, int weight, Map<String, Filter.FilterConfig> filterConfigOverrides) {
                    return new AutoValue_VirtualHost_Route_RouteAction_ClusterWeight(name, weight, ImmutableMap.copyOf(filterConfigOverrides));
                }
            }
        }

        @AutoValue
        static abstract class RouteMatch {
            RouteMatch() {
            }

            abstract PathMatcher pathMatcher();

            abstract ImmutableList<Matchers.HeaderMatcher> headerMatchers();

            @Nullable
            abstract Matchers.FractionMatcher fractionMatcher();

            @VisibleForTesting
            static RouteMatch withPathExactOnly(String path) {
                return RouteMatch.create(PathMatcher.fromPath(path, true), Collections.emptyList(), null);
            }

            static RouteMatch create(PathMatcher pathMatcher, List<Matchers.HeaderMatcher> headerMatchers, @Nullable Matchers.FractionMatcher fractionMatcher) {
                return new AutoValue_VirtualHost_Route_RouteMatch(pathMatcher, ImmutableList.copyOf(headerMatchers), fractionMatcher);
            }

            @AutoValue
            static abstract class PathMatcher {
                PathMatcher() {
                }

                @Nullable
                abstract String path();

                @Nullable
                abstract String prefix();

                @Nullable
                abstract Pattern regEx();

                abstract boolean caseSensitive();

                static PathMatcher fromPath(String path, boolean caseSensitive) {
                    Preconditions.checkNotNull(path, "path");
                    return PathMatcher.create(path, null, null, caseSensitive);
                }

                static PathMatcher fromPrefix(String prefix, boolean caseSensitive) {
                    Preconditions.checkNotNull(prefix, "prefix");
                    return PathMatcher.create(null, prefix, null, caseSensitive);
                }

                static PathMatcher fromRegEx(Pattern regEx) {
                    Preconditions.checkNotNull(regEx, "regEx");
                    return PathMatcher.create(null, null, regEx, false);
                }

                private static PathMatcher create(@Nullable String path, @Nullable String prefix, @Nullable Pattern regEx, boolean caseSensitive) {
                    return new AutoValue_VirtualHost_Route_RouteMatch_PathMatcher(path, prefix, regEx, caseSensitive);
                }
            }
        }
    }
}

