/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroencode;

import java.util.Objects;
import org.apache.hop.core.Const;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class SourceField {
    @HopMetadataProperty(key="source_field")
    private String sourceFieldName;
    @HopMetadataProperty(key="target_field_name")
    private String targetFieldName;

    public SourceField() {
    }

    public SourceField(String sourceFieldName, String targetFieldName) {
        this.sourceFieldName = sourceFieldName;
        this.targetFieldName = targetFieldName;
    }

    public SourceField(SourceField f) {
        this.sourceFieldName = f.sourceFieldName;
        this.targetFieldName = f.targetFieldName;
    }

    public SourceField clone() {
        return new SourceField(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceField that = (SourceField)o;
        return Objects.equals(this.sourceFieldName, that.sourceFieldName);
    }

    public int hashCode() {
        return Objects.hash(this.sourceFieldName);
    }

    public String calculateTargetFieldName() {
        return Const.NVL((String)this.targetFieldName, (String)this.sourceFieldName);
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public void setSourceFieldName(String sourceFieldName) {
        this.sourceFieldName = sourceFieldName;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetFieldName) {
        this.targetFieldName = targetFieldName;
    }
}

