/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sendnagiospassivecheck;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.SocketUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.sendnagiospassivecheck.ActionSendNagiosPassiveCheck;
import org.apache.hop.workflow.actions.sendnagiospassivecheck.EncryptionModeEnum;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ActionSendNagiosPassiveCheckDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionSendNagiosPassiveCheck.class;
    private LabelText wName;
    private LabelTextVar wServerName;
    private LabelTextVar wResponseTimeOut;
    private LabelTextVar wPassword;
    private LabelTextVar wSenderServerName;
    private LabelTextVar wSenderServiceName;
    private ActionSendNagiosPassiveCheck action;
    private boolean changed;
    private LabelTextVar wPort;
    private LabelTextVar wConnectionTimeOut;
    private StyledTextComp wMessage;
    private CCombo wEncryptionMode;
    private CCombo wLevelMode;

    public ActionSendNagiosPassiveCheckDialog(Shell parent, ActionSendNagiosPassiveCheck action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ServerSettings.General", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        this.wServerName = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Server.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(0, 0);
        fdServerName.top = new FormAttachment((Control)this.wName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        this.wPort = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Port.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(0, 0);
        fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Password.Label", (String[])new String[0]), BaseMessages.getString((String)"JobSendNagiosPassiveCheck.Password.Tooltip"), true);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wPort, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        this.wConnectionTimeOut = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ConnectionTimeOut.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ConnectionTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wConnectionTimeOut);
        this.wConnectionTimeOut.addModifyListener(lsMod);
        FormData fdwConnectionTimeOut = new FormData();
        fdwConnectionTimeOut.left = new FormAttachment(0, 0);
        fdwConnectionTimeOut.top = new FormAttachment((Control)this.wPassword, margin);
        fdwConnectionTimeOut.right = new FormAttachment(100, 0);
        this.wConnectionTimeOut.setLayoutData((Object)fdwConnectionTimeOut);
        this.wResponseTimeOut = new LabelTextVar(this.variables, (Composite)wServerSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ResponseTimeOut.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ResponseTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResponseTimeOut);
        this.wResponseTimeOut.addModifyListener(lsMod);
        FormData fdResponseTimeOut = new FormData();
        fdResponseTimeOut.left = new FormAttachment(0, 0);
        fdResponseTimeOut.top = new FormAttachment((Control)this.wConnectionTimeOut, margin);
        fdResponseTimeOut.right = new FormAttachment(100, 0);
        this.wResponseTimeOut.setLayoutData((Object)fdResponseTimeOut);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wResponseTimeOut, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        Group wSenderSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSenderSettings);
        wSenderSettings.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.SenderSettings.Group.Label", (String[])new String[0]));
        FormLayout senderSettingsgroupLayout = new FormLayout();
        senderSettingsgroupLayout.marginWidth = 10;
        senderSettingsgroupLayout.marginHeight = 10;
        wSenderSettings.setLayout((Layout)senderSettingsgroupLayout);
        this.wSenderServerName = new LabelTextVar(this.variables, (Composite)wSenderSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.SenderServerName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.SenderServerName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSenderServerName);
        this.wSenderServerName.addModifyListener(lsMod);
        FormData fdSenderServerName = new FormData();
        fdSenderServerName.left = new FormAttachment(0, 0);
        fdSenderServerName.top = new FormAttachment((Control)wServerSettings, margin);
        fdSenderServerName.right = new FormAttachment(100, 0);
        this.wSenderServerName.setLayoutData((Object)fdSenderServerName);
        this.wSenderServiceName = new LabelTextVar(this.variables, (Composite)wSenderSettings, BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.SenderServiceName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.SenderServiceName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSenderServiceName);
        this.wSenderServiceName.addModifyListener(lsMod);
        FormData fdSenderServiceName = new FormData();
        fdSenderServiceName.left = new FormAttachment(0, 0);
        fdSenderServiceName.top = new FormAttachment((Control)this.wSenderServerName, margin);
        fdSenderServiceName.right = new FormAttachment(100, 0);
        this.wSenderServiceName.setLayoutData((Object)fdSenderServiceName);
        Label wlEncryptionMode = new Label((Composite)wSenderSettings, 131072);
        wlEncryptionMode.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncryptionMode);
        FormData fdlEncryptionMode = new FormData();
        fdlEncryptionMode.left = new FormAttachment(0, margin);
        fdlEncryptionMode.right = new FormAttachment(middle, -margin);
        fdlEncryptionMode.top = new FormAttachment((Control)this.wSenderServiceName, margin);
        wlEncryptionMode.setLayoutData((Object)fdlEncryptionMode);
        this.wEncryptionMode = new CCombo((Composite)wSenderSettings, 2060);
        this.wEncryptionMode.setItems(ActionSendNagiosPassiveCheck.encryptionModeDesc);
        PropsUi.setLook((Widget)this.wEncryptionMode);
        FormData fdEncryptionMode = new FormData();
        fdEncryptionMode.left = new FormAttachment(middle, 0);
        fdEncryptionMode.top = new FormAttachment((Control)this.wSenderServiceName, margin);
        fdEncryptionMode.right = new FormAttachment(100, 0);
        this.wEncryptionMode.setLayoutData((Object)fdEncryptionMode);
        this.wEncryptionMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label wlLevelMode = new Label((Composite)wSenderSettings, 131072);
        wlLevelMode.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.LevelMode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLevelMode);
        FormData fdlLevelMode = new FormData();
        fdlLevelMode.left = new FormAttachment(0, margin);
        fdlLevelMode.right = new FormAttachment(middle, -margin);
        fdlLevelMode.top = new FormAttachment((Control)this.wEncryptionMode, margin);
        wlLevelMode.setLayoutData((Object)fdlLevelMode);
        this.wLevelMode = new CCombo((Composite)wSenderSettings, 2060);
        this.wLevelMode.setItems(ActionSendNagiosPassiveCheck.levelTypeDesc);
        PropsUi.setLook((Widget)this.wLevelMode);
        FormData fdLevelMode = new FormData();
        fdLevelMode.left = new FormAttachment(middle, 0);
        fdLevelMode.top = new FormAttachment((Control)this.wEncryptionMode, margin);
        fdLevelMode.right = new FormAttachment(100, 0);
        this.wLevelMode.setLayoutData((Object)fdLevelMode);
        this.wLevelMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        FormData fdSenderSettings = new FormData();
        fdSenderSettings.left = new FormAttachment(0, margin);
        fdSenderSettings.top = new FormAttachment((Control)wServerSettings, margin);
        fdSenderSettings.right = new FormAttachment(100, -margin);
        wSenderSettings.setLayoutData((Object)fdSenderSettings);
        Group wMessageGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wMessageGroup);
        wMessageGroup.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.MessageGroup.Group.Label", (String[])new String[0]));
        FormLayout messageGroupgroupLayout = new FormLayout();
        messageGroupgroupLayout.marginWidth = 10;
        messageGroupgroupLayout.marginHeight = 10;
        wMessageGroup.setLayout((Layout)messageGroupgroupLayout);
        Label wlMessage = new Label((Composite)wMessageGroup, 131072);
        wlMessage.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Message.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessage);
        FormData fdlMessage = new FormData();
        fdlMessage.left = new FormAttachment(0, 0);
        fdlMessage.top = new FormAttachment((Control)wSenderSettings, margin);
        fdlMessage.right = new FormAttachment(middle, -margin);
        wlMessage.setLayoutData((Object)fdlMessage);
        this.wMessage = new StyledTextComp(this.variables, (Composite)wMessageGroup, 19202);
        PropsUi.setLook((Widget)this.wMessage);
        this.wMessage.addModifyListener(lsMod);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(middle, 0);
        fdMessage.top = new FormAttachment((Control)wSenderSettings, margin);
        fdMessage.right = new FormAttachment(100, 0);
        fdMessage.bottom = new FormAttachment(100, -margin);
        this.wMessage.setLayoutData((Object)fdMessage);
        FormData fdMessageGroup = new FormData();
        fdMessageGroup.left = new FormAttachment(0, margin);
        fdMessageGroup.top = new FormAttachment((Control)wSenderSettings, margin);
        fdMessageGroup.right = new FormAttachment(100, -margin);
        fdMessageGroup.bottom = new FormAttachment(100, -margin);
        wMessageGroup.setLayoutData((Object)fdMessageGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void test() {
        boolean testOK = false;
        String errMsg = null;
        String hostname = this.variables.resolve(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.variables.resolve(this.wPort.getText()), (int)5667);
        int realConnectionTimeOut = Const.toInt((String)this.variables.resolve(this.wConnectionTimeOut.getText()), (int)-1);
        try {
            SocketUtil.connectToHost((String)hostname, (int)nrPort, (int)realConnectionTimeOut);
            testOK = true;
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (testOK) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Connected.OK", (String[])new String[]{hostname}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Connected.NOK.ConnectionBad", (String[])new String[]{hostname}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wPort.setText(Const.nullToEmpty((String)this.action.getPort()));
        this.wConnectionTimeOut.setText(Const.NVL((String)this.action.getConnectionTimeOut(), (String)""));
        this.wResponseTimeOut.setText(Const.nullToEmpty((String)this.action.getResponseTimeOut()));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wSenderServerName.setText(Const.NVL((String)this.action.getSenderServerName(), (String)""));
        this.wSenderServiceName.setText(Const.NVL((String)this.action.getSenderServiceName(), (String)""));
        this.wMessage.setText(Const.NVL((String)this.action.getMessage(), (String)""));
        this.wEncryptionMode.setText(ActionSendNagiosPassiveCheck.getEncryptionModeDesc(this.action.getEncryptionMode().getOriginalCode()));
        this.wLevelMode.setText(ActionSendNagiosPassiveCheck.getLevelDesc(this.action.getLevel()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.Error.TransformNameMissing.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Error.TransformNameMissing.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setPort(this.wPort.getText());
        this.action.setServerName(this.wServerName.getText());
        this.action.setConnectionTimeOut(this.wConnectionTimeOut.getText());
        this.action.setResponseTimeOut(this.wResponseTimeOut.getText());
        this.action.setSenderServerName(this.wSenderServerName.getText());
        this.action.setSenderServiceName(this.wSenderServiceName.getText());
        this.action.setMessage(this.wMessage.getText());
        EncryptionModeEnum encryptionModeEnum = EncryptionModeEnum.getEncruptionModeEnum(this.wEncryptionMode.getSelectionIndex());
        this.action.setEncryptionMode(encryptionModeEnum);
        this.action.setLevel(this.wLevelMode.getSelectionIndex());
        this.action.setPassword(this.wPassword.getText());
        this.dispose();
    }
}

