/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class UserPermission
implements Cloneable,
Serializable {
    static final long serialVersionUID = 4L;
    static final int COMMIT_NONE = -1;
    static final int COMMIT_ADD = 0;
    static final int COMMIT_REMOVE = 1;
    static final int COMMIT_CHANGE = 2;
    static final int COMMIT_FROM_AUTL = 3;
    public static final int GROUPINDICATOR_SPECIALVALUE = 0;
    public static final int GROUPINDICATOR_USER = 1;
    public static final int GROUPINDICATOR_GROUP = 2;
    static final boolean[][] basicAutMapping = new boolean[][]{{true, true, true, true, true, true, true, true, true, true}, {false, false, false, false, false, false, false, false, false, false}, {true, false, false, false, false, true, false, false, false, true}, {true, false, false, false, false, true, true, true, true, true}};
    static final int BASIC_USER_DEF = -1;
    static final int BASIC_ALL = 0;
    static final int BASIC_EXCLUDE = 1;
    static final int BASIC_USE = 2;
    static final int BASIC_CHANGE = 3;
    static final int DATA_READ = 5;
    static final int DATA_ADD = 6;
    static final int DATA_UPDATE = 7;
    static final int DATA_DELETE = 8;
    static final int DATA_EXECUTE = 9;
    static final int OBJECT_OPERATION = 0;
    static final int OBJECT_MANAGEMENT = 1;
    static final int OBJECT_EXIST = 2;
    static final int OBJECT_ALTER = 3;
    static final int OBJECT_REFERENCE = 4;
    boolean[] authorities_ = new boolean[10];
    String dataAuthority_;
    int objectAuthority_;
    private boolean autListMgt_;
    private int committed_;
    private int groupIndicator_;
    private String userName_;
    private boolean fromAuthorizationList_;

    UserPermission(String userProfileName) {
        for (int i = 0; i < this.authorities_.length; ++i) {
            this.authorities_[i] = false;
        }
        this.dataAuthority_ = "*EXCLUDE";
        this.objectAuthority_ = 1;
        this.userName_ = userProfileName.toUpperCase();
        this.groupIndicator_ = 0;
        this.committed_ = -1;
        this.autListMgt_ = false;
        this.fromAuthorizationList_ = false;
    }

    void changeAuthority() {
        if (this.isFromAuthorizationList()) {
            this.setFromAuthorizationList(false);
        }
        switch (this.getCommitted()) {
            case -1: 
            case 3: {
                this.setCommitted(2);
            }
        }
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        UserPermission cloneObj = (UserPermission)super.clone();
        boolean[] cloneAuths = new boolean[this.authorities_.length];
        System.arraycopy(this.authorities_, 0, cloneAuths, 0, this.authorities_.length);
        cloneObj.authorities_ = cloneAuths;
        return cloneObj;
    }

    int getCommitted() {
        return this.committed_;
    }

    public int getGroupIndicator() {
        return this.groupIndicator_;
    }

    public String getUserID() {
        return this.userName_;
    }

    public boolean isFromAuthorizationList() {
        return this.fromAuthorizationList_;
    }

    public boolean isAuthorizationListManagement() {
        return this.autListMgt_;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        s.readObject();
    }

    public synchronized void setAuthorizationListManagement(boolean autListMgt) {
        this.autListMgt_ = autListMgt;
        if (this.getCommitted() == -1) {
            this.setCommitted(2);
        }
    }

    void setCommitted(int commit) {
        this.committed_ = commit;
    }

    public synchronized void setFromAuthorizationList(boolean fromAutList) {
        if (this.fromAuthorizationList_ == fromAutList) {
            return;
        }
        if (fromAutList) {
            this.fromAuthorizationList_ = fromAutList;
            for (int i = 0; i < this.authorities_.length; ++i) {
                this.authorities_[i] = false;
            }
            this.dataAuthority_ = "*AUTL";
            this.setCommitted(3);
        } else {
            this.fromAuthorizationList_ = fromAutList;
            if (this.getCommitted() == 3) {
                this.setCommitted(2);
            }
        }
    }

    synchronized void setGroupIndicator(int indicator) {
        this.groupIndicator_ = indicator;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(null);
    }
}

