/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOError;
import java.io.IOException;
import java.nio.BufferOverflowException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.PartitionSerializationException;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnfilteredRowIteratorSerializer {
    protected static final Logger logger = LoggerFactory.getLogger(UnfilteredRowIteratorSerializer.class);
    public static final int IS_EMPTY = 1;
    private static final int IS_REVERSED = 2;
    private static final int HAS_PARTITION_DELETION = 4;
    private static final int HAS_STATIC_ROW = 8;
    private static final int HAS_ROW_ESTIMATE = 16;
    public static final UnfilteredRowIteratorSerializer serializer = new UnfilteredRowIteratorSerializer();

    public void serialize(UnfilteredRowIterator iterator, ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
        this.serialize(iterator, selection, out, version, -1);
    }

    public void serialize(UnfilteredRowIterator iterator, ColumnFilter selection, DataOutputPlus out, int version, int rowEstimate) throws IOException {
        SerializationHeader header = new SerializationHeader(false, iterator.metadata(), iterator.columns(), iterator.stats());
        try {
            this.serialize(iterator, header, selection, out, version, rowEstimate);
        }
        catch (BufferOverflowException boe) {
            throw new PartitionSerializationException(iterator, (Throwable)boe);
        }
    }

    private void serialize(UnfilteredRowIterator iterator, SerializationHeader header, ColumnFilter selection, DataOutputPlus out, int version, int rowEstimate) throws IOException {
        Row staticRow;
        boolean hasStatic;
        assert (!header.isForSSTable());
        ByteBufferUtil.writeWithVIntLength(iterator.partitionKey().getKey(), out);
        int flags = 0;
        if (iterator.isReverseOrder()) {
            flags |= 2;
        }
        if (iterator.isEmpty()) {
            out.writeByte((byte)(flags | 1));
            return;
        }
        DeletionTime partitionDeletion = iterator.partitionLevelDeletion();
        if (!partitionDeletion.isLive()) {
            flags |= 4;
        }
        boolean bl = hasStatic = (staticRow = iterator.staticRow()) != Rows.EMPTY_STATIC_ROW;
        if (hasStatic) {
            flags |= 8;
        }
        if (rowEstimate >= 0) {
            flags |= 0x10;
        }
        out.writeByte((byte)flags);
        SerializationHeader.serializer.serializeForMessaging(header, selection, out, hasStatic);
        SerializationHelper helper = new SerializationHelper(header);
        if (!partitionDeletion.isLive()) {
            header.writeDeletionTime(partitionDeletion, out);
        }
        if (hasStatic) {
            UnfilteredSerializer.serializer.serialize(staticRow, helper, out, version);
        }
        if (rowEstimate >= 0) {
            out.writeUnsignedVInt(rowEstimate);
        }
        while (iterator.hasNext()) {
            UnfilteredSerializer.serializer.serialize((Unfiltered)iterator.next(), helper, out, version);
        }
        UnfilteredSerializer.serializer.writeEndOfPartition(out);
    }

    public long serializedSize(UnfilteredRowIterator iterator, ColumnFilter selection, int version, int rowEstimate) {
        SerializationHeader header = new SerializationHeader(false, iterator.metadata(), iterator.columns(), iterator.stats());
        SerializationHelper helper = new SerializationHelper(header);
        assert (rowEstimate >= 0);
        long size = ByteBufferUtil.serializedSizeWithVIntLength(iterator.partitionKey().getKey()) + 1;
        if (iterator.isEmpty()) {
            return size;
        }
        DeletionTime partitionDeletion = iterator.partitionLevelDeletion();
        Row staticRow = iterator.staticRow();
        boolean hasStatic = staticRow != Rows.EMPTY_STATIC_ROW;
        size += SerializationHeader.serializer.serializedSizeForMessaging(header, selection, hasStatic);
        if (!partitionDeletion.isLive()) {
            size += header.deletionTimeSerializedSize(partitionDeletion);
        }
        if (hasStatic) {
            size += UnfilteredSerializer.serializer.serializedSize(staticRow, helper, version);
        }
        if (rowEstimate >= 0) {
            size += (long)TypeSizes.sizeofUnsignedVInt(rowEstimate);
        }
        while (iterator.hasNext()) {
            size += UnfilteredSerializer.serializer.serializedSize((Unfiltered)iterator.next(), helper, version);
        }
        return size += UnfilteredSerializer.serializer.serializedSizeEndOfPartition();
    }

    public Header deserializeHeader(TableMetadata metadata, ColumnFilter selection, DataInputPlus in, int version, DeserializationHelper.Flag flag) throws IOException {
        boolean isReversed;
        DecoratedKey key = metadata.partitioner.decorateKey(ByteBufferUtil.readWithVIntLength(in));
        int flags = in.readUnsignedByte();
        boolean bl = isReversed = (flags & 2) != 0;
        if ((flags & 1) != 0) {
            SerializationHeader sh = new SerializationHeader(false, metadata, RegularAndStaticColumns.NONE, EncodingStats.NO_STATS);
            return new Header(sh, key, isReversed, true, null, null, 0);
        }
        boolean hasPartitionDeletion = (flags & 4) != 0;
        boolean hasStatic = (flags & 8) != 0;
        boolean hasRowEstimate = (flags & 0x10) != 0;
        SerializationHeader header = SerializationHeader.serializer.deserializeForMessaging(in, metadata, selection, hasStatic);
        DeletionTime partitionDeletion = hasPartitionDeletion ? header.readDeletionTime(in) : DeletionTime.LIVE;
        Row staticRow = Rows.EMPTY_STATIC_ROW;
        if (hasStatic) {
            staticRow = UnfilteredSerializer.serializer.deserializeStaticRow(in, header, new DeserializationHelper(metadata, version, flag));
        }
        int rowEstimate = hasRowEstimate ? (int)in.readUnsignedVInt() : -1;
        return new Header(header, key, isReversed, false, partitionDeletion, staticRow, rowEstimate);
    }

    public UnfilteredRowIterator deserialize(final DataInputPlus in, int version, TableMetadata metadata, DeserializationHelper.Flag flag, Header header) throws IOException {
        if (header.isEmpty) {
            return EmptyIterators.unfilteredRow(metadata, header.key, header.isReversed);
        }
        final DeserializationHelper helper = new DeserializationHelper(metadata, version, flag);
        final SerializationHeader sHeader = header.sHeader;
        return new AbstractUnfilteredRowIterator(metadata, header.key, header.partitionDeletion, sHeader.columns(), header.staticRow, header.isReversed, sHeader.stats()){
            private final Row.Builder builder;
            {
                super(metadata, partitionKey, partitionLevelDeletion, columns, staticRow, isReverseOrder, stats);
                this.builder = BTreeRow.sortedBuilder();
            }

            @Override
            protected Unfiltered computeNext() {
                try {
                    Unfiltered unfiltered = UnfilteredSerializer.serializer.deserialize(in, sHeader, helper, this.builder);
                    return unfiltered == null ? (Unfiltered)this.endOfData() : unfiltered;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        };
    }

    public UnfilteredRowIterator deserialize(DataInputPlus in, int version, TableMetadata metadata, ColumnFilter selection, DeserializationHelper.Flag flag) throws IOException {
        return this.deserialize(in, version, metadata, flag, this.deserializeHeader(metadata, selection, in, version, flag));
    }

    public static class Header {
        public final SerializationHeader sHeader;
        public final DecoratedKey key;
        public final boolean isReversed;
        public final boolean isEmpty;
        public final DeletionTime partitionDeletion;
        public final Row staticRow;
        public final int rowEstimate;

        private Header(SerializationHeader sHeader, DecoratedKey key, boolean isReversed, boolean isEmpty, DeletionTime partitionDeletion, Row staticRow, int rowEstimate) {
            this.sHeader = sHeader;
            this.key = key;
            this.isReversed = isReversed;
            this.isEmpty = isEmpty;
            this.partitionDeletion = partitionDeletion;
            this.staticRow = staticRow;
            this.rowEstimate = rowEstimate;
        }

        public String toString() {
            return String.format("{header=%s, key=%s, isReversed=%b, isEmpty=%b, del=%s, staticRow=%s, rowEstimate=%d}", this.sHeader, this.key, this.isReversed, this.isEmpty, this.partitionDeletion, this.staticRow, this.rowEstimate);
        }
    }
}

