/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import org.monetdb.jdbc.MonetResultSet;

final class MonetVirtualResultSet
extends MonetResultSet {
    private String[][] results;
    private boolean closed;

    MonetVirtualResultSet(Statement statement, String[] stringArray, String[] stringArray2, String[][] stringArray3) throws IllegalArgumentException {
        super(statement, stringArray, stringArray2, stringArray3.length);
        this.results = stringArray3;
        this.closed = false;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (n < 0) {
            n = (int)this.tupleCount + n + 1;
        }
        if (n < 0) {
            n = 0;
        } else if ((long)n > this.tupleCount + 1L) {
            n = (int)this.tupleCount + 1;
        }
        this.curRow = n;
        if (n < 1 || (long)n > this.tupleCount) {
            return false;
        }
        for (int i = 0; i < this.results[n - 1].length; ++i) {
            this.tlp.values[i] = this.results[n - 1][i];
        }
        return true;
    }

    @Override
    public void close() {
        this.results = null;
        this.closed = true;
        super.close();
    }
}

