/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hadoop;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopDependency {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopDependency.class);

    public static boolean isHadoopCommonOnClasspath(ClassLoader classLoader) {
        try {
            LOG.debug("Checking whether hadoop common dependency in on classpath.");
            Class.forName("org.apache.hadoop.conf.Configuration", false, classLoader);
            Class.forName("org.apache.hadoop.security.UserGroupInformation", false, classLoader);
            LOG.debug("Hadoop common dependency found on classpath.");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Hadoop common dependency cannot be found on classpath.");
            return false;
        }
    }
}

