/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import org.apache.hop.metadata.api.IEnumHasCode;

public enum RelationshipMappingType implements IEnumHasCode
{
    NoMapping("none", "No mapping"),
    NoRelationship("no-relationship", "Do not update relationship between specified nodes"),
    UsingValue("using-value", "Update specific relationship using field value"),
    All("all", "Update all relationships between specified nodes (default)");

    private String code;
    private String description;

    private RelationshipMappingType(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String[] getDescriptions() {
        String[] descriptions = new String[RelationshipMappingType.values().length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = RelationshipMappingType.values()[i].getDescription();
        }
        return descriptions;
    }

    public static RelationshipMappingType getTypeFromDescription(String description) {
        for (RelationshipMappingType type : RelationshipMappingType.values()) {
            if (!type.getDescription().equals(description)) continue;
            return type;
        }
        return NoRelationship;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

