/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseSerializer;
import com.amazonaws.services.kinesis.leases.util.DynamoUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LeaseSerializer
implements ILeaseSerializer<Lease> {
    public final String LEASE_KEY_KEY = "leaseKey";
    public final String LEASE_OWNER_KEY = "leaseOwner";
    public final String LEASE_COUNTER_KEY = "leaseCounter";
    public final Class<? extends Lease> clazz;

    public LeaseSerializer() {
        this.clazz = Lease.class;
    }

    public LeaseSerializer(Class<? extends Lease> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Map<String, AttributeValue> toDynamoRecord(Lease lease) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("leaseKey", DynamoUtils.createAttributeValue(lease.getLeaseKey()));
        result.put("leaseCounter", DynamoUtils.createAttributeValue(lease.getLeaseCounter()));
        if (lease.getLeaseOwner() != null) {
            result.put("leaseOwner", DynamoUtils.createAttributeValue(lease.getLeaseOwner()));
        }
        return result;
    }

    @Override
    public Lease fromDynamoRecord(Map<String, AttributeValue> dynamoRecord) {
        Lease result;
        try {
            result = this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        result.setLeaseKey(DynamoUtils.safeGetString(dynamoRecord, "leaseKey"));
        result.setLeaseOwner(DynamoUtils.safeGetString(dynamoRecord, "leaseOwner"));
        result.setLeaseCounter(DynamoUtils.safeGetLong(dynamoRecord, "leaseCounter"));
        return result;
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(String leaseKey) {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        result.put("leaseKey", DynamoUtils.createAttributeValue(leaseKey));
        return result;
    }

    @Override
    public Map<String, AttributeValue> getDynamoHashKey(Lease lease) {
        return this.getDynamoHashKey(lease.getLeaseKey());
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(Lease lease) {
        return this.getDynamoLeaseCounterExpectation(lease.getLeaseCounter());
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(Long leaseCounter) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue eav = new ExpectedAttributeValue(DynamoUtils.createAttributeValue(leaseCounter));
        result.put("leaseCounter", eav);
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseOwnerExpectation(Lease lease) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue eav = null;
        eav = lease.getLeaseOwner() == null ? new ExpectedAttributeValue(Boolean.valueOf(false)) : new ExpectedAttributeValue(DynamoUtils.createAttributeValue(lease.getLeaseOwner()));
        result.put("leaseOwner", eav);
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoLeaseCheckpointExpectation(Lease lease) {
        return new HashMap<String, ExpectedAttributeValue>();
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoNonexistantExpectation() {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue expectedAV = new ExpectedAttributeValue(Boolean.valueOf(false));
        result.put("leaseKey", expectedAV);
        return result;
    }

    @Override
    public Map<String, ExpectedAttributeValue> getDynamoExistentExpectation(String leaseKey) {
        HashMap<String, ExpectedAttributeValue> result = new HashMap<String, ExpectedAttributeValue>();
        ExpectedAttributeValue expectedAV = new ExpectedAttributeValue();
        expectedAV.setValue(DynamoUtils.createAttributeValue(leaseKey));
        expectedAV.setExists(Boolean.valueOf(true));
        result.put("leaseKey", expectedAV);
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(Lease lease) {
        return this.getDynamoLeaseCounterUpdate(lease.getLeaseCounter());
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(Long leaseCounter) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        AttributeValueUpdate avu = new AttributeValueUpdate(DynamoUtils.createAttributeValue(leaseCounter + 1L), AttributeAction.PUT);
        result.put("leaseCounter", avu);
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoTakeLeaseUpdate(Lease lease, String owner) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        result.put("leaseOwner", new AttributeValueUpdate(DynamoUtils.createAttributeValue(owner), AttributeAction.PUT));
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoEvictLeaseUpdate(Lease lease) {
        HashMap<String, AttributeValueUpdate> result = new HashMap<String, AttributeValueUpdate>();
        result.put("leaseOwner", new AttributeValueUpdate(null, AttributeAction.DELETE));
        return result;
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(Lease lease) {
        return new HashMap<String, AttributeValueUpdate>();
    }

    @Override
    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(Lease lease, UpdateField updateField) {
        return new HashMap<String, AttributeValueUpdate>();
    }

    @Override
    public Collection<KeySchemaElement> getKeySchema() {
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName("leaseKey").withKeyType(KeyType.HASH));
        return keySchema;
    }

    @Override
    public Collection<AttributeDefinition> getAttributeDefinitions() {
        ArrayList<AttributeDefinition> definitions = new ArrayList<AttributeDefinition>();
        definitions.add(new AttributeDefinition().withAttributeName("leaseKey").withAttributeType(ScalarAttributeType.S));
        return definitions;
    }
}

