/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mysqlbulkfile;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.mysqlbulkfile.ActionMysqlBulkFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionMysqlBulkFileDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionMysqlBulkFile.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Filetype.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Filetype.All", (String[])new String[0])};
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wTableName;
    private TextVar wSchemaName;
    private ActionMysqlBulkFile action;
    private TextVar wFilename;
    private Button wHighPriority;
    private TextVar wSeparator;
    private TextVar wEnclosed;
    private Button wOptionEnclosed;
    private TextVar wLineTerminated;
    private TextVar wListColumn;
    private TextVar wLimitLines;
    private CCombo wIfFileExists;
    private CCombo wOutDumpValue;
    private Button wAddFileToResult;

    public ActionMysqlBulkFileDialog(Shell parent, ActionMysqlBulkFile action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), null);
        Label wlSchemaName = new Label((Composite)this.shell, 131072);
        wlSchemaName.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.SchemaName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchemaName);
        FormData fdlSchemaName = new FormData();
        fdlSchemaName.left = new FormAttachment(0, 0);
        fdlSchemaName.right = new FormAttachment(middle, -margin);
        fdlSchemaName.top = new FormAttachment(this.wConnection, margin);
        wlSchemaName.setLayoutData((Object)fdlSchemaName);
        this.wSchemaName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaName);
        this.wSchemaName.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.SchemaName.Tooltip", (String[])new String[0]));
        FormData fdSchemaName = new FormData();
        fdSchemaName.left = new FormAttachment(middle, 0);
        fdSchemaName.top = new FormAttachment((Control)wlSchemaName, 0, 0x1000000);
        fdSchemaName.right = new FormAttachment(100, 0);
        this.wSchemaName.setLayoutData((Object)fdSchemaName);
        Label wlTableName = new Label((Composite)this.shell, 131072);
        wlTableName.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTableName);
        FormData fdlTableName = new FormData();
        fdlTableName.left = new FormAttachment(0, 0);
        fdlTableName.right = new FormAttachment(middle, -margin);
        fdlTableName.top = new FormAttachment((Control)this.wSchemaName, margin);
        wlTableName.setLayoutData((Object)fdlTableName);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wlTableName, 0, 0x1000000);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionMysqlBulkFileDialog.this.getTableName();
            }
        });
        this.wTableName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTableName);
        this.wTableName.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.TableName.Tooltip", (String[])new String[0]));
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)wlTableName, 0, 0x1000000);
        fdTablename.right = new FormAttachment((Control)wbTable, -margin);
        this.wTableName.setLayoutData((Object)fdTablename);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wTableName, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt", "*.csv", "*"}, (String[])FILETYPES, (boolean)true));
        Label wlHighPriority = new Label((Composite)this.shell, 131072);
        wlHighPriority.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.HighPriority.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHighPriority);
        FormData fdlHighPriority = new FormData();
        fdlHighPriority.left = new FormAttachment(0, 0);
        fdlHighPriority.top = new FormAttachment((Control)this.wFilename, margin);
        fdlHighPriority.right = new FormAttachment(middle, -margin);
        wlHighPriority.setLayoutData((Object)fdlHighPriority);
        this.wHighPriority = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wHighPriority);
        this.wHighPriority.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.HighPriority.Tooltip", (String[])new String[0]));
        FormData fdHighPriority = new FormData();
        fdHighPriority.left = new FormAttachment(middle, 0);
        fdHighPriority.top = new FormAttachment((Control)wlHighPriority, 0, 0x1000000);
        fdHighPriority.right = new FormAttachment(100, 0);
        this.wHighPriority.setLayoutData((Object)fdHighPriority);
        Label wlOutDumpValue = new Label((Composite)this.shell, 131072);
        wlOutDumpValue.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.OutDumpValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOutDumpValue);
        FormData fdlOutDumpValue = new FormData();
        fdlOutDumpValue.left = new FormAttachment(0, 0);
        fdlOutDumpValue.right = new FormAttachment(middle, -margin);
        fdlOutDumpValue.top = new FormAttachment((Control)wlHighPriority, 2 * margin);
        wlOutDumpValue.setLayoutData((Object)fdlOutDumpValue);
        this.wOutDumpValue = new CCombo((Composite)this.shell, 2060);
        this.wOutDumpValue.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.OutFileValue.Label", (String[])new String[0]));
        this.wOutDumpValue.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.DumpFileValue.Label", (String[])new String[0]));
        this.wOutDumpValue.select(0);
        PropsUi.setLook((Widget)this.wOutDumpValue);
        FormData fdOutDumpValue = new FormData();
        fdOutDumpValue.left = new FormAttachment(middle, 0);
        fdOutDumpValue.top = new FormAttachment((Control)wlOutDumpValue, 0, 0x1000000);
        fdOutDumpValue.right = new FormAttachment(100, 0);
        this.wOutDumpValue.setLayoutData((Object)fdOutDumpValue);
        this.wOutDumpValue.addListener(13, e -> this.dumpFile());
        Label wlSeparator = new Label((Composite)this.shell, 131072);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Separator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        fdlSeparator.top = new FormAttachment((Control)this.wOutDumpValue, margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        this.wSeparator = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.top = new FormAttachment((Control)wlSeparator, 0, 0x1000000);
        fdSeparator.right = new FormAttachment(100, 0);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        Label wlEnclosed = new Label((Composite)this.shell, 131072);
        wlEnclosed.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Enclosed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosed);
        FormData fdlEnclosed = new FormData();
        fdlEnclosed.left = new FormAttachment(0, 0);
        fdlEnclosed.right = new FormAttachment(middle, -margin);
        fdlEnclosed.top = new FormAttachment((Control)this.wSeparator, margin);
        wlEnclosed.setLayoutData((Object)fdlEnclosed);
        this.wEnclosed = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEnclosed);
        FormData fdEnclosed = new FormData();
        fdEnclosed.left = new FormAttachment(middle, 0);
        fdEnclosed.top = new FormAttachment((Control)wlEnclosed, 0, 0x1000000);
        fdEnclosed.right = new FormAttachment(100, 0);
        this.wEnclosed.setLayoutData((Object)fdEnclosed);
        Label wlOptionEnclosed = new Label((Composite)this.shell, 131072);
        wlOptionEnclosed.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.OptionEnclosed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOptionEnclosed);
        FormData fdlOptionEnclosed = new FormData();
        fdlOptionEnclosed.left = new FormAttachment(0, 0);
        fdlOptionEnclosed.top = new FormAttachment((Control)this.wEnclosed, margin);
        fdlOptionEnclosed.right = new FormAttachment(middle, -margin);
        wlOptionEnclosed.setLayoutData((Object)fdlOptionEnclosed);
        this.wOptionEnclosed = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wOptionEnclosed);
        this.wOptionEnclosed.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.OptionEnclosed.Tooltip", (String[])new String[0]));
        FormData fdOptionEnclosed = new FormData();
        fdOptionEnclosed.left = new FormAttachment(middle, 0);
        fdOptionEnclosed.top = new FormAttachment((Control)wlOptionEnclosed, 0, 0x1000000);
        fdOptionEnclosed.right = new FormAttachment(100, 0);
        this.wOptionEnclosed.setLayoutData((Object)fdOptionEnclosed);
        Label wlLineTerminated = new Label((Composite)this.shell, 131072);
        wlLineTerminated.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.LineTerminated.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLineTerminated);
        FormData fdlLineTerminated = new FormData();
        fdlLineTerminated.left = new FormAttachment(0, 0);
        fdlLineTerminated.right = new FormAttachment(middle, -margin);
        fdlLineTerminated.top = new FormAttachment((Control)wlOptionEnclosed, 2 * margin);
        wlLineTerminated.setLayoutData((Object)fdlLineTerminated);
        this.wLineTerminated = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLineTerminated);
        FormData fdLineterminated = new FormData();
        fdLineterminated.left = new FormAttachment(middle, 0);
        fdLineterminated.top = new FormAttachment((Control)wlLineTerminated, 0, 0x1000000);
        fdLineterminated.right = new FormAttachment(100, 0);
        this.wLineTerminated.setLayoutData((Object)fdLineterminated);
        Label wlListColumn = new Label((Composite)this.shell, 131072);
        wlListColumn.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.ListColumn.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlListColumn);
        FormData fdlListColumn = new FormData();
        fdlListColumn.left = new FormAttachment(0, 0);
        fdlListColumn.right = new FormAttachment(middle, -margin);
        fdlListColumn.top = new FormAttachment((Control)this.wLineTerminated, margin);
        wlListColumn.setLayoutData((Object)fdlListColumn);
        Button wbListColumns = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbListColumns);
        wbListColumns.setText(BaseMessages.getString(PKG, (String)"System.Button.Edit", (String[])new String[0]));
        FormData fdbListColumns = new FormData();
        fdbListColumns.right = new FormAttachment(100, 0);
        fdbListColumns.top = new FormAttachment((Control)wlListColumn, 0, 0x1000000);
        wbListColumns.setLayoutData((Object)fdbListColumns);
        wbListColumns.addListener(13, e -> this.getListColumns());
        this.wListColumn = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wListColumn);
        this.wListColumn.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.ListColumn.Tooltip", (String[])new String[0]));
        FormData fdListColumn = new FormData();
        fdListColumn.left = new FormAttachment(middle, 0);
        fdListColumn.top = new FormAttachment((Control)wlListColumn, 0, 0x1000000);
        fdListColumn.right = new FormAttachment((Control)wbListColumns, -margin);
        this.wListColumn.setLayoutData((Object)fdListColumn);
        Label wlLimitLines = new Label((Composite)this.shell, 131072);
        wlLimitLines.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.LimitLines.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimitLines);
        FormData fdlLimitLines = new FormData();
        fdlLimitLines.left = new FormAttachment(0, 0);
        fdlLimitLines.right = new FormAttachment(middle, -margin);
        fdlLimitLines.top = new FormAttachment((Control)this.wListColumn, margin);
        wlLimitLines.setLayoutData((Object)fdlLimitLines);
        this.wLimitLines = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wLimitLines);
        this.wLimitLines.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.LimitLines.Tooltip", (String[])new String[0]));
        FormData fdLimitlines = new FormData();
        fdLimitlines.left = new FormAttachment(middle, 0);
        fdLimitlines.top = new FormAttachment((Control)this.wListColumn, margin);
        fdLimitlines.right = new FormAttachment(100, 0);
        this.wLimitLines.setLayoutData((Object)fdLimitlines);
        Label wlIfFileExists = new Label((Composite)this.shell, 131072);
        wlIfFileExists.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.IfFileExists.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIfFileExists);
        FormData fdlIfFileExists = new FormData();
        fdlIfFileExists.left = new FormAttachment(0, 0);
        fdlIfFileExists.right = new FormAttachment(middle, -margin);
        fdlIfFileExists.top = new FormAttachment((Control)this.wLimitLines, margin);
        wlIfFileExists.setLayoutData((Object)fdlIfFileExists);
        this.wIfFileExists = new CCombo((Composite)this.shell, 2060);
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Create_NewFile_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Do_Nothing_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.Fail_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.select(2);
        PropsUi.setLook((Widget)this.wIfFileExists);
        FormData fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)this.wLimitLines, margin);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)this.wLimitLines, margin);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        Group wFileResult = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wFileResult);
        wFileResult.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.FileResult.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wFileResult.setLayout((Layout)groupLayout);
        Label wlAddFileToResult = new Label((Composite)wFileResult, 131072);
        wlAddFileToResult.setText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.AddFileToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddFileToResult);
        FormData fdlAddFileToResult = new FormData();
        fdlAddFileToResult.left = new FormAttachment(0, 0);
        fdlAddFileToResult.top = new FormAttachment((Control)this.wIfFileExists, margin);
        fdlAddFileToResult.right = new FormAttachment(middle, -margin);
        wlAddFileToResult.setLayoutData((Object)fdlAddFileToResult);
        this.wAddFileToResult = new Button((Composite)wFileResult, 32);
        PropsUi.setLook((Widget)this.wAddFileToResult);
        this.wAddFileToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.AddFileToResult.Tooltip", (String[])new String[0]));
        FormData fdAddFileToResult = new FormData();
        fdAddFileToResult.left = new FormAttachment(middle, 0);
        fdAddFileToResult.top = new FormAttachment((Control)wlAddFileToResult, 0, 0x1000000);
        fdAddFileToResult.right = new FormAttachment(100, 0);
        this.wAddFileToResult.setLayoutData((Object)fdAddFileToResult);
        FormData fdFileResult = new FormData();
        fdFileResult.left = new FormAttachment(0, 0);
        fdFileResult.top = new FormAttachment((Control)this.wIfFileExists, margin);
        fdFileResult.right = new FormAttachment(100, -margin);
        fdFileResult.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wFileResult.setLayoutData((Object)fdFileResult);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, n -> this.ok(), n -> this.cancel());
        return this.action;
    }

    public void dumpFile() {
        if (this.wOutDumpValue.getSelectionIndex() == 0) {
            this.wSeparator.setEnabled(true);
            this.wEnclosed.setEnabled(true);
            this.wLineTerminated.setEnabled(true);
        } else {
            this.wSeparator.setEnabled(false);
            this.wEnclosed.setEnabled(false);
            this.wLineTerminated.setEnabled(false);
        }
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        if (this.action.getSchemaName() != null) {
            this.wTableName.setText(this.action.getSchemaName());
        }
        if (this.action.getTableName() != null) {
            this.wTableName.setText(this.action.getTableName());
        }
        if (this.action.getFilename() != null) {
            this.wFilename.setText(this.action.getFilename());
        }
        if (this.action.getSeparator() != null) {
            this.wSeparator.setText(this.action.getSeparator());
        }
        if (this.action.getEnclosed() != null) {
            this.wEnclosed.setText(this.action.getEnclosed());
        }
        this.wOptionEnclosed.setSelection(this.action.isOptionEnclosed());
        if (this.action.getLineTerminated() != null) {
            this.wLineTerminated.setText(this.action.getLineTerminated());
        }
        this.wHighPriority.setSelection(this.action.isHighPriority());
        this.wOptionEnclosed.setSelection(this.action.isOptionEnclosed());
        if (this.action.getLimitLines() != null) {
            this.wLimitLines.setText(this.action.getLimitLines());
        } else {
            this.wLimitLines.setText("0");
        }
        if (this.action.getListColumn() != null) {
            this.wListColumn.setText(this.action.getListColumn());
        }
        if (this.action.outDumpValue >= 0) {
            this.wOutDumpValue.select(this.action.outDumpValue);
        } else {
            this.wOutDumpValue.select(0);
        }
        if (this.action.ifFileExists >= 0) {
            this.wIfFileExists.select(this.action.ifFileExists);
        } else {
            this.wIfFileExists.select(2);
        }
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        this.wAddFileToResult.setSelection(this.action.isAddFileToResult());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables));
        this.action.setSchemaName(this.wSchemaName.getText());
        this.action.setTableName(this.wTableName.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setSeparator(this.wSeparator.getText());
        this.action.setEnclosed(this.wEnclosed.getText());
        this.action.setOptionEnclosed(this.wOptionEnclosed.getSelection());
        this.action.setLineTerminated(this.wLineTerminated.getText());
        this.action.setLimitLines(this.wLimitLines.getText());
        this.action.setListColumn(this.wListColumn.getText());
        this.action.outDumpValue = this.wOutDumpValue.getSelectionIndex();
        this.action.setHighPriority(this.wHighPriority.getSelection());
        this.action.ifFileExists = this.wIfFileExists.getSelectionIndex();
        this.action.setAddFileToResult(this.wAddFileToResult.getSelection());
        this.action.setChanged();
        this.dispose();
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName, this.variables);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaName.getText(), this.wTableName.getText());
                if (std.open()) {
                    this.wTableName.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.ConnectionError2.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    private void getListColumns() {
        DatabaseMeta databaseMeta;
        if (!Utils.isEmpty((CharSequence)this.wTableName.getText()) && (databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText(), this.variables)) != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                IRowMeta row = database.getTableFieldsMeta(this.wSchemaName.getText(), this.wTableName.getText());
                String[] available = row.getFieldNames();
                String[] source = this.wListColumn.getText().split(",");
                for (int i = 0; i < source.length; ++i) {
                    source[i] = Const.trim((String)source[i]);
                }
                int[] idxSource = Const.indexsOfStrings((String[])source, (String[])available);
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, available, BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.SelectColumns.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.SelectColumns.Message", (String[])new String[0]));
                dialog.setMulti(true);
                dialog.setAvoidQuickSearch();
                dialog.setSelectedNrs(idxSource);
                if (dialog.open() != null) {
                    StringBuilder columns = new StringBuilder();
                    int[] idx = dialog.getSelectionIndeces();
                    for (int i = 0; i < idx.length; ++i) {
                        if (i > 0) {
                            columns.append(", ");
                        }
                        columns.append(available[idx[i]]);
                    }
                    this.wListColumn.setText(columns.toString());
                }
            }
            catch (HopDatabaseException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionMysqlBulkFile.ConnectionError2.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
            }
        }
    }
}

