/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.accessoutput;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.accessoutput.AccessOutputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AccessOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AccessOutputDialog.class;
    private final AccessOutputMeta input;
    private TextVar wFileName;
    private Button wCreateFile;
    private TextVar wTableName;
    private Button wCreateTable;
    private Button wTruncateTable;
    private Text wCommitSize;
    private Button wAddToResultFile;
    private Button wWaitFirstRowToCreateFile;

    public AccessOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (AccessOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setMinimumSize(340, 340);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.DialogTitle", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, 0);
        fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addListener(24, e -> this.input.setChanged());
        this.wTransformName.addListener(14, e -> this.ok());
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, margin);
        fdTransformName.top = new FormAttachment(0, 0);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFileName = new Label((Composite)this.shell, 131072);
        wlFileName.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFileName);
        FormData fdlFileName = new FormData();
        fdlFileName.left = new FormAttachment(0, 0);
        fdlFileName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlFileName.right = new FormAttachment(middle, 0);
        wlFileName.setLayoutData((Object)fdlFileName);
        Button wbbFileName = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbbFileName);
        wbbFileName.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbFileName.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        wbbFileName.addListener(13, e -> this.onSelectFileName());
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wTransformName, margin);
        wbbFileName.setLayoutData((Object)fdbFilename);
        this.wFileName = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wFileName.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.Filename.Tooltip", (String[])new String[0]));
        this.wFileName.addListener(24, e -> this.input.setChanged());
        this.props.setLook((Control)this.wFileName);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, margin);
        fdFilename.right = new FormAttachment((Control)wbbFileName, -margin);
        fdFilename.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wFileName.setLayoutData((Object)fdFilename);
        Label wlCreateFile = new Label((Composite)this.shell, 131072);
        wlCreateFile.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Label", (String[])new String[0]));
        wlCreateFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlCreateFile);
        FormData fdlCreateFile = new FormData();
        fdlCreateFile.left = new FormAttachment(0, 0);
        fdlCreateFile.top = new FormAttachment((Control)this.wFileName, margin);
        fdlCreateFile.right = new FormAttachment(middle, 0);
        wlCreateFile.setLayoutData((Object)fdlCreateFile);
        this.wCreateFile = new Button((Composite)this.shell, 32);
        this.wCreateFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateFile);
        FormData fdCreateFile = new FormData();
        fdCreateFile.left = new FormAttachment(middle, margin);
        fdCreateFile.top = new FormAttachment((Control)this.wFileName, margin);
        fdCreateFile.right = new FormAttachment(100, 0);
        this.wCreateFile.setLayoutData((Object)fdCreateFile);
        this.wCreateFile.addListener(13, e -> this.input.setChanged());
        Label wlWaitFirstRowToCreateFile = new Label((Composite)this.shell, 131072);
        wlWaitFirstRowToCreateFile.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.WaitFirstRowToCreateFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWaitFirstRowToCreateFile);
        FormData fdlWaitFirstRowToCreateFile = new FormData();
        fdlWaitFirstRowToCreateFile.left = new FormAttachment(0, 0);
        fdlWaitFirstRowToCreateFile.top = new FormAttachment((Control)this.wCreateFile, margin);
        fdlWaitFirstRowToCreateFile.right = new FormAttachment(middle, -margin);
        wlWaitFirstRowToCreateFile.setLayoutData((Object)fdlWaitFirstRowToCreateFile);
        this.wWaitFirstRowToCreateFile = new Button((Composite)this.shell, 32);
        this.wWaitFirstRowToCreateFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.WaitFirstRowToCreateFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWaitFirstRowToCreateFile);
        FormData fdWaitFirstRowToCreateFile = new FormData();
        fdWaitFirstRowToCreateFile.left = new FormAttachment(middle, margin);
        fdWaitFirstRowToCreateFile.top = new FormAttachment((Control)this.wCreateFile, margin);
        fdWaitFirstRowToCreateFile.right = new FormAttachment(100, 0);
        this.wWaitFirstRowToCreateFile.setLayoutData((Object)fdWaitFirstRowToCreateFile);
        this.wWaitFirstRowToCreateFile.addListener(13, e -> this.input.setChanged());
        Label wlTablename = new Label((Composite)this.shell, 131072);
        wlTablename.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.top = new FormAttachment((Control)this.wWaitFirstRowToCreateFile, margin);
        fdlTablename.right = new FormAttachment(middle, 0);
        wlTablename.setLayoutData((Object)fdlTablename);
        Button wbbTableName = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbbTableName);
        wbbTableName.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbTableName.addListener(13, e -> this.onSelectTableName());
        FormData fdbTablename = new FormData();
        fdbTablename.right = new FormAttachment(100, 0);
        fdbTablename.top = new FormAttachment((Control)this.wWaitFirstRowToCreateFile, margin);
        wbbTableName.setLayoutData((Object)fdbTablename);
        this.wTableName = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wTableName.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TargetTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTableName);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, margin);
        fdTablename.right = new FormAttachment((Control)wbbTableName, -margin);
        fdTablename.top = new FormAttachment((Control)this.wWaitFirstRowToCreateFile, margin);
        this.wTableName.setLayoutData((Object)fdTablename);
        Label wlCreateTable = new Label((Composite)this.shell, 131072);
        wlCreateTable.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Label", (String[])new String[0]));
        wlCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlCreateTable);
        FormData fdlCreateTable = new FormData();
        fdlCreateTable.left = new FormAttachment(0, 0);
        fdlCreateTable.top = new FormAttachment((Control)this.wTableName, margin);
        fdlCreateTable.right = new FormAttachment(middle, 0);
        wlCreateTable.setLayoutData((Object)fdlCreateTable);
        this.wCreateTable = new Button((Composite)this.shell, 32);
        this.wCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateTable);
        FormData fdCreateTable = new FormData();
        fdCreateTable.left = new FormAttachment(middle, margin);
        fdCreateTable.top = new FormAttachment((Control)this.wTableName, margin);
        fdCreateTable.right = new FormAttachment(100, 0);
        this.wCreateTable.setLayoutData((Object)fdCreateTable);
        this.wCreateTable.addListener(13, e -> this.input.setChanged());
        Label wlTruncateTable = new Label((Composite)this.shell, 131072);
        wlTruncateTable.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TruncateTable.Label", (String[])new String[0]));
        wlTruncateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TruncateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlTruncateTable);
        FormData fdlTruncateTable = new FormData();
        fdlTruncateTable.left = new FormAttachment(0, 0);
        fdlTruncateTable.top = new FormAttachment((Control)this.wCreateTable, margin);
        fdlTruncateTable.right = new FormAttachment(middle, 0);
        wlTruncateTable.setLayoutData((Object)fdlTruncateTable);
        this.wTruncateTable = new Button((Composite)this.shell, 32);
        this.wTruncateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TruncateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTruncateTable);
        FormData fdTruncateTable = new FormData();
        fdTruncateTable.left = new FormAttachment(middle, margin);
        fdTruncateTable.top = new FormAttachment((Control)this.wCreateTable, margin);
        fdTruncateTable.right = new FormAttachment(100, 0);
        this.wTruncateTable.setLayoutData((Object)fdTruncateTable);
        this.wTruncateTable.addListener(13, e -> this.input.setChanged());
        Label wlCommitSize = new Label((Composite)this.shell, 131072);
        wlCommitSize.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CommitSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCommitSize);
        FormData fdlCommitSize = new FormData();
        fdlCommitSize.left = new FormAttachment(0, 0);
        fdlCommitSize.top = new FormAttachment((Control)this.wTruncateTable, margin);
        fdlCommitSize.right = new FormAttachment(middle, 0);
        wlCommitSize.setLayoutData((Object)fdlCommitSize);
        this.wCommitSize = new Text((Composite)this.shell, 18436);
        this.wCommitSize.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CommitSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCommitSize);
        FormData fdCommitSize = new FormData();
        fdCommitSize.left = new FormAttachment(middle, margin);
        fdCommitSize.right = new FormAttachment(100, 0);
        fdCommitSize.top = new FormAttachment((Control)this.wTruncateTable, margin);
        this.wCommitSize.setLayoutData((Object)fdCommitSize);
        this.wCommitSize.addListener(24, e -> this.input.setChanged());
        Label wlAddToResultFile = new Label((Composite)this.shell, 131072);
        wlAddToResultFile.setText(BaseMessages.getString(PKG, (String)"AccessOutputMeta.AddToResultFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddToResultFile);
        FormData fdlAddToResultFile = new FormData();
        fdlAddToResultFile.left = new FormAttachment(0, 0);
        fdlAddToResultFile.top = new FormAttachment((Control)this.wCommitSize, 2 * margin);
        fdlAddToResultFile.right = new FormAttachment(middle, -margin);
        wlAddToResultFile.setLayoutData((Object)fdlAddToResultFile);
        this.wAddToResultFile = new Button((Composite)this.shell, 32);
        this.wAddToResultFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputMeta.AddToResultFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResultFile);
        FormData fdAddToResultFile = new FormData();
        fdAddToResultFile.left = new FormAttachment(middle, margin);
        fdAddToResultFile.top = new FormAttachment((Control)this.wCommitSize, 2 * margin);
        fdAddToResultFile.right = new FormAttachment(100, 0);
        this.wAddToResultFile.setLayoutData((Object)fdAddToResultFile);
        this.wAddToResultFile.addListener(13, e -> this.input.setChanged());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getFileName() != null) {
            this.wFileName.setText(this.input.getFileName());
        }
        if (this.input.getTableName() != null) {
            this.wTableName.setText(this.input.getTableName());
        }
        this.wCreateFile.setSelection(this.input.isCreateFile());
        this.wCreateTable.setSelection(this.input.isCreateFile());
        this.wTruncateTable.setSelection(this.input.isTruncateTable());
        if (this.input.getCommitSize() > 0) {
            this.wCommitSize.setText(Integer.toString(this.input.getCommitSize()));
        }
        this.wAddToResultFile.setSelection(this.input.isAddToResultFile());
        this.wWaitFirstRowToCreateFile.setSelection(this.input.isWaitFirstRowToCreateFile());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(AccessOutputMeta info) {
        info.setFileName(this.wFileName.getText());
        info.setTableName(this.wTableName.getText());
        info.setCreateFile(this.wCreateFile.getSelection());
        info.setCreateTable(this.wCreateTable.getSelection());
        info.setTruncateTable(this.wTruncateTable.getSelection());
        info.setCommitSize(Const.toInt((String)this.wCommitSize.getText(), (int)-1));
        info.setAddToResultFile(this.wAddToResultFile.getSelection());
        this.input.setWaitFirstRowToCreateFile(this.wWaitFirstRowToCreateFile.getSelection());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void onSelectFileName() {
        BaseDialog.presentFileDialog((boolean)false, (Shell)this.shell, (TextVar)this.wFileName, (IVariables)this.variables, (String[])new String[]{"*.mdb;*.MDB;*.accdb;*.ACCDB", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"AccessOutputDialog.FileType.AccessFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSelectTableName() {
        AccessOutputMeta meta = new AccessOutputMeta();
        this.getInfo(meta);
        Database database = null;
        try {
            String fileName = this.variables.resolve(meta.getFileName());
            FileObject fileObject = HopVfs.getFileObject((String)fileName);
            File file = FileUtils.toFile((URL)fileObject.getURL());
            if (!file.exists() || !file.isFile()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.FileDoesNotExist", (String[])new String[]{fileName}));
            }
            database = DatabaseBuilder.open((File)file);
            Set set = database.getTableNames();
            String[] tablenames = set.toArray(new String[set.size()]);
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, tablenames, BaseMessages.getString(PKG, (String)"AccessOutputDialog.Dialog.SelectATable.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessOutputDialog.Dialog.SelectATable.Message", (String[])new String[0]));
            String tablename = dialog.open();
            if (tablename != null) {
                this.wTableName.setText(tablename);
            }
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AccessOutputDialog.UnableToGetListOfTables.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessOutputDialog.UnableToGetListOfTables.Message", (String[])new String[0]), e);
        }
        finally {
            try {
                if (database != null) {
                    database.close();
                }
            }
            catch (Exception fileName) {}
        }
    }
}

