/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.util.AutoValue_CustomHttpErrors_MatcherAndError;
import org.apache.beam.sdk.extensions.gcp.util.HttpCallCustomError;
import org.apache.beam.sdk.extensions.gcp.util.HttpCallMatcher;
import org.apache.beam.sdk.extensions.gcp.util.HttpRequestWrapper;
import org.apache.beam.sdk.extensions.gcp.util.HttpResponseWrapper;

public class CustomHttpErrors {
    private List<MatcherAndError> matchersAndLogs = new ArrayList<MatcherAndError>();

    private CustomHttpErrors(List<MatcherAndError> matchersAndLogs) {
        for (MatcherAndError m : matchersAndLogs) {
            this.matchersAndLogs.add(m);
        }
    }

    public String getCustomError(HttpRequestWrapper req, HttpResponseWrapper res) {
        for (MatcherAndError m : this.matchersAndLogs) {
            if (!m.getMatcher().matchResponse(req, res)) continue;
            return m.getCustomError().customError(req, res);
        }
        return null;
    }

    public static class Builder {
        private List<MatcherAndError> matchersAndLogs = new ArrayList<MatcherAndError>();

        public CustomHttpErrors build() {
            return new CustomHttpErrors(this.matchersAndLogs);
        }

        public void addErrorForCode(int statusCode, String errorMessage) {
            HttpCallMatcher matcher = (req, resp) -> resp.getStatusCode() == statusCode;
            this.matchersAndLogs.add(MatcherAndError.create(matcher, Builder.simpleErrorMessage(errorMessage)));
        }

        public void addErrorForCodeAndUrlContains(int statusCode, String urlContains, String errorMessage) {
            HttpCallMatcher matcher = (request, response) -> response.getStatusCode() == statusCode && request.getUrl().toString().contains(urlContains);
            this.matchersAndLogs.add(MatcherAndError.create(matcher, Builder.simpleErrorMessage(errorMessage)));
        }

        private static HttpCallCustomError simpleErrorMessage(String errorMessage) {
            return (request, response) -> errorMessage;
        }
    }

    @AutoValue
    public static abstract class MatcherAndError
    implements Serializable {
        static MatcherAndError create(HttpCallMatcher matcher, HttpCallCustomError customError) {
            return new AutoValue_CustomHttpErrors_MatcherAndError(matcher, customError);
        }

        public abstract HttpCallMatcher getMatcher();

        public abstract HttpCallCustomError getCustomError();
    }
}

