/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopKeyValueFn
extends DoFn<HopRow, KV<HopRow, HopRow>> {
    private String inputRowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private String[] keyFields;
    private String[] valueFields;
    private String counterName;
    private static final Logger LOG = LoggerFactory.getLogger(HopKeyValueFn.class);
    private transient int[] keyIndexes;
    private transient int[] valueIndexes;
    private transient Counter initCounter;
    private transient Counter readCounter;
    private transient Counter errorCounter;

    public HopKeyValueFn() {
    }

    public HopKeyValueFn(String inputRowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses, String[] keyFields, String[] valueFields, String counterName) {
        this.inputRowMetaJson = inputRowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
        this.keyFields = keyFields;
        this.valueFields = valueFields;
        this.counterName = counterName;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            int i;
            this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
            this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            IRowMeta inputRowMeta = JsonRowMeta.fromJson((String)this.inputRowMetaJson);
            if (this.keyFields.length == 0) {
                throw new HopException("There are no group fields");
            }
            this.keyIndexes = new int[this.keyFields.length];
            for (i = 0; i < this.keyFields.length; ++i) {
                this.keyIndexes[i] = inputRowMeta.indexOfValue(this.keyFields[i]);
                if (this.keyIndexes[i] >= 0) continue;
                throw new HopException("Unable to find group by field '" + this.keyFields[i] + "' in input " + inputRowMeta.toString());
            }
            this.valueIndexes = new int[this.valueFields.length];
            for (i = 0; i < this.valueFields.length; ++i) {
                this.valueIndexes[i] = inputRowMeta.indexOfValue(this.valueFields[i]);
                if (this.valueIndexes[i] >= 0) continue;
                throw new HopException("Unable to find subject by field '" + this.valueFields[i] + "' in input " + inputRowMeta.toString());
            }
            Metrics.counter((String)"init", (String)this.counterName).inc();
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error setup of splitting row into key and value", (Throwable)e);
            throw new RuntimeException("Unable to setup of split row into key and value", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            HopRow inputHopRow = (HopRow)processContext.element();
            this.readCounter.inc();
            Object[] inputRow = inputHopRow.getRow();
            Object[] keyRow = new Object[this.keyIndexes.length];
            for (int i = 0; i < this.keyIndexes.length; ++i) {
                keyRow[i] = inputRow[this.keyIndexes[i]];
            }
            Object[] valueRow = new Object[this.valueIndexes.length];
            for (int i = 0; i < this.valueIndexes.length; ++i) {
                valueRow[i] = inputRow[this.valueIndexes[i]];
            }
            KV keyValue = KV.of((Object)new HopRow(keyRow), (Object)new HopRow(valueRow));
            processContext.output((Object)keyValue);
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error splitting row into key and value", (Throwable)e);
            throw new RuntimeException("Unable to split row into key and value", e);
        }
    }

    public String getInputRowMetaJson() {
        return this.inputRowMetaJson;
    }

    public void setInputRowMetaJson(String inputRowMetaJson) {
        this.inputRowMetaJson = inputRowMetaJson;
    }

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    public String[] getValueFields() {
        return this.valueFields;
    }

    public void setValueFields(String[] valueFields) {
        this.valueFields = valueFields;
    }
}

