/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public abstract class UnaryExpression
extends ComputedExpression {
    protected Expression operand;

    public UnaryExpression(Expression expression) {
        this.operand = expression;
        Container container = expression instanceof ComputedExpression ? ((ComputedExpression)expression).getParentExpression() : null;
        this.adoptChildExpression(expression);
        this.setParentExpression(container);
    }

    public Expression getBaseExpression() {
        return this.operand;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand = this.operand.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.typeCheck(staticContext, itemType);
        try {
            if (this.operand instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.optimize(optimizer, staticContext, itemType);
        try {
            if (this.operand instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, staticContext.makeEarlyEvaluationContext());
            }
        }
        catch (DynamicError dynamicError) {
            // empty catch block
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.operand = this.doPromotion(this.operand, promotionOffer);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.operand.getItemType(typeHierarchy);
    }

    public boolean equals(Object object) {
        return this.getClass().equals(object.getClass()) && this.operand.equals(((UnaryExpression)object).operand);
    }

    public int hashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.operand.hashCode();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + this.displayOperator(namePool));
        this.operand.display(n + 1, namePool, printStream);
    }

    protected abstract String displayOperator(NamePool var1);
}

