/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ProtoCoder<T extends Message>
extends CustomCoder<T> {
    public static final long serialVersionUID = -5043999806040629525L;
    final Class<T> protoMessageClass;
    final Set<Class<?>> extensionHostClasses;
    private transient ExtensionRegistry memoizedExtensionRegistry;
    transient Parser<T> memoizedParser;
    static final TypeDescriptor<Message> MESSAGE_TYPE = new TypeDescriptor<Message>(){};

    public static <T extends Message> ProtoCoder<T> of(Class<T> protoMessageClass) {
        return new ProtoCoder<T>(protoMessageClass, (Set<Class<?>>)ImmutableSet.of());
    }

    public static <T extends Message> ProtoCoder<T> of(TypeDescriptor<T> protoMessageType) {
        Class protoMessageClass = protoMessageType.getRawType();
        return ProtoCoder.of(protoMessageClass);
    }

    void validateExtensions(Iterable<Class<?>> moreExtensionHosts) {
        for (Class<?> extensionHost : moreExtensionHosts) {
            try {
                Method registerAllExtensions = extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class);
                Preconditions.checkArgument((boolean)Modifier.isStatic(registerAllExtensions.getModifiers()), (Object)"Method registerAllExtensions() must be static");
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(String.format("Unable to register extensions for %s", extensionHost.getCanonicalName()), e);
            }
        }
    }

    public ProtoCoder<T> withExtensionsFrom(Iterable<Class<?>> moreExtensionHosts) {
        this.validateExtensions(moreExtensionHosts);
        return new ProtoCoder<T>(this.protoMessageClass, (Set<Class<?>>)new ImmutableSet.Builder().addAll(this.extensionHostClasses).addAll(moreExtensionHosts).build());
    }

    public ProtoCoder<T> withExtensionsFrom(Class<?> ... moreExtensionHosts) {
        return this.withExtensionsFrom(Arrays.asList(moreExtensionHosts));
    }

    public void encode(T value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null " + this.protoMessageClass.getSimpleName());
        }
        if (context.isWholeStream) {
            value.writeTo(outStream);
        } else {
            value.writeDelimitedTo(outStream);
        }
    }

    public T decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            return (T)((Message)this.getParser().parseFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
        }
        return (T)((Message)this.getParser().parseDelimitedFrom(inStream, (ExtensionRegistryLite)this.getExtensionRegistry()));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        ProtoCoder otherCoder = (ProtoCoder)((Object)other);
        return this.protoMessageClass.equals(otherCoder.protoMessageClass) && Sets.newHashSet(this.extensionHostClasses).equals(Sets.newHashSet(otherCoder.extensionHostClasses));
    }

    public int hashCode() {
        return Objects.hash(this.protoMessageClass, this.extensionHostClasses);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        ProtobufUtil.verifyDeterministic(this);
    }

    public Class<T> getMessageType() {
        return this.protoMessageClass;
    }

    public Set<Class<?>> getExtensionHosts() {
        return this.extensionHostClasses;
    }

    public ExtensionRegistry getExtensionRegistry() {
        if (this.memoizedExtensionRegistry == null) {
            ExtensionRegistry registry = ExtensionRegistry.newInstance();
            for (Class<?> extensionHost : this.extensionHostClasses) {
                try {
                    extensionHost.getDeclaredMethod("registerAllExtensions", ExtensionRegistry.class).invoke(null, registry);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.memoizedExtensionRegistry = registry.getUnmodifiable();
        }
        return this.memoizedExtensionRegistry;
    }

    protected ProtoCoder(Class<T> protoMessageClass, Set<Class<?>> extensionHostClasses) {
        this.protoMessageClass = protoMessageClass;
        this.extensionHostClasses = extensionHostClasses;
    }

    protected Parser<T> getParser() {
        if (this.memoizedParser == null) {
            try {
                Parser tParser;
                if (DynamicMessage.class.equals(this.protoMessageClass)) {
                    throw new IllegalArgumentException("DynamicMessage is not supported by the ProtoCoder, use the DynamicProtoCoder.");
                }
                Message protoMessageInstance = (Message)this.protoMessageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
                this.memoizedParser = tParser = protoMessageInstance.getParserForType();
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.memoizedParser;
    }

    public static CoderProvider getCoderProvider() {
        return new ProtoCoderProvider();
    }

    private static class ProtoCoderProvider
    extends CoderProvider {
        private ProtoCoderProvider() {
        }

        public <T> Coder<T> coderFor(TypeDescriptor<T> typeDescriptor, List<? extends Coder<?>> componentCoders) throws CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(MESSAGE_TYPE)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s is not a subclass of %s", ProtoCoder.class.getSimpleName(), typeDescriptor, Message.class.getName()));
            }
            TypeDescriptor<T> messageType = typeDescriptor;
            try {
                ProtoCoder<T> coder = ProtoCoder.of(messageType);
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }
}

