/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.taskexecutor.SampleableTask;
import org.apache.flink.runtime.util.JvmUtils;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.util.Preconditions;

class ThreadInfoSampleService
implements Closeable {
    private final ScheduledExecutorService scheduledExecutor;

    ThreadInfoSampleService(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutor, (String)"scheduledExecutor must not be null");
    }

    public CompletableFuture<List<ThreadInfoSample>> requestThreadInfoSamples(SampleableTask task, ThreadInfoSamplesRequest requestParams) {
        Preconditions.checkNotNull((Object)task, (String)"task must not be null");
        Preconditions.checkNotNull((Object)requestParams, (String)"requestParams must not be null");
        CompletableFuture<List<ThreadInfoSample>> resultFuture = new CompletableFuture<List<ThreadInfoSample>>();
        this.scheduledExecutor.execute(() -> this.requestThreadInfoSamples(task, requestParams.getNumSamples(), requestParams.getDelayBetweenSamples(), requestParams.getMaxStackTraceDepth(), new ArrayList<ThreadInfoSample>(requestParams.getNumSamples()), resultFuture));
        return resultFuture;
    }

    private void requestThreadInfoSamples(SampleableTask task, int numSamples, Duration delayBetweenSamples, int maxStackTraceDepth, List<ThreadInfoSample> currentTraces, CompletableFuture<List<ThreadInfoSample>> resultFuture) {
        long threadId = task.getExecutingThread().getId();
        Optional<ThreadInfoSample> threadInfoSample = JvmUtils.createThreadInfoSample(threadId, maxStackTraceDepth);
        if (threadInfoSample.isPresent()) {
            currentTraces.add(threadInfoSample.get());
        } else if (!currentTraces.isEmpty()) {
            resultFuture.complete(currentTraces);
        } else {
            resultFuture.completeExceptionally(new IllegalStateException(String.format("Cannot sample task %s. The task is not running.", task.getExecutionId())));
        }
        if (numSamples > 1) {
            this.scheduledExecutor.schedule(() -> this.requestThreadInfoSamples(task, numSamples - 1, delayBetweenSamples, maxStackTraceDepth, currentTraces, resultFuture), delayBetweenSamples.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            resultFuture.complete(currentTraces);
        }
    }

    @Override
    public void close() throws IOException {
        this.scheduledExecutor.shutdownNow();
    }
}

