/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.BoundedData;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

final class FileChannelBoundedData
implements BoundedData {
    private final Path filePath;
    private final FileChannel fileChannel;
    private final ByteBuffer[] headerAndBufferArray;
    private long size;
    private final int memorySegmentSize;

    FileChannelBoundedData(Path filePath, FileChannel fileChannel, int memorySegmentSize) {
        this.filePath = (Path)Preconditions.checkNotNull((Object)filePath);
        this.fileChannel = (FileChannel)Preconditions.checkNotNull((Object)fileChannel);
        this.memorySegmentSize = memorySegmentSize;
        this.headerAndBufferArray = BufferReaderWriterUtil.allocatedWriteBufferArray();
    }

    @Override
    public void writeBuffer(Buffer buffer) throws IOException {
        this.size += BufferReaderWriterUtil.writeToByteChannel(this.fileChannel, buffer, this.headerAndBufferArray);
    }

    @Override
    public void finishWrite() throws IOException {
        this.fileChannel.close();
    }

    @Override
    public BoundedData.Reader createReader(ResultSubpartitionView subpartitionView) throws IOException {
        Preconditions.checkState((!this.fileChannel.isOpen() ? 1 : 0) != 0);
        FileChannel fc = FileChannel.open(this.filePath, StandardOpenOption.READ);
        return new FileBufferReader(fc, this.memorySegmentSize, subpartitionView);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((AutoCloseable)this.fileChannel);
        Files.delete(this.filePath);
    }

    public static FileChannelBoundedData create(Path filePath, int memorySegmentSize) throws IOException {
        FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        return new FileChannelBoundedData(filePath, fileChannel, memorySegmentSize);
    }

    static final class FileBufferReader
    implements BoundedData.Reader,
    BufferRecycler {
        private static final int NUM_BUFFERS = 2;
        private final FileChannel fileChannel;
        private final ByteBuffer headerBuffer;
        private final ArrayDeque<MemorySegment> buffers;
        private final ResultSubpartitionView subpartitionView;
        private boolean isFinished;

        FileBufferReader(FileChannel fileChannel, int bufferSize, ResultSubpartitionView subpartitionView) {
            this.fileChannel = (FileChannel)Preconditions.checkNotNull((Object)fileChannel);
            this.headerBuffer = BufferReaderWriterUtil.allocatedHeaderBuffer();
            this.buffers = new ArrayDeque(2);
            for (int i = 0; i < 2; ++i) {
                this.buffers.addLast(MemorySegmentFactory.allocateUnpooledOffHeapMemory((int)bufferSize, null));
            }
            this.subpartitionView = (ResultSubpartitionView)Preconditions.checkNotNull((Object)subpartitionView);
        }

        @Override
        @Nullable
        public Buffer nextBuffer() throws IOException {
            MemorySegment memory = this.buffers.pollFirst();
            if (memory == null) {
                return null;
            }
            Buffer next = BufferReaderWriterUtil.readFromByteChannel(this.fileChannel, this.headerBuffer, memory, this);
            if (next == null) {
                this.isFinished = true;
                this.recycle(memory);
            }
            return next;
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
        }

        @Override
        public void recycle(MemorySegment memorySegment) {
            this.buffers.addLast(memorySegment);
            if (!this.isFinished) {
                this.subpartitionView.notifyDataAvailable();
            }
        }
    }
}

