/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.protocol.Encodable;

public interface Message
extends Encodable {
    public Type type();

    public ManagedBuffer body();

    public boolean isBodyInFrame();

    public static final class Type
    extends Enum<Type>
    implements Encodable {
        public static final /* enum */ Type ChunkFetchRequest = new Type(0);
        public static final /* enum */ Type ChunkFetchSuccess = new Type(1);
        public static final /* enum */ Type ChunkFetchFailure = new Type(2);
        public static final /* enum */ Type RpcRequest = new Type(3);
        public static final /* enum */ Type RpcResponse = new Type(4);
        public static final /* enum */ Type RpcFailure = new Type(5);
        public static final /* enum */ Type StreamRequest = new Type(6);
        public static final /* enum */ Type StreamResponse = new Type(7);
        public static final /* enum */ Type StreamFailure = new Type(8);
        public static final /* enum */ Type OneWayMessage = new Type(9);
        public static final /* enum */ Type UploadStream = new Type(10);
        public static final /* enum */ Type MergedBlockMetaRequest = new Type(11);
        public static final /* enum */ Type MergedBlockMetaSuccess = new Type(12);
        public static final /* enum */ Type User = new Type(-1);
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id) {
            assert (id < 128) : "Cannot have more than 128 message types";
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }

        @Override
        public int encodedLength() {
            return 1;
        }

        @Override
        public void encode(ByteBuf buf) {
            buf.writeByte((int)this.id);
        }

        public static Type decode(ByteBuf buf) {
            byte id = buf.readByte();
            switch (id) {
                case 0: {
                    return ChunkFetchRequest;
                }
                case 1: {
                    return ChunkFetchSuccess;
                }
                case 2: {
                    return ChunkFetchFailure;
                }
                case 3: {
                    return RpcRequest;
                }
                case 4: {
                    return RpcResponse;
                }
                case 5: {
                    return RpcFailure;
                }
                case 6: {
                    return StreamRequest;
                }
                case 7: {
                    return StreamResponse;
                }
                case 8: {
                    return StreamFailure;
                }
                case 9: {
                    return OneWayMessage;
                }
                case 10: {
                    return UploadStream;
                }
                case 11: {
                    return MergedBlockMetaRequest;
                }
                case 12: {
                    return MergedBlockMetaSuccess;
                }
                case -1: {
                    throw new IllegalArgumentException("User type messages cannot be decoded.");
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + id);
        }

        static {
            $VALUES = new Type[]{ChunkFetchRequest, ChunkFetchSuccess, ChunkFetchFailure, RpcRequest, RpcResponse, RpcFailure, StreamRequest, StreamResponse, StreamFailure, OneWayMessage, UploadStream, MergedBlockMetaRequest, MergedBlockMetaSuccess, User};
        }
    }
}

