/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandraoutput;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.Connection;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CassandraOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CassandraOutputMeta.class;
    private final CassandraOutputMeta input;
    private CTabFolder wTabFolder;
    private MetaSelectionLine<CassandraConnection> wConnection;
    private CCombo wTable;
    private TextVar wConsistency;
    private TextVar wBatchSize;
    private TextVar wBatchInsertTimeout;
    private TextVar wSubBatchSize;
    private Button wUnloggedBatch;
    private TextVar wKeyField;
    private Button wbCreateTable;
    private TextVar wWithClause;
    private Button wTruncateTable;
    private Button wUpdateTableMetaData;
    private Button wInsertFieldsNotInTableMeta;
    private CCombo wTtlUnits;
    private TextVar wTtlValue;

    public CassandraOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String name) {
        super(parent, variables, (BaseTransformMeta)in, tr, name);
        this.input = (CassandraOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 0x1000008);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 0x1000008);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wTabFolder);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.transformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.right = new FormAttachment(100, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        CTabItem wConnectionTab = new CTabItem(this.wTabFolder, 2048);
        wConnectionTab.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Tab.Connection", (String[])new String[0]));
        Composite wConnectionComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wConnectionComp);
        FormLayout connectionLayout = new FormLayout();
        connectionLayout.marginWidth = 3;
        connectionLayout.marginHeight = 3;
        wConnectionComp.setLayout((Layout)connectionLayout);
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, CassandraConnection.class, wConnectionComp, 0, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Connection.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Connection.Tooltip", (String[])new String[0]));
        this.props.setLook(this.wConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error listing Cassandra connection metadata objects", e2);
        }
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wConnectionComp.setLayoutData((Object)fd);
        wConnectionComp.layout();
        wConnectionTab.setControl((Control)wConnectionComp);
        CTabItem wWriteTab = new CTabItem(this.wTabFolder, 0);
        wWriteTab.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Tab.Write", (String[])new String[0]));
        Composite wWriteComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wWriteComp);
        FormLayout writeLayout = new FormLayout();
        writeLayout.marginWidth = 3;
        writeLayout.marginHeight = 3;
        wWriteComp.setLayout((Layout)writeLayout);
        Label wlTable = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlTable);
        wlTable.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Table.Label", (String[])new String[0]));
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.top = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbGetTables = new Button(wWriteComp, 0x1000008);
        this.props.setLook((Control)wbGetTables);
        wbGetTables.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.GetTable.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wlTable, 0, 0x1000000);
        wbGetTables.setLayoutData((Object)fdbTable);
        wbGetTables.addListener(13, e -> this.setupTablesCombo());
        this.wTable = new CCombo(wWriteComp, 2048);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(e -> this.wTable.setToolTipText(this.variables.resolve(this.wTable.getText())));
        FormData fdTable = new FormData();
        fdTable.right = new FormAttachment((Control)wbGetTables, -margin);
        fdTable.top = new FormAttachment((Control)wlTable, 0, 0x1000000);
        fdTable.left = new FormAttachment(middle, 0);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlConsistency = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlConsistency);
        wlConsistency.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Consistency.Label", (String[])new String[0]));
        wlConsistency.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Consistency.Label.TipText", (String[])new String[0]));
        FormData fdlConsistency = new FormData();
        fdlConsistency.left = new FormAttachment(0, 0);
        fdlConsistency.top = new FormAttachment((Control)this.wTable, margin);
        fdlConsistency.right = new FormAttachment(middle, -margin);
        wlConsistency.setLayoutData((Object)fdlConsistency);
        this.wConsistency = new TextVar(this.variables, wWriteComp, 18436);
        this.props.setLook((Control)this.wConsistency);
        this.wConsistency.addModifyListener(e -> this.wConsistency.setToolTipText(this.variables.resolve(this.wConsistency.getText())));
        FormData fdConsistency = new FormData();
        fdConsistency.right = new FormAttachment(100, 0);
        fdConsistency.top = new FormAttachment((Control)this.wTable, margin);
        fdConsistency.left = new FormAttachment(middle, 0);
        this.wConsistency.setLayoutData((Object)fdConsistency);
        Label wlBatchSize = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlBatchSize);
        wlBatchSize.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.BatchSize.Label", (String[])new String[0]));
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wConsistency, margin);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        wlBatchSize.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.BatchSize.TipText", (String[])new String[0]));
        this.wBatchSize = new TextVar(this.variables, wWriteComp, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(e -> this.wBatchSize.setToolTipText(this.variables.resolve(this.wBatchSize.getText())));
        FormData fdBatchSize = new FormData();
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wConsistency, margin);
        fdBatchSize.left = new FormAttachment(middle, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        Label wlBatchInsertTimeout = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlBatchInsertTimeout);
        wlBatchInsertTimeout.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.BatchInsertTimeout.Label", (String[])new String[0]));
        FormData fdlBatchInsertTimeout = new FormData();
        fdlBatchInsertTimeout.left = new FormAttachment(0, 0);
        fdlBatchInsertTimeout.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdlBatchInsertTimeout.right = new FormAttachment(middle, -margin);
        wlBatchInsertTimeout.setLayoutData((Object)fdlBatchInsertTimeout);
        wlBatchInsertTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.BatchInsertTimeout.TipText", (String[])new String[0]));
        this.wBatchInsertTimeout = new TextVar(this.variables, wWriteComp, 18436);
        this.props.setLook((Control)this.wBatchInsertTimeout);
        this.wBatchInsertTimeout.addModifyListener(e -> this.wBatchInsertTimeout.setToolTipText(this.variables.resolve(this.wBatchInsertTimeout.getText())));
        FormData fdBatchInsertTimeout = new FormData();
        fdBatchInsertTimeout.right = new FormAttachment(100, 0);
        fdBatchInsertTimeout.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdBatchInsertTimeout.left = new FormAttachment(middle, 0);
        this.wBatchInsertTimeout.setLayoutData((Object)fdBatchInsertTimeout);
        Label wlSubBatchSize = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlSubBatchSize);
        wlSubBatchSize.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SubBatchSize.Label", (String[])new String[0]));
        wlSubBatchSize.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SubBatchSize.TipText", (String[])new String[0]));
        FormData fdlSubBatchSize = new FormData();
        fdlSubBatchSize.left = new FormAttachment(0, 0);
        fdlSubBatchSize.top = new FormAttachment((Control)this.wBatchInsertTimeout, margin);
        fdlSubBatchSize.right = new FormAttachment(middle, -margin);
        wlSubBatchSize.setLayoutData((Object)fdlSubBatchSize);
        this.wSubBatchSize = new TextVar(this.variables, wWriteComp, 18436);
        this.props.setLook((Control)this.wSubBatchSize);
        this.wSubBatchSize.addModifyListener(e -> this.wSubBatchSize.setToolTipText(this.variables.resolve(this.wSubBatchSize.getText())));
        FormData fdSubBatchSize = new FormData();
        fdSubBatchSize.right = new FormAttachment(100, 0);
        fdSubBatchSize.top = new FormAttachment((Control)this.wBatchInsertTimeout, margin);
        fdSubBatchSize.left = new FormAttachment(middle, 0);
        this.wSubBatchSize.setLayoutData((Object)fdSubBatchSize);
        Label wlUnloggedBatch = new Label(wWriteComp, 131072);
        wlUnloggedBatch.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.UnloggedBatch.Label", (String[])new String[0]));
        wlUnloggedBatch.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.UnloggedBatch.TipText", (String[])new String[0]));
        this.props.setLook((Control)wlUnloggedBatch);
        FormData fdlUnloggedBatch = new FormData();
        fdlUnloggedBatch.left = new FormAttachment(0, 0);
        fdlUnloggedBatch.top = new FormAttachment((Control)this.wSubBatchSize, margin);
        fdlUnloggedBatch.right = new FormAttachment(middle, -margin);
        wlUnloggedBatch.setLayoutData((Object)fdlUnloggedBatch);
        this.wUnloggedBatch = new Button(wWriteComp, 32);
        this.props.setLook((Control)this.wUnloggedBatch);
        FormData fdUnloggedBatch = new FormData();
        fdUnloggedBatch.right = new FormAttachment(100, 0);
        fdUnloggedBatch.top = new FormAttachment((Control)wlUnloggedBatch, 0, 0x1000000);
        fdUnloggedBatch.left = new FormAttachment(middle, 0);
        this.wUnloggedBatch.setLayoutData((Object)fdUnloggedBatch);
        Label wlTtl = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlTtl);
        wlTtl.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.TTL.Label", (String[])new String[0]));
        FormData fdlTtl = new FormData();
        fdlTtl.left = new FormAttachment(0, 0);
        fdlTtl.top = new FormAttachment((Control)wlUnloggedBatch, 2 * margin);
        fdlTtl.right = new FormAttachment(middle, -margin);
        wlTtl.setLayoutData((Object)fdlTtl);
        this.wTtlUnits = new CCombo(wWriteComp, 2048);
        this.wTtlUnits.setEditable(false);
        this.props.setLook((Control)this.wTtlUnits);
        FormData fdTtl = new FormData();
        fdTtl.right = new FormAttachment(100, 0);
        fdTtl.top = new FormAttachment((Control)wlTtl, 0, 0x1000000);
        this.wTtlUnits.setLayoutData((Object)fdTtl);
        for (CassandraOutputMeta.TtlUnits u : CassandraOutputMeta.TtlUnits.values()) {
            this.wTtlUnits.add(u.toString());
        }
        this.wTtlUnits.select(0);
        this.wTtlUnits.addListener(13, e -> {
            if (this.wTtlUnits.getSelectionIndex() == 0) {
                this.wTtlValue.setEnabled(false);
                this.wTtlValue.setText("");
            } else {
                this.wTtlValue.setEnabled(true);
            }
        });
        this.wTtlValue = new TextVar(this.variables, wWriteComp, 18436);
        this.props.setLook((Control)this.wTtlValue);
        FormData fdTtlValue = new FormData();
        fdTtlValue.right = new FormAttachment((Control)this.wTtlUnits, -2 * margin);
        fdTtlValue.top = new FormAttachment((Control)wlTtl, 0, 0x1000000);
        fdTtlValue.left = new FormAttachment(middle, 0);
        this.wTtlValue.setLayoutData((Object)fdTtlValue);
        this.wTtlValue.setEnabled(false);
        this.wTtlValue.addModifyListener(e -> this.wTtlValue.setToolTipText(this.variables.resolve(this.wTtlValue.getText())));
        Label wlKeyField = new Label(wWriteComp, 131072);
        this.props.setLook((Control)wlKeyField);
        wlKeyField.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.KeyField.Label", (String[])new String[0]));
        FormData fdlKeyField = new FormData();
        fdlKeyField.left = new FormAttachment(0, 0);
        fdlKeyField.top = new FormAttachment((Control)this.wTtlValue, 2 * margin);
        fdlKeyField.right = new FormAttachment(middle, -margin);
        wlKeyField.setLayoutData((Object)fdlKeyField);
        Button wbGetFields = new Button(wWriteComp, 0x1000008);
        this.props.setLook((Control)wbGetFields);
        wbGetFields.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.GetFields.Button", (String[])new String[0]));
        FormData fdbGetFields = new FormData();
        fdbGetFields.right = new FormAttachment(100, 0);
        fdbGetFields.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        wbGetFields.setLayoutData((Object)fdbGetFields);
        wbGetFields.addListener(13, e -> this.showEnterSelectionDialog());
        this.wKeyField = new TextVar(this.variables, wWriteComp, 18436);
        this.wKeyField.addModifyListener(e -> this.wKeyField.setToolTipText(this.variables.resolve(this.wKeyField.getText())));
        FormData fdKeyField = new FormData();
        fdKeyField.right = new FormAttachment((Control)wbGetFields, -margin);
        fdKeyField.top = new FormAttachment((Control)wlKeyField, 0, 0x1000000);
        fdKeyField.left = new FormAttachment(middle, 0);
        this.wKeyField.setLayoutData((Object)fdKeyField);
        FormData fdWriteComp = new FormData();
        fdWriteComp.left = new FormAttachment(0, 0);
        fdWriteComp.top = new FormAttachment(0, 0);
        fdWriteComp.right = new FormAttachment(100, 0);
        fdWriteComp.bottom = new FormAttachment(100, 0);
        wWriteComp.setLayoutData((Object)fdWriteComp);
        wWriteTab.setControl((Control)wWriteComp);
        Button wbShowSchema = new Button(wWriteComp, 0x1000008);
        wbShowSchema.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Schema.Button", (String[])new String[0]));
        this.props.setLook((Control)wbShowSchema);
        FormData fdbShowSchema = new FormData();
        fdbShowSchema.right = new FormAttachment(100, 0);
        fdbShowSchema.bottom = new FormAttachment(100, -margin * 2);
        wbShowSchema.setLayoutData((Object)fdbShowSchema);
        wbShowSchema.addListener(13, e -> this.popupSchemaInfo());
        CTabItem wSchemaTab = new CTabItem(this.wTabFolder, 0);
        wSchemaTab.setText(BaseMessages.getString(PKG, (String)"CassandraOutputData.Tab.Schema", (String[])new String[0]));
        Composite wSchemaComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSchemaComp);
        FormLayout schemaLayout = new FormLayout();
        schemaLayout.marginWidth = 3;
        schemaLayout.marginHeight = 3;
        wSchemaComp.setLayout((Layout)schemaLayout);
        Label wlCreateTable = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)wlCreateTable);
        wlCreateTable.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.CreateTable.Label", (String[])new String[0]));
        wlCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.CreateTable.TipText", (String[])new String[0]));
        FormData fdlCreateTable = new FormData();
        fdlCreateTable.left = new FormAttachment(0, 0);
        fdlCreateTable.top = new FormAttachment(0, margin);
        fdlCreateTable.right = new FormAttachment(middle, -margin);
        wlCreateTable.setLayoutData((Object)fdlCreateTable);
        this.wbCreateTable = new Button(wSchemaComp, 32);
        this.wbCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.CreateTable.TipText", (String[])new String[0]));
        this.props.setLook((Control)this.wbCreateTable);
        FormData fdCreateTable = new FormData();
        fdCreateTable.right = new FormAttachment(100, 0);
        fdCreateTable.top = new FormAttachment((Control)wlCreateTable, 0, 0x1000000);
        fdCreateTable.left = new FormAttachment(middle, 0);
        this.wbCreateTable.setLayoutData((Object)fdCreateTable);
        Label wlWithClause = new Label(wSchemaComp, 131072);
        wlWithClause.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.CreateTableWithClause.Label", (String[])new String[0]));
        wlWithClause.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.CreateTableWithClause.TipText", (String[])new String[0]));
        this.props.setLook((Control)wlWithClause);
        FormData fdlWithClause = new FormData();
        fdlWithClause.left = new FormAttachment(0, 0);
        fdlWithClause.top = new FormAttachment((Control)wlCreateTable, 2 * margin);
        fdlWithClause.right = new FormAttachment(middle, -margin);
        wlWithClause.setLayoutData((Object)fdlWithClause);
        this.wWithClause = new TextVar(this.variables, wSchemaComp, 18436);
        this.props.setLook((Control)this.wWithClause);
        this.wWithClause.addModifyListener(e -> this.wWithClause.setToolTipText(this.variables.resolve(this.wWithClause.getText())));
        FormData fdWithClause = new FormData();
        fdWithClause.right = new FormAttachment(100, 0);
        fdWithClause.top = new FormAttachment((Control)wlWithClause, 0, 0x1000000);
        fdWithClause.left = new FormAttachment(middle, 0);
        this.wWithClause.setLayoutData((Object)fdWithClause);
        Label wlTruncateTable = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)wlTruncateTable);
        wlTruncateTable.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.TruncateTable.Label", (String[])new String[0]));
        wlTruncateTable.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.TruncateTable.TipText", (String[])new String[0]));
        FormData fdlTruncateTable = new FormData();
        fdlTruncateTable.left = new FormAttachment(0, 0);
        fdlTruncateTable.top = new FormAttachment((Control)this.wWithClause, margin);
        fdlTruncateTable.right = new FormAttachment(middle, -margin);
        wlTruncateTable.setLayoutData((Object)fdlTruncateTable);
        this.wTruncateTable = new Button(wSchemaComp, 32);
        this.wTruncateTable.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.TruncateTable.TipText", (String[])new String[0]));
        this.props.setLook((Control)this.wTruncateTable);
        FormData fdTruncateTable = new FormData();
        fdTruncateTable.right = new FormAttachment(100, 0);
        fdTruncateTable.top = new FormAttachment((Control)wlTruncateTable, 0, 0x1000000);
        fdTruncateTable.left = new FormAttachment(middle, 0);
        this.wTruncateTable.setLayoutData((Object)fdTruncateTable);
        Label wlUpdateTableMetaData = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)wlUpdateTableMetaData);
        wlUpdateTableMetaData.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.UpdateTableMetaData.Label", (String[])new String[0]));
        wlUpdateTableMetaData.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.UpdateTableMetaData.TipText", (String[])new String[0]));
        FormData fdlUpdateTableMetaData = new FormData();
        fdlUpdateTableMetaData.left = new FormAttachment(0, 0);
        fdlUpdateTableMetaData.top = new FormAttachment((Control)wlTruncateTable, 2 * margin);
        fdlUpdateTableMetaData.right = new FormAttachment(middle, -margin);
        wlUpdateTableMetaData.setLayoutData((Object)fdlUpdateTableMetaData);
        this.wUpdateTableMetaData = new Button(wSchemaComp, 32);
        this.wUpdateTableMetaData.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.UpdateTableMetaData.TipText", (String[])new String[0]));
        this.props.setLook((Control)this.wUpdateTableMetaData);
        FormData fdUpdateTableMetaData = new FormData();
        fdUpdateTableMetaData.right = new FormAttachment(100, 0);
        fdUpdateTableMetaData.top = new FormAttachment((Control)wlUpdateTableMetaData, 0, 0x1000000);
        fdUpdateTableMetaData.left = new FormAttachment(middle, 0);
        this.wUpdateTableMetaData.setLayoutData((Object)fdUpdateTableMetaData);
        Label wlInsertFieldsNotInTableMeta = new Label(wSchemaComp, 131072);
        this.props.setLook((Control)wlInsertFieldsNotInTableMeta);
        wlInsertFieldsNotInTableMeta.setText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.InsertFieldsNotInTableMetaData.Label", (String[])new String[0]));
        wlInsertFieldsNotInTableMeta.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.InsertFieldsNotInTableMetaData.TipText", (String[])new String[0]));
        FormData fdlInsertFieldsNotInTableMeta = new FormData();
        fdlInsertFieldsNotInTableMeta.left = new FormAttachment(0, 0);
        fdlInsertFieldsNotInTableMeta.top = new FormAttachment((Control)wlUpdateTableMetaData, 2 * margin);
        fdlInsertFieldsNotInTableMeta.right = new FormAttachment(middle, -margin);
        wlInsertFieldsNotInTableMeta.setLayoutData((Object)fdlInsertFieldsNotInTableMeta);
        this.wInsertFieldsNotInTableMeta = new Button(wSchemaComp, 32);
        this.wInsertFieldsNotInTableMeta.setToolTipText(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.InsertFieldsNotInTableMetaData.TipText", (String[])new String[0]));
        this.props.setLook((Control)this.wInsertFieldsNotInTableMeta);
        FormData fdInsertFieldsNotInTableMeta = new FormData();
        fdInsertFieldsNotInTableMeta.right = new FormAttachment(100, 0);
        fdInsertFieldsNotInTableMeta.top = new FormAttachment((Control)wlInsertFieldsNotInTableMeta, 0, 0x1000000);
        fdInsertFieldsNotInTableMeta.left = new FormAttachment(middle, 0);
        this.wInsertFieldsNotInTableMeta.setLayoutData((Object)fdInsertFieldsNotInTableMeta);
        FormData fdSchemaComp = new FormData();
        fdSchemaComp.left = new FormAttachment(0, 0);
        fdSchemaComp.top = new FormAttachment(0, 0);
        fdSchemaComp.right = new FormAttachment(100, 0);
        fdSchemaComp.bottom = new FormAttachment(100, 0);
        wSchemaComp.setLayoutData((Object)fdSchemaComp);
        wSchemaComp.layout();
        wSchemaTab.setControl((Control)wSchemaComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wlTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTablesCombo() {
        Connection conn = null;
        Keyspace kSpace = null;
        try {
            String connectionName = this.variables.resolve(this.wConnection.getText());
            if (StringUtils.isEmpty((String)connectionName)) {
                return;
            }
            CassandraConnection cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(connectionName);
            try {
                conn = cassandraConnection.createConnection(this.variables, false);
                kSpace = cassandraConnection.lookupKeyspace(conn, this.variables);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                if (conn != null) {
                    try {
                        conn.closeConnection();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            List<String> tables = kSpace.getTableNamesCQL3();
            this.wTable.removeAll();
            for (String famName : tables) {
                this.wTable.add(famName);
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ex.getMessage(), ex);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + ex.getMessage(), ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void showEnterSelectionDialog() {
        TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
        if (transformMeta != null) {
            try {
                IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                if (row.size() == 0) {
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields", (String[])new String[0]), (int)33);
                    return;
                }
                String[] choices = new String[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    IValueMeta vm = row.getValueMeta(i);
                    choices[i] = vm.getName();
                }
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, choices, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SelectKeyFieldsDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.SelectKeyFieldsDialog.Message", (String[])new String[0]));
                dialog.setMulti(true);
                if (!Utils.isEmpty((CharSequence)this.wKeyField.getText())) {
                    String current = this.wKeyField.getText();
                    String[] parts = current.split(",");
                    int[] currentSelection = new int[parts.length];
                    int count = 0;
                    String[] stringArray = parts;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String s = stringArray[i];
                        int index = row.indexOfValue(s.trim());
                        if (index < 0) continue;
                        currentSelection[count++] = index;
                    }
                    dialog.setSelectedNrs(currentSelection);
                }
                dialog.open();
                int[] selected = dialog.getSelectionIndeces();
                if (selected != null && selected.length > 0) {
                    StringBuilder newSelection = new StringBuilder();
                    boolean first = true;
                    for (int i : selected) {
                        if (first) {
                            newSelection.append(choices[i]);
                            first = false;
                            continue;
                        }
                        newSelection.append(",").append(choices[i]);
                    }
                    this.wKeyField.setText(newSelection.toString());
                }
            }
            catch (HopException ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields", (String[])new String[0]), (Exception)((Object)ex));
            }
        }
    }

    protected void setupFieldsCombo() {
        TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
        if (transformMeta != null) {
            try {
                IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                if (row.size() == 0) {
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields", (String[])new String[0]), (int)33);
                    return;
                }
            }
            catch (HopException ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputData.Message.NoIncomingFields", (String[])new String[0]), (Exception)((Object)ex));
            }
        }
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wlTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setConnectionName(this.wConnection.getText());
        this.input.setTableName(this.wTable.getText());
        this.input.setConsistency(this.wConsistency.getText());
        this.input.setBatchSize(this.wBatchSize.getText());
        this.input.setCqlBatchInsertTimeout(this.wBatchInsertTimeout.getText());
        this.input.setCqlSubBatchSize(this.wSubBatchSize.getText());
        this.input.setKeyField(this.wKeyField.getText());
        this.input.setCreateTable(this.wbCreateTable.getSelection());
        this.input.setTruncateTable(this.wTruncateTable.getSelection());
        this.input.setUpdateCassandraMeta(this.wUpdateTableMetaData.getSelection());
        this.input.setInsertFieldsNotInMeta(this.wInsertFieldsNotInTableMeta.getSelection());
        this.input.setCreateTableWithClause(this.wWithClause.getText());
        this.input.setUseUnloggedBatch(this.wUnloggedBatch.getSelection());
        this.input.setTtl(this.wTtlValue.getText());
        this.input.setTtlUnit(this.wTtlUnits.getText());
        this.input.setChanged();
        this.dispose();
    }

    protected void cancel() {
        this.transformName = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void popupSchemaInfo() {
        Connection conn = null;
        Keyspace kSpace = null;
        try {
            String connectionName = this.variables.resolve(this.wConnection.getText());
            if (StringUtils.isEmpty((String)connectionName)) {
                return;
            }
            CassandraConnection cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(connectionName);
            try {
                conn = cassandraConnection.createConnection(this.variables, false);
                kSpace = cassandraConnection.lookupKeyspace(conn, this.variables);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                if (conn != null) {
                    try {
                        conn.closeConnection();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                return;
            }
            String table = this.variables.resolve(this.wTable.getText());
            if (Utils.isEmpty((CharSequence)table)) {
                throw new Exception("No table name specified!");
            }
            if (!kSpace.tableExists(table = CassandraUtils.cql3MixedCaseQuote(table))) {
                throw new Exception("The table '" + table + "' does not seem to exist in the keyspace '" + cassandraConnection.getKeyspace());
            }
            ITableMetaData cassMeta = kSpace.getTableMetaData(table);
            String schemaDescription = cassMeta.describe();
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, "Schema info", schemaDescription, true);
            smd.open();
        }
        catch (Exception e1) {
            this.logError(BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraOutputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
        }
        finally {
            if (conn != null) {
                try {
                    conn.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        this.wTable.setText(Const.NVL((String)this.input.getTableName(), (String)""));
        this.wConsistency.setText(Const.NVL((String)this.input.getConsistency(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wBatchInsertTimeout.setText(Const.NVL((String)this.input.getCqlBatchInsertTimeout(), (String)""));
        this.wSubBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wKeyField.setText(Const.NVL((String)this.input.getKeyField(), (String)""));
        this.wWithClause.setText(Const.NVL((String)this.input.getCreateTableWithClause(), (String)""));
        this.wbCreateTable.setSelection(this.input.isCreateTable());
        this.wTruncateTable.setSelection(this.input.isTruncateTable());
        this.wUpdateTableMetaData.setSelection(this.input.isUpdateCassandraMeta());
        this.wInsertFieldsNotInTableMeta.setSelection(this.input.isInsertFieldsNotInMeta());
        this.wUnloggedBatch.setSelection(this.input.isUseUnloggedBatch());
        if (!Utils.isEmpty((CharSequence)this.input.getTtl())) {
            this.wTtlValue.setText(this.input.getTtl());
            this.wTtlUnits.setText(this.input.getTtlUnit());
            this.wTtlValue.setEnabled(this.wTtlUnits.getSelectionIndex() > 0);
        }
    }
}

