/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.AutoValue_ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@AutoValue
@Internal
public abstract class ValueInSingleWindow<T> {
    public T getValue() {
        return this.getNullableValue();
    }

    protected abstract @Nullable T getNullableValue();

    public abstract Instant getTimestamp();

    public abstract BoundedWindow getWindow();

    public abstract PaneInfo getPane();

    public static <T> ValueInSingleWindow<T> of(T value, Instant timestamp, BoundedWindow window, PaneInfo paneInfo) {
        return new AutoValue_ValueInSingleWindow<T>(value, timestamp, window, paneInfo);
    }

    public static class Coder<T>
    extends StructuredCoder<ValueInSingleWindow<T>> {
        private final org.apache.beam.sdk.coders.Coder<T> valueCoder;
        private final org.apache.beam.sdk.coders.Coder<BoundedWindow> windowCoder;

        public static <T> Coder<T> of(org.apache.beam.sdk.coders.Coder<T> valueCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            return new Coder<T>(valueCoder, windowCoder);
        }

        Coder(org.apache.beam.sdk.coders.Coder<T> valueCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            this.valueCoder = valueCoder;
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(ValueInSingleWindow<T> windowedElem, OutputStream outStream) throws IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(ValueInSingleWindow<T> windowedElem, OutputStream outStream, Coder.Context context) throws IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowCoder.encode(windowedElem.getWindow(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public ValueInSingleWindow<T> decode(InputStream inStream) throws IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public ValueInSingleWindow<T> decode(InputStream inStream, Coder.Context context) throws IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            T value = this.valueCoder.decode(inStream, context);
            return new AutoValue_ValueInSingleWindow<T>(value, timestamp, window, pane);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.valueCoder);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getComponents() {
            return ImmutableList.of(this.valueCoder, this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
        }
    }
}

