/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Mean {
    private Mean() {
    }

    public static <NumT extends Number> Combine.Globally<NumT, Double> globally() {
        return Combine.globally(Mean.of());
    }

    public static <K, NumT extends Number> Combine.PerKey<K, NumT, Double> perKey() {
        return Combine.perKey(Mean.of());
    }

    public static <NumT extends Number> Combine.AccumulatingCombineFn<NumT, CountSum<NumT>, Double> of() {
        return new MeanFn();
    }

    static class CountSumCoder<NumT extends Number>
    extends AtomicCoder<CountSum<NumT>> {
        private static final Coder<Long> LONG_CODER = BigEndianLongCoder.of();
        private static final Coder<Double> DOUBLE_CODER = DoubleCoder.of();

        CountSumCoder() {
        }

        @Override
        public void encode(CountSum<NumT> value, OutputStream outStream) throws CoderException, IOException {
            LONG_CODER.encode(value.count, outStream);
            DOUBLE_CODER.encode(value.sum, outStream);
        }

        @Override
        public CountSum<NumT> decode(InputStream inStream) throws CoderException, IOException {
            return new CountSum(LONG_CODER.decode(inStream), DOUBLE_CODER.decode(inStream));
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            LONG_CODER.verifyDeterministic();
            DOUBLE_CODER.verifyDeterministic();
        }
    }

    static class CountSum<NumT extends Number>
    implements Combine.AccumulatingCombineFn.Accumulator<NumT, CountSum<NumT>, Double> {
        long count = 0L;
        double sum = 0.0;

        public CountSum() {
            this(0L, 0.0);
        }

        public CountSum(long count, double sum) {
            this.count = count;
            this.sum = sum;
        }

        @Override
        public void addInput(NumT element) {
            ++this.count;
            this.sum += ((Number)element).doubleValue();
        }

        @Override
        public void mergeAccumulator(CountSum<NumT> accumulator) {
            this.count += accumulator.count;
            this.sum += accumulator.sum;
        }

        @Override
        public Double extractOutput() {
            return this.count == 0L ? Double.NaN : this.sum / (double)this.count;
        }

        @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CountSum)) {
                return false;
            }
            CountSum otherCountSum = (CountSum)other;
            return this.count == otherCountSum.count && this.sum == otherCountSum.sum;
        }

        public int hashCode() {
            return Objects.hash(this.count, this.sum);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("sum", this.sum).toString();
        }
    }

    private static class MeanFn<NumT extends Number>
    extends Combine.AccumulatingCombineFn<NumT, CountSum<NumT>, Double> {
        private MeanFn() {
        }

        @Override
        public CountSum<NumT> createAccumulator() {
            return new CountSum();
        }

        @Override
        public Coder<CountSum<NumT>> getAccumulatorCoder(CoderRegistry registry, Coder<NumT> inputCoder) {
            return new CountSumCoder();
        }
    }
}

