/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDefinition;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatcher;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ConvertHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertHelpers.class);

    public static <T> ConvertedSchemaInformation<T> getConvertedSchemaInformation(Schema inputSchema, TypeDescriptor<T> outputType, SchemaRegistry schemaRegistry) {
        ConvertedSchemaInformation<Row> convertedSchema = null;
        if (outputType.equals(TypeDescriptor.of(Row.class))) {
            convertedSchema = new ConvertedSchemaInformation<Row>(SchemaCoder.of(inputSchema), null);
        } else if (outputType.equals(TypeDescriptor.of(GenericRecord.class))) {
            convertedSchema = new ConvertedSchemaInformation<GenericRecord>(AvroUtils.schemaCoder(AvroUtils.toAvroSchema(inputSchema)), null);
        } else {
            Schema outputSchema = null;
            SchemaCoder<T> outputSchemaCoder = null;
            try {
                outputSchema = schemaRegistry.getSchema(outputType);
                outputSchemaCoder = SchemaCoder.of(outputSchema, outputType, schemaRegistry.getToRowFunction(outputType), schemaRegistry.getFromRowFunction(outputType));
            }
            catch (NoSuchSchemaException e) {
                LOG.debug("No schema found for type " + outputType, (Throwable)e);
            }
            Schema.FieldType unboxedType = null;
            if (outputSchema == null || !outputSchema.assignableToIgnoreNullable(inputSchema)) {
                Schema checkedSchema = inputSchema;
                if (inputSchema.getFieldCount() == 1) {
                    unboxedType = inputSchema.getField(0).getType();
                    checkedSchema = unboxedType.getTypeName().isCompositeType() && !outputSchema.assignableToIgnoreNullable(unboxedType.getRowSchema()) ? unboxedType.getRowSchema() : null;
                }
                if (checkedSchema != null) {
                    throw new RuntimeException("Cannot convert between types that don't have equivalent schemas. input schema: " + checkedSchema + " output schema: " + outputSchema);
                }
            }
            convertedSchema = new ConvertedSchemaInformation<T>(outputSchemaCoder, unboxedType);
        }
        return convertedSchema;
    }

    public static <OutputT> SerializableFunction<?, OutputT> getConvertPrimitive(Schema.FieldType fieldType, TypeDescriptor<?> outputTypeDescriptor, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Schema.FieldType expectedFieldType = StaticSchemaInference.fieldFromType(outputTypeDescriptor, JavaFieldSchema.JavaFieldTypeSupplier.INSTANCE);
        if (!expectedFieldType.equals(fieldType)) {
            throw new IllegalArgumentException("Element argument type " + outputTypeDescriptor + " does not work with expected schema field type " + fieldType);
        }
        Type expectedInputType = typeConversionsFactory.createTypeConversion(false).convert(outputTypeDescriptor);
        TypeDescriptor<Object> outputType = outputTypeDescriptor;
        if (outputType.getRawType().isPrimitive()) {
            outputType = TypeDescriptor.of(Primitives.wrap(outputType.getRawType()));
        }
        TypeDescription.Generic genericType = TypeDescription.Generic.Builder.parameterizedType(SerializableFunction.class, (Type[])new Type[]{expectedInputType, outputType.getType()}).build();
        DynamicType.Builder builder = new ByteBuddy().subclass((TypeDefinition)genericType);
        try {
            return (SerializableFunction)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).method((ElementMatcher)ElementMatchers.named((String)"apply")).intercept((Implementation)new ConvertPrimitiveInstruction(outputType, typeConversionsFactory)).make().load(ReflectHelpers.findClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static class ConvertPrimitiveInstruction
    implements Implementation {
        private final TypeDescriptor<?> outputFieldType;
        private final ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        public ConvertPrimitiveInstruction(TypeDescriptor<?> outputFieldType, ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.outputFieldType = outputFieldType;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readValue = MethodVariableAccess.REFERENCE.loadFrom(1);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{this.typeConversionsFactory.createSetterConversions(readValue).convert(this.outputFieldType), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    public static class ConvertedSchemaInformation<T>
    implements Serializable {
        public final @Nullable SchemaCoder<T> outputSchemaCoder;
        public final @Nullable Schema.FieldType unboxedType;

        public ConvertedSchemaInformation(@Nullable SchemaCoder<T> outputSchemaCoder, @Nullable Schema.FieldType unboxedType) {
            assert (outputSchemaCoder != null || unboxedType != null);
            this.outputSchemaCoder = outputSchemaCoder;
            this.unboxedType = unboxedType;
        }
    }
}

