/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

public class WithKeys<T>
extends PTransform<PCollection<T>, PCollection<KV<Row, T>>> {
    private final FieldAccessDescriptor fieldAccessDescriptor;

    public static <T> WithKeys<T> of(FieldAccessDescriptor fieldAccessDescriptor) {
        return new WithKeys<T>(fieldAccessDescriptor);
    }

    private WithKeys(FieldAccessDescriptor fieldAccessDescriptor) {
        this.fieldAccessDescriptor = fieldAccessDescriptor;
    }

    @Override
    public PCollection<KV<Row, T>> expand(PCollection<T> input) {
        Schema schema = input.getSchema();
        TypeDescriptor<T> typeDescriptor = input.getTypeDescriptor();
        if (typeDescriptor == null) {
            throw new RuntimeException("Null type descriptor on input.");
        }
        SerializableFunction<T, Row> toRowFunction = input.getToRowFunction();
        SerializableFunction<Row, T> fromRowFunction = input.getFromRowFunction();
        FieldAccessDescriptor resolved = this.fieldAccessDescriptor.resolve(schema);
        final SelectHelpers.RowSelectorContainer rowSelector = new SelectHelpers.RowSelectorContainer(schema, resolved, true);
        Schema keySchema = SelectHelpers.getOutputSchema(schema, resolved);
        return ((PCollection)input.apply("selectKeys", ParDo.of(new DoFn<T, KV<Row, T>>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Row row, @DoFn.Element T element, DoFn.OutputReceiver<KV<Row, T>> o) {
                o.output(KV.of(rowSelector.select(row), element));
            }
        }))).setCoder(KvCoder.of(SchemaCoder.of(keySchema), SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction)));
    }
}

