/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.avro.AvroSchema;
import com.fasterxml.jackson.dataformat.avro.PackageVersion;
import com.fasterxml.jackson.dataformat.avro.deser.AvroReadContext;
import com.fasterxml.jackson.dataformat.avro.deser.MissingReader;
import java.io.IOException;
import java.io.Writer;

public abstract class AvroParser
extends ParserBase {
    protected ObjectCodec _objectCodec;
    protected AvroSchema _rootSchema;
    protected int _formatFeatures;
    protected AvroReadContext _avroContext;

    protected AvroParser(IOContext ctxt, int parserFeatures, int avroFeatures, ObjectCodec codec) {
        super(ctxt, parserFeatures);
        this._objectCodec = codec;
        this._formatFeatures = avroFeatures;
        this._avroContext = MissingReader.instance;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public abstract Object getInputSource();

    public abstract JsonParser overrideFormatFeatures(int var1, int var2);

    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void _finishString() throws IOException {
        this._reportUnsupportedOperation();
    }

    protected abstract void _closeInput() throws IOException;

    public JsonParser enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public JsonParser disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public JsonParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof AvroSchema;
    }

    public AvroSchema getSchema() {
        return this._rootSchema;
    }

    public void setSchema(FormatSchema schema) {
        if (this._rootSchema == schema) {
            return;
        }
        if (schema instanceof AvroSchema) {
            try {
                this._initSchema((AvroSchema)schema);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + schema.getClass().getName());
        }
    }

    protected abstract void _initSchema(AvroSchema var1) throws JsonProcessingException;

    public boolean canReadTypeId() {
        return true;
    }

    public Object getTypeId() throws IOException {
        return this._avroContext != null ? this._avroContext.getTypeId() : null;
    }

    public JsonLocation getTokenLocation() {
        return null;
    }

    public JsonLocation getCurrentLocation() {
        return null;
    }

    public abstract JsonToken nextToken() throws IOException;

    public abstract boolean hasTextCharacters();

    public abstract String getText() throws IOException;

    public abstract int getText(Writer var1) throws IOException;

    public String getCurrentName() throws IOException {
        return this._avroContext.getCurrentName();
    }

    public void overrideCurrentName(String name) {
        JsonReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        try {
            ctxt.setCurrentName(name);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public char[] getTextCharacters() throws IOException {
        String text = this.getText();
        return text == null ? null : text.toCharArray();
    }

    public int getTextLength() throws IOException {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public Object getEmbeddedObject() throws IOException {
        return this._binaryValue;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + this._currToken + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public static enum Feature implements FormatFeature
    {
        AVRO_BUFFERING(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }
    }
}

