/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.control;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.fnexecution.v1.BeamFnControlGrpc;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.repackaged.direct_java.runners.fnexecution.control.FnApiControlClient;
import org.apache.beam.repackaged.direct_java.sdk.fn.server.FnService;
import org.apache.beam.repackaged.direct_java.sdk.fn.server.HeaderAccessor;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnApiControlClientPoolService
extends BeamFnControlGrpc.BeamFnControlImplBase
implements FnService {
    private static final Logger LOG = LoggerFactory.getLogger(FnApiControlClientPoolService.class);
    private final Object lock = new Object();
    private final ControlClientPool.Sink clientSink;
    private final HeaderAccessor headerAccessor;
    private final ConcurrentMap<String, BeamFnApi.ProcessBundleDescriptor> processBundleDescriptors = new ConcurrentHashMap<String, BeamFnApi.ProcessBundleDescriptor>();
    @GuardedBy(value="lock")
    private final Map<String, FnApiControlClient> vendedClients = new HashMap<String, FnApiControlClient>();
    @GuardedBy(value="lock")
    private boolean closed = false;

    private FnApiControlClientPoolService(ControlClientPool.Sink clientSink, HeaderAccessor headerAccessor) {
        this.clientSink = clientSink;
        this.headerAccessor = headerAccessor;
    }

    public static FnApiControlClientPoolService offeringClientsToPool(ControlClientPool.Sink clientPool, HeaderAccessor headerAccessor) {
        return new FnApiControlClientPoolService(clientPool, headerAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamObserver<BeamFnApi.InstructionResponse> control(StreamObserver<BeamFnApi.InstructionRequest> requestObserver) {
        String workerId = this.headerAccessor.getSdkWorkerId();
        LOG.info("Beam Fn Control client connected with id {}", (Object)workerId);
        FnApiControlClient newClient = FnApiControlClient.forRequestObserver(workerId, requestObserver, this.processBundleDescriptors);
        try {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"%s already closed", (Object)FnApiControlClientPoolService.class.getSimpleName());
                this.vendedClients.put(workerId, newClient);
            }
            this.clientSink.put(this.headerAccessor.getSdkWorkerId(), newClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newClient.asResponseObserver();
    }

    public void getProcessBundleDescriptor(BeamFnApi.GetProcessBundleDescriptorRequest request, StreamObserver<BeamFnApi.ProcessBundleDescriptor> responseObserver) {
        String bundleDescriptorId = request.getProcessBundleDescriptorId();
        LOG.info("getProcessBundleDescriptor request with id {}", (Object)bundleDescriptorId);
        BeamFnApi.ProcessBundleDescriptor descriptor = (BeamFnApi.ProcessBundleDescriptor)this.processBundleDescriptors.get(bundleDescriptorId);
        if (descriptor == null) {
            String msg = String.format("ProcessBundleDescriptor with id %s not found", bundleDescriptorId);
            responseObserver.onError((Throwable)new StatusException(Status.NOT_FOUND.withDescription(msg)));
            LOG.error(msg);
        } else {
            responseObserver.onNext((Object)descriptor);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                for (FnApiControlClient vended : this.vendedClients.values()) {
                    vended.close();
                }
            }
        }
    }
}

