/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class ReplacementOutputs {
    private ReplacementOutputs() {
    }

    public static Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> singleton(Map<TupleTag<?>, PCollection<?>> original, POutput replacement) {
        Map.Entry originalElement = (Map.Entry)Iterables.getOnlyElement(original.entrySet());
        Map.Entry replacementElement = (Map.Entry)Iterables.getOnlyElement(PValues.expandOutput(replacement).entrySet());
        return Collections.singletonMap((PCollection)replacementElement.getValue(), PTransformOverrideFactory.ReplacementOutput.of(TaggedPValue.of((TupleTag)originalElement.getKey(), (PCollection)originalElement.getValue()), TaggedPValue.of((TupleTag)replacementElement.getKey(), (PCollection)replacementElement.getValue())));
    }

    public static Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> tagged(Map<TupleTag<?>, PCollection<?>> original, POutput replacement) {
        HashMap originalTags = new HashMap();
        for (Map.Entry<TupleTag<?>, PCollection<?>> originalValue : original.entrySet()) {
            originalTags.put(originalValue.getKey(), TaggedPValue.of(originalValue.getKey(), originalValue.getValue()));
        }
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        HashMap remainingTaggedOriginals = new HashMap(original);
        Map<TupleTag<?>, PCollection<?>> taggedReplacements = PValues.expandOutput(replacement);
        for (Map.Entry<TupleTag<?>, PCollection<?>> replacementValue : taggedReplacements.entrySet()) {
            TaggedPValue mapped = (TaggedPValue)originalTags.get(replacementValue.getKey());
            Preconditions.checkArgument((mapped != null ? 1 : 0) != 0, (String)"Missing original output for Tag %s and Value %s Between original %s and replacement %s", replacementValue.getKey(), replacementValue.getValue(), original, replacement.expand());
            resultBuilder.put(replacementValue.getValue(), (Object)PTransformOverrideFactory.ReplacementOutput.of(mapped, TaggedPValue.of(replacementValue.getKey(), replacementValue.getValue())));
            remainingTaggedOriginals.remove(replacementValue.getKey());
        }
        Preconditions.checkArgument((boolean)remainingTaggedOriginals.isEmpty(), (String)"Missing replacement for tagged values %s. Replacement was: %s", remainingTaggedOriginals, taggedReplacements);
        return resultBuilder.build();
    }
}

